package de.duehl.vocabulary.japanese.common.data;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

public class InternalAdditionalVocableDataTest {

    @Test
    public void emptyListToStorageString() {
        InternalAdditionalVocableData data = new InternalAdditionalVocableData();
        String actual = data.lastTenJapaneseToGermanTestResultsToStorageString();
        String expected = "";
        assertEquals(expected, actual);
    }

    // TODO andere Richtung testen


    @Test
    public void emptyStorageStringToEmptyListJapaneseToGerman() {
        InternalAdditionalVocableData data = new InternalAdditionalVocableData();
        data.testedJapaneseToGermanWithoutSave(false);
        data.testedJapaneseToGermanWithoutSave(true);
        data.testedJapaneseToGermanWithoutSave(false);
        data.initLastTenJapaneseToGermanTestResultsFromStorageString("");
        String actual = data.lastTenJapaneseToGermanTestResultsToStorageString();
        String expected = "";
        assertEquals(expected, actual);
    }

    @Test
    public void falseTrueFalseToStorageStringJapaneseToGerman() {
        InternalAdditionalVocableData data = new InternalAdditionalVocableData();
        data.testedJapaneseToGermanWithoutSave(false);
        data.testedJapaneseToGermanWithoutSave(true);
        data.testedJapaneseToGermanWithoutSave(false);
        String actual = data.lastTenJapaneseToGermanTestResultsToStorageString();
        String expected = "-+-";
        assertEquals(expected, actual);
    }

    @Test
    public void falseTrueFalseToFalseTrueFalseJapaneseToGerman() {
        InternalAdditionalVocableData data = new InternalAdditionalVocableData();
        data.initLastTenJapaneseToGermanTestResultsFromStorageString("-+-");
        String actual = data.lastTenJapaneseToGermanTestResultsToStorageString();
        String expected = "-+-";
        assertEquals(expected, actual);
    }

    @Test
    public void emptyStorageStringToEmptyListGermanToJapanese() {
        InternalAdditionalVocableData data = new InternalAdditionalVocableData();
        data.testedGermanToJapaneseWithoutSave(false);
        data.testedGermanToJapaneseWithoutSave(true);
        data.testedGermanToJapaneseWithoutSave(false);
        data.initLastTenGermanToJapaneseTestResultsFromStorageString("");
        String actual = data.lastTenGermanToJapaneseTestResultsToStorageString();
        String expected = "";
        assertEquals(expected, actual);
    }

    @Test
    public void falseTrueFalseToStorageStringGermanToJapanese() {
        InternalAdditionalVocableData data = new InternalAdditionalVocableData();
        data.testedGermanToJapaneseWithoutSave(false);
        data.testedGermanToJapaneseWithoutSave(true);
        data.testedGermanToJapaneseWithoutSave(false);
        String actual = data.lastTenGermanToJapaneseTestResultsToStorageString();
        String expected = "-+-";
        assertEquals(expected, actual);
    }

    @Test
    public void falseTrueFalseToFalseTrueFalseGermanToJapanese() {
        InternalAdditionalVocableData data = new InternalAdditionalVocableData();
        data.initLastTenGermanToJapaneseTestResultsFromStorageString("-+-");
        String actual = data.lastTenGermanToJapaneseTestResultsToStorageString();
        String expected = "-+-";
        assertEquals(expected, actual);
    }

}
