package de.duehl.vocabulary.japanese.common.website.update.vocables;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

public class VocablesActualityCheckerTest {

    @Test
    void determineLocalVocableVersionNormal() {
        String localVocableDirectory = "c:\\Users\\setup\\Daten\\sprachen\\japanisch\\vokabeln";
        String actual = VocablesActualityChecker.determineLocalVocableVersion(localVocableDirectory);
        String expected = "20250610_3";
        assertEquals(expected, actual);
    }

    @Test
    void determineLocalVocableVersionSubdirTest() {
        String localVocableDirectory = "c:\\temp\\vok_test";
        String actual = VocablesActualityChecker.determineLocalVocableVersion(localVocableDirectory);
        String expected = "20241024_1";
        assertEquals(expected, actual);
    }

}
