package de.duehl.vocabulary.japanese.data.symbol;

/**
 * Diese Klasse steht für ein Hiragana- oder Katakana-Zeichen.
 *
 * @version 1.01     2024-10-02
 * @author Christian Dühl
 */

public class Kana {

    /** Das Zeichen in UTF-8 Darstellung. */
    private final String character;

    /** Die Hepburn-Darstellung in lateinischen Buchstaben. */
    private final String hepburn;

    /**
     * Konstruktor.
     *
     * @param character
     *            Das Zeichen in UTF-8 Darstellung.
     * @param hepburn
     *            Die Hepburn-Darstellung in lateinischen Buchstaben.
     */
    public Kana(String character, String hepburn) {
        this.character = character;
        this.hepburn = hepburn;
    }

    /** Getter für das Zeichen in UTF-8 Darstellung. */
    public String getCharacter() {
        return character;
    }

    /** Getter für die Hepburn-Darstellung in lateinischen Buchstaben. */
    public String getHepburn() {
        return hepburn;
    }

}
