package de.duehl.vocabulary.japanese.io;

import java.util.ArrayList;
import java.util.List;

import de.duehl.basics.io.FileHelper;
import de.duehl.vocabulary.japanese.data.KanjiSet;

/**
 * Diese Klasse liest alle (Teil-) Mengen von Kanji, die der Benutzer definiert hat, aus Dateien.
 *
 * @version 1.01     2024-12-09
 * @author Christian Dühl
 */

public class AllKanjiSetsReader {

    /** Liest alle Kanji-Mengen ein. */
    public static List<KanjiSet> read() {
        FileHelper.createDirectoryIfNotExists(KanjiSet.KANJI_SET_DIRECTORY);

        List<String> filenames = FileHelper.findFilesInMainDirectoryNio2WithExtensions(
                KanjiSet.KANJI_SET_DIRECTORY, KanjiSet.KANJI_SET_EXTENSION);

        List<KanjiSet> kanjiSets = new ArrayList<>();

        for (String filename : filenames) {
            KanjiSet kanjiSet = KanjiSetReader.read(filename);
            kanjiSets.add(kanjiSet);
        }

        return kanjiSets;
    }

}
