package de.duehl.vocabulary.japanese.io;

import java.util.ArrayList;
import java.util.List;

import de.duehl.basics.io.FileHelper;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;

/**
 * Diese Klasse liest in einem Verzeichnis und seinen Unterverzeichnissen alle Dateien mit
 * Vokabularien ein.
 *
 * @version 1.01     2024-03-19
 * @author Christian Dühl
 */

public class VocabularyDirectoryReader {

    /** Das Verzeichnis mit den den Vokabeln mit Pfad. */
    private final String directory;

    /** Die Liste der eingelesenen Vokabulare. */
    private List<Vocabulary> vocabularies;

    /**
     * Konstruktor.
     *
     * @param directory
     *            Das Verzeichnis mit den den Vokabeln mit Pfad.
     */
    public VocabularyDirectoryReader(String directory) {
        this.directory = directory;
    }

    /** Führt das Einlesen durch. */
    public void read() {
        //List<String> filenames = FileHelper.findFilesInMainDirectoryNio2(directory, ".voc");
        List<String> filenames = FileHelper.findFiles(directory, ".voc");
        vocabularies = new ArrayList<>();

        for (String filename : filenames) {
            readVocabulary(filename);
        }
    }

    private void readVocabulary(String filename) {
        VocabularyReader reader = new VocabularyReader(filename);
        reader.read();
        List<Vocable> vocables = reader.getVocables();
        String description = VocabularyTools.vocabularyFilenameToDescription(filename);
        String category = reader.getVocabularyCategory();
        String subCategory = reader.getVocabularySubCategory();

        Vocabulary vocabulary = new Vocabulary(description, vocables, category, subCategory);
        vocabularies.add(vocabulary);
    }

    /** Getter für die Liste der eingelesenen Vokabulare. */
    public List<Vocabulary> getVocabularies() {
        return vocabularies;
    }

}
