package de.duehl.vocabulary.japanese.logic.symbol.kana.test.data;

import de.duehl.vocabulary.japanese.data.symbol.Katakana;

/**
 * Diese Klasse stellt das Ergebnis der Bewertung einer einzelnen Abfrage eines Katakana dar
 *
 * @version 1.01     2025-02-02
 * @author Christian Dühl
 */

public class SingleUserInputKatakanaCheckResult {

    /** Das Katakana welches abgefragt wurde. */
    private final Katakana katakana;

    /** Die Beschreibung der Fehler, fall welche gemacht wurden. */
    private String errorDescription;

    /** Gibt an, ob alles richtig ist. */
    private boolean ok;

    /** Konstruktor. */
    public SingleUserInputKatakanaCheckResult(Katakana katakana) {
        this.katakana = katakana;

        ok = true;
        errorDescription = "";
    }

    /** Getter für das Katakana welches abgefragt wurde. */
    public Katakana getKatakana() {
        return katakana;
    }

    /** Getter für die Beschreibung der Fehler, fall welche gemacht wurden. */
    public String getErrorDescription() {
        return errorDescription;
    }

    /** Setter für die Beschreibung der Fehler, fall welche gemacht wurden. */
    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    /** Gibt an, ob alles richtig ist. */
    public boolean isOk() {
        return ok;
    }

    /** Legt fest, ob alles richtig ist. */
    public void setOk(boolean ok) {
        this.ok = ok;
    }

    @Override
    public String toString() {
        return "SingleUserInputKatakanaCheckResult [katakana=" + katakana + ", errorDescription="
                + errorDescription + ", ok=" + ok + "]";
    }

}
