package de.duehl.vocabulary.japanese.logic.symbol.kanji.internal;

import java.util.Map;

import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanjiData;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;

/**
 * Diese Klasse kann zu einem Kanji die internen, benutzerabhängigen Daten abrufen.
 *
 * @version 1.01     2024-11-07
 * @author Christian Dühl
 */

public class RealInternalKanjiDataRequester implements InternalKanjiDataRequester {

    /**
     * Das Verzeichnis der internen Daten zu einem Kanji nach dem dem Schlüssel des zugehörigen
     * Kanji.
     */
    private final Map<String, InternalAdditionalKanjiData> key2InternalKanjiDataMap;

    /**
     * Konstruktor.
     *
     * @param key2InternalKanjiDataMap
     *            Das Verzeichnis der internen Daten zu einem Kanji nach dem Schlüssel des
     *            zugehörigen Kanji.
     */
    public RealInternalKanjiDataRequester(
            Map<String, InternalAdditionalKanjiData> key2InternalKanjiDataMap) {
        this.key2InternalKanjiDataMap = key2InternalKanjiDataMap;
    }

    /**
     * Gibt die internen Daten zum übergebenen Kanji zurück.
     *
     * Sind zu der Kanji keine internen Daten hinterlegt, so wird eine Ausnahme geworfen.
     *
     * @param kanji
     *            Die Kanji zu der man die internen Daten ermitteln möchte.
     * @return Die internen Daten zur übergebenen Kanji.
     */
    @Override
    public InternalAdditionalKanjiData getInternalDataForKanji(Kanji kanji) {
        String key = kanji.name();
        if (key2InternalKanjiDataMap.containsKey(key)) {
            return key2InternalKanjiDataMap.get(key);
        }
        else {
            throw new RuntimeException(""
                    + "Das Verzeichnis der internen Daten zu einem Kanji nach dem dem Schlüssel "
                    + "des zugehörigen Kanji enthält keinen Eintrag für das übergebene Kanji.\n"
                    + "\t" + "kanji: " + kanji + "\n"
                    + "\t" + "key  : " + key + "\n"
                    );
        }
    }

}
