package de.duehl.vocabulary.japanese.logic.symbol.kanji.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;

/**
 * Diese Klasse erzeugt den Text für eine zufällig sortierte Abfrageliste mit den Kanji von der
 * deutschen Bedeutung aus.
 *
 * @version 1.01     2026-01-01
 * @author Christian Dühl
 */

public class KanjiTestListFromGermanMeaningCreator {

    /** Erzeugt den Text für eine zufällig sortierte Abfrageliste mit den Kanji. */
    public static String createKanjiTestList() {
        List<Kanji> kanjiList = CollectionsHelper.arrayToList(Kanji.values());

        List<String> germanDescriptions = new ArrayList<>();
        Map<String, Integer> germanDescriptionToNumber = new HashMap<>();
        int maxLength = 0;
        for (int index = 0; index < kanjiList.size(); ++index) {
            Kanji kanji = kanjiList.get(index);
            int number = index + 1;
            String germanDescription = Text.joinWithCommaAndBlank(kanji.getGermanMeanings());
            germanDescriptions.add(germanDescription);
            int length = germanDescription.length();
            if (maxLength < length) {
                maxLength = length;
            }
            germanDescriptionToNumber.put(germanDescription, number);
        }
        Collections.shuffle(germanDescriptions);

        String maxNumberString = Integer.toString(kanjiList.size());
        int maxNumberLength = maxNumberString.length();

        StringBuilder builder = new StringBuilder();
        builder.append("Kanji-Übungsliste");
        builder.append("\n");
        for (String germanDescription : germanDescriptions) {
            builder.append("\n");
            int number = germanDescriptionToNumber.get(germanDescription);
            String numberString = Integer.toString(number);
            builder.append(Text.fillWithSpacesAtFront(numberString, maxNumberLength));
            builder.append(") ");
            builder.append(Text.fillWithSpaces(germanDescription, maxLength));
            builder.append("   ");
            builder.append("ON ______________________");
            builder.append(" ");
            builder.append("kun ______________________");
            builder.append("   ");
            builder.append("Kanji __");
            builder.append("   ");
            builder.append("_   _");
            builder.append("\n");
        }

        return builder.toString();
    }

}
