package de.duehl.vocabulary.japanese.startup.logic.steps;

import java.util.List;
import java.util.Map;

import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.ownlists.KeyToVocableMapCreator;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.startup.ui.data.SplashScreenable;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;

/**
 * Diese Klasse steht für den Schritt der Verwaltung der eigenen Listen erstellt.
 *
 * @version 1.01     2025-11-23
 * @author Christian Dühl
 */

public class Step09InitOwnLists extends StartupStep {

    /** Die grafische Oberfläche. */
    private final VocabularyTrainerGui gui;

    /** Die Liste mit den bekannten Vokabularien. */
    private final List<Vocabulary> vocabularies;

    /** Das Objekt das zu Vokabeln die internen Daten abfragt. */
    private final InternalDataRequester internalDataRequester;

    /** Das Verzeichnis der Vokabeln nach ihrem Schlüssel. */
    private Map<String, Vocable> keyToVocable;

    /** Die Verwaltung der eigenen Vokabellisten. */
    private OwnLists ownLists;

    /**
     * Konstruktor.
     *
     * @param step
     *            Der Schritt der durchgeführt wird.
     * @param gui
     *            Die grafische Oberfläche.
     * @param options
     *            Die Programmoptionen.
     * @param splashScreen
     *            Die grafische Oberfläche beim Start in der die Meldungen angezeigt werden.
     * @param watch
     *            Misst die Laufzeit des gesamten Startups.
     * @param vocabularies
     *            Die Liste mit den bekannten Vokabularien.
     * @param internalDataRequester
     *            Das Objekt das zu Vokabeln die internen Daten abfragt.
     */
    public Step09InitOwnLists(String step, VocabularyTrainerGui gui, Options options,
            SplashScreenable splashScreen, StopWatch watch, List<Vocabulary> vocabularies,
            InternalDataRequester internalDataRequester) {
        super(step, options, splashScreen, watch);
        this.gui = gui;
        this.vocabularies = vocabularies;
        this.internalDataRequester = internalDataRequester;
    }

    /** Führt den eigentlichen Inhalt des Schritts aus. */
    @Override
    protected void runInternalStep() {
        appendMessage("Erzeuge Verzeichnis Schlüssel zu Vokabel ...");
        KeyToVocableMapCreator creator = new KeyToVocableMapCreator(vocabularies,
                internalDataRequester);
        creator.create();
        keyToVocable = creator.getKeyToVocable();

        appendMessage("Erzeuge Verwaltung der eigene Listen ...");
        ownLists = new OwnLists(vocabularies, keyToVocable, internalDataRequester, options, gui);
    }

    public Map<String, Vocable> getKeyToVocable() {
        return keyToVocable;
    }

    /** Getter für das Verzeichnis der Vokabeln nach ihrem Schlüssel. */
    public void setKeyToVocable(Map<String, Vocable> keyToVocable) {
        this.keyToVocable = keyToVocable;
    }

    /** Getter für die Verwaltung der eigenen Vokabellisten. */
    public OwnLists getOwnLists() {
        return ownLists;
    }

}
