package de.duehl.vocabulary.japanese.startup.logic.steps;

import java.util.List;

import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.io.InternalKanjiDataReader;
import de.duehl.vocabulary.japanese.startup.ui.data.MessageAppender;
import de.duehl.vocabulary.japanese.startup.ui.data.SplashScreenable;

/**
 * Diese Klasse steht für den Schritt zum Einlesen der internen Daten zu den Kanji beim Startup
 * des Vokabeltrainers.
 *
 * @version 1.01     2025-11-24
 * @author Christian Dühl
 */

public class Step12ReadInternalKanjiData extends StartupStep {

    /** Das Objekt, das zu einem Kanji die internen, benutzerabhängigen Daten abrufen kann. */
    private InternalKanjiDataRequester internalKanjiDataRequester;

    /**
     * Konstruktor.
     *
     * @param step
     *            Der Schritt der durchgeführt wird.
     * @param options
     *            Die Programmoptionen.
     * @param splashScreen
     *            Die grafische Oberfläche beim Start in der die Meldungen angezeigt werden.
     * @param watch
     *            Misst die Laufzeit des gesamten Startups.
     */
    public Step12ReadInternalKanjiData(String step, Options options, SplashScreenable splashScreen,
            StopWatch watch) {
        super(step, options, splashScreen, watch);
    }

    /** Führt den eigentlichen Inhalt des Schritts aus. */
    @Override
    protected void runInternalStep() {
        appendMessage("Lade Kanji-Daten dees Benutzers ...");
        InternalKanjiDataReader reader = new InternalKanjiDataReader((MessageAppender) this);
        reader.read();
        internalKanjiDataRequester = reader.getRequester();
        List<String> warningLines = reader.getWarningLines();
        if (!warningLines.isEmpty()) {
            String warningsString = Text.joinWithLineBreak(warningLines);
            warningsInStep(warningsString);
        }
    }

    /**
     * Getter für das Objekt, das zu einem Kanji die internen, benutzerabhängigen Daten abrufen
     * kann.
     */
    public InternalKanjiDataRequester getInternalKanjiDataRequester() {
        return internalKanjiDataRequester;
    }

}
