package de.duehl.vocabulary.japanese.ui.creation.menu;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JMenu;
import javax.swing.JMenuItem;

import de.duehl.swing.ui.menu.MyMenuItem;
import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;

/**
 * Diese Klasse erzeugt das Kana und Kanji-Menü der graphischen Oberfläche des Vokabel-Trainers.
 *
 * @version 1.01     2025-12-09
 * @author Christian Dühl
 */

public class KanaAndKanjiMenuCreation implements SingleMenuCreation {

    /** Verbindung zur grafischen Oberfläche. */
    private final VocabularyTrainerGui gui;

    /**
     * Konstruktor.
     *
     * @param gui
     *            Verbindung zur grafischen Oberfläche.
     */
    public KanaAndKanjiMenuCreation(VocabularyTrainerGui gui) {
        this.gui = gui;
    }

    /** Erzeugt das Kana und Kanji-Menü. */
    @Override
    public JMenu createTheMenu() {
        JMenu menu = new JMenu("Kana und Kanji");
        menu.setMnemonic('k');

        menu.add(createShowHiraganaMenuItem());
        menu.add(createShowKatakanaMenuItem());
        menu.addSeparator();

        menu.add(createShowHiraganaInBrowserMenuItem());
        menu.add(createShowKatakanaInBrowserMenuItem());

        menu.addSeparator();

        menu.add(createShowHiraganaTableMenuItem());
        menu.add(createShowKatakanaTableMenuItem());
        menu.add(createCreateHiraganaTestFromKanjiMenuItem());
        menu.add(createCreateKatakanaTestFromKanjiMenuItem());

        menu.addSeparator();

        menu.add(createShowKanjiTableMenuItem());
        menu.add(createCreateKanjiTestFromGermanMeaningMenuItem());
        menu.add(createCreateKanjiTestFromKanjiMenuItem());

        menu.addSeparator();

        menu.add(createManageKanjiSetsMenuItem());

        menu.addSeparator();

        menu.add(createSearchKanjiByOnLesungMenuItem());
        menu.add(createSearchKanjiByKunLesungMenuItem());
        menu.add(createSearchKanjiByAnyLesungMenuItem());
        menu.add(createSearchKanjiByGermanMeaningMenuItem());
        menu.add(createSearchKanjiByAnyMenuItem());

        return menu;
    }

    private JMenuItem createShowHiraganaMenuItem() {
        return new MyMenuItem("Hiragana anzeigen ...")
                .mnemonic('h')
                //.accelerator(KeyEvent.VK_K, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showHiragana());
    }

    private JMenuItem createShowKatakanaMenuItem() {
        return new MyMenuItem("Katakana anzeigen ...")
                .mnemonic('n')
                //.accelerator(KeyEvent.VK_K, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showKatakana());
    }

    private JMenuItem createShowHiraganaInBrowserMenuItem() {
        return new MyMenuItem("Hiragana im Browser anzeigen ...")
                .mnemonic('h')
                //.accelerator(KeyEvent.VK_K, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showHiraganaInBrowser());
    }

    private JMenuItem createShowKatakanaInBrowserMenuItem() {
        return new MyMenuItem("Katakana im Browser anzeigen ...")
                .mnemonic('b')
                //.accelerator(KeyEvent.VK_K, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showKatakanaInBrowser());
    }

    private JMenuItem createShowHiraganaTableMenuItem() {
        return new MyMenuItem("Hiragana-Tabelle anzeigen ...")
                //.mnemonic('t')
                //.accelerator(KeyEvent.VK_K, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showHiraganaTable());
    }

    private JMenuItem createShowKatakanaTableMenuItem() {
        return new MyMenuItem("Katakana-Tabelle anzeigen ...")
                //.mnemonic('t')
                //.accelerator(KeyEvent.VK_K, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showKatakanaTable());
    }

    private JMenuItem createCreateHiraganaTestFromKanjiMenuItem() {
        return new MyMenuItem("Hiragana abfragen ...")
                .mnemonic('h')
                //.accelerator(KeyEvent.VK_K, InputEvent.CTRL_DOWN_MASK | InputEvent.ALT_DOWN_MASK)
                .actionListener(e -> gui.createHiraganaTest());
    }

    private JMenuItem createCreateKatakanaTestFromKanjiMenuItem() {
        return new MyMenuItem("Katakana abfragen ...")
                .mnemonic('k')
                //.accelerator(KeyEvent.VK_K, InputEvent.CTRL_DOWN_MASK | InputEvent.ALT_DOWN_MASK)
                .actionListener(e -> gui.createKatakanaTest());
    }

    private JMenuItem createShowKanjiTableMenuItem() {
        return new MyMenuItem("Kanji-Tabelle anzeigen ...")
                .mnemonic('t')
                .accelerator(KeyEvent.VK_K, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.showKanjiTable());
    }

    private JMenuItem createCreateKanjiTestFromGermanMeaningMenuItem() {
        return new MyMenuItem("Kanji Abfrageliste von der deutschen Bedeutung aus erstellen ...")
                .mnemonic('a')
                //.accelerator(KeyEvent.VK_F8, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.createKanjiTestFromGermanMeaning());
    }

    private JMenuItem createCreateKanjiTestFromKanjiMenuItem() {
        return new MyMenuItem("Kanji abfragen (ausgehend vom Zeichen hier im Programm) ...")
                .mnemonic('f')
                .accelerator(KeyEvent.VK_K, InputEvent.CTRL_DOWN_MASK | InputEvent.ALT_DOWN_MASK)
                .actionListener(e -> gui.createKanjiTestFromKanji());
    }

    private JMenuItem createManageKanjiSetsMenuItem() {
        return new MyMenuItem("Kanji-Mengen bearbeiten ...")
                .mnemonic('m')
                .accelerator(KeyEvent.VK_M, InputEvent.CTRL_DOWN_MASK | InputEvent.ALT_DOWN_MASK)
                .actionListener(e -> gui.manageKanjiSets());
    }

    private JMenuItem createSearchKanjiByOnLesungMenuItem() {
        return new MyMenuItem("Über On-Lesung nach Kanji suchen ...")
                //.mnemonic('m')
                //.accelerator(KeyEvent.VK_M, InputEvent.CTRL_DOWN_MASK | InputEvent.ALT_DOWN_MASK)
                .actionListener(e -> gui.searchKanjiByOnLesung());
    }

    private JMenuItem createSearchKanjiByKunLesungMenuItem() {
        return new MyMenuItem("Über Kun-Lesung nach Kanji suchen ...")
                //.mnemonic('m')
                //.accelerator(KeyEvent.VK_M, InputEvent.CTRL_DOWN_MASK | InputEvent.ALT_DOWN_MASK)
                .actionListener(e -> gui.searchKanjiByKunLesung());
    }

    private JMenuItem createSearchKanjiByAnyLesungMenuItem() {
        return new MyMenuItem("Über eine beliebige Lesung nach Kanji suchen ...")
                //.mnemonic('m')
                //.accelerator(KeyEvent.VK_M, InputEvent.CTRL_DOWN_MASK | InputEvent.ALT_DOWN_MASK)
                .actionListener(e -> gui.searchKanjiByAnyLesung());
    }

    private JMenuItem createSearchKanjiByGermanMeaningMenuItem() {
        return new MyMenuItem("Über eine deutsche Bedeutung nach Kanji suchen ...")
                //.mnemonic('m')
                //.accelerator(KeyEvent.VK_M, InputEvent.CTRL_DOWN_MASK | InputEvent.ALT_DOWN_MASK)
                .actionListener(e -> gui.searchKanjiByGermanMeaning());
    }

    private JMenuItem createSearchKanjiByAnyMenuItem() {
        return new MyMenuItem("Nach beliebigem Inhalt nach Kanji suchen ...")
                .mnemonic('s')
                .accelerator(KeyEvent.VK_K, InputEvent.CTRL_DOWN_MASK | InputEvent.SHIFT_DOWN_MASK)
                .actionListener(e -> gui.searchKanjiByAny());
    }

}
