package de.duehl.vocabulary.japanese.ui.creation.menu;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JMenu;
import javax.swing.JMenuItem;

import de.duehl.swing.ui.menu.MyMenuItem;
import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;

/**
 * Diese Klasse erzeugt das Eigene Listen-Menü der graphischen Oberfläche des Umbruch-Editors.
 *
 * @version 1.01     2025-11-17
 * @author Christian Dühl
 */

public class OwnListMenuCreation implements SingleMenuCreation {

    /** Verbindung zur grafischen Oberfläche. */
    private final VocabularyTrainerGui gui;

    /**
     * Konstruktor.
     *
     * @param gui
     *            Verbindung zur grafischen Oberfläche.
     */
    public OwnListMenuCreation(VocabularyTrainerGui gui) {
        this.gui = gui;
    }

    /** Erzeugt das Vokabularien-Menü. */
    @Override
    public JMenu createTheMenu() {
        JMenu menu = new JMenu("Eigene Listen");
        menu.setMnemonic('l');

        menu.add(createCreateNewOwnListMenuItem());
        menu.add(createToggleShowOwnListButtonsMenuItem());

        menu.addSeparator();

        menu.add(createImportOwnListsMenuItem());
        menu.add(createExportOwnListsMenuItem());
        menu.add(createExportAllOwnListsMenuItem());

        menu.addSeparator();

        menu.add(createListCommanderMenuItem());

        menu.addSeparator();

        menu.add(createImportOwnListsGroupsFromWebsiteMenuItem());

        return menu;
    }

    private JMenuItem createCreateNewOwnListMenuItem() {
        return new MyMenuItem("Eine neue eigene Liste anlegen")
                .mnemonic('b')
                .accelerator(KeyEvent.VK_F4, 0)
                .actionListener(e -> gui.createNewOwnList());
    }

    private JMenuItem createToggleShowOwnListButtonsMenuItem() {
        return new MyMenuItem("Buttons zum Exportieren, Bearbeiten und Löschen von eigenen Listen "
                + "ein oder ausschalten")
                .mnemonic('e')
                .accelerator(KeyEvent.VK_F3, 0)
                .actionListener(e -> gui.toggleShowOwnListButtons());
    }

    private JMenuItem createImportOwnListsMenuItem() {
        return new MyMenuItem("Eigene Vokabellisten importieren ...")
                .mnemonic('i')
                //.accelerator(KeyEvent.VK_F4, 0)
                .actionListener(e -> gui.importOwnList());
    }

    private JMenuItem createExportOwnListsMenuItem() {
        return new MyMenuItem("Eigene Vokabellisten exportieren ...")
                .mnemonic('x')
                //.accelerator(KeyEvent.VK_F4, 0)
                .actionListener(e -> gui.exportOwnLists());
    }

    private JMenuItem createExportAllOwnListsMenuItem() {
        return new MyMenuItem("Alle eigenen Vokabellisten exportieren ...")
                .mnemonic('a')
                //.accelerator(KeyEvent.VK_F4, 0)
                .actionListener(e -> gui.exportAllOwnLists());
    }

    private JMenuItem createListCommanderMenuItem() {
        return new MyMenuItem("Listen-Commander öffnen ...")
                .mnemonic('c')
                .accelerator(KeyEvent.VK_F7, InputEvent.CTRL_DOWN_MASK)
                .actionListener(e -> gui.openListCommander());
    }

    private JMenuItem createImportOwnListsGroupsFromWebsiteMenuItem() {
        return new MyMenuItem("Gruppen von eigenen Vokabellisten von der Webseite importieren ...")
                .mnemonic('i')
                //.accelerator(KeyEvent.VK_F4, 0)
                .actionListener(e -> gui.importGroupsOfOwnListsFromWebsite());
    }

}
