package de.duehl.vocabulary.japanese.ui.dialog.kana.katakanatest.components;

import java.awt.Color;

import javax.swing.JLabel;

import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.data.symbol.Katakana;

/**
 * Diese Klasse stellt ein einzelnes Katakana-Zeichen (UTF-8) in einem Label dar.
 *
 * @version 1.01     2025-02-02
 * @author Christian Dühl
 */

public class KatakanaLabel {

    private static final int DEFAULT_BIGGER_FONT_SIZE = 400;


    /** Die Vergrößerung der Schrift in der das Katakana dargestellt wird. */
    private int biggerFontSize;

    /** Das Label auf dem das Katakana dargestellt wird. */
    private final JLabel label;

    /** Gibt an, ob die Größe schon gesetzt wurde. */
    private boolean sizeSet;

    /** Konstruktor. */
    public KatakanaLabel() {
        biggerFontSize = DEFAULT_BIGGER_FONT_SIZE;

        label = new JLabel();
        sizeSet = false;

        initLabel();
    }

    private void initLabel() {
        label.setOpaque(true);
        label.setBackground(Color.WHITE);
        label.setHorizontalAlignment(JLabel.CENTER);
        label.setVerticalAlignment(JLabel.CENTER);
    }

    /** Setter für die Vergrößerung der Schrift in der das Katakana dargestellt wird. */
    public void setBiggerFontSize(int biggerFontSize) {
        this.biggerFontSize = biggerFontSize;
    }

    /** Zeigt das Katakana an. Kann mehrfach aufgerufen werden. */
    public void showKatakana(Katakana katakana) {
        setSizeIfNecessary();

        String katakanaCharacter = katakana.getCharacter();
        label.setText(katakanaCharacter);
    }

    private void setSizeIfNecessary() {
        if (!sizeSet) {
            GuiTools.biggerFont(label, biggerFontSize);
            sizeSet = true;
        }
    }

    /** Getter für das Label auf dem das Katakana dargestellt wird. */
    public JLabel getLabel() {
        return label;
    }

}
