package de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjiset;

import de.duehl.vocabulary.japanese.data.KanjiSet;

/**
 * Dieses Interface steht für ein Objekt, dass die Bars mit den Kanji-Mengen neu zeichnen kann.
 *
 * Man kann sie umbenennen, bearbeiten oder löschen.
 *
 * @version 1.01     2024-11-20
 * @author Christian Dühl
 */

public interface KanjiSetBarsRefresher {

    /** Löscht die übergebene Kanji-Menge aus der Liste der Kanji-Mengen. */
    void deleteKanjiSetFromListAndFileFromDisk(KanjiSet kanjiSet);

    /** Stellt die Bars mit den Kanji-Mengen neu dar. */
    void refreshKanjiSetBars();

}
