package de.duehl.zipwithzip4j.start.direct;

import java.io.File;
import java.io.IOException;

import de.duehl.basics.io.FileHelper;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.AesKeyStrength;
import net.lingala.zip4j.model.enums.EncryptionMethod;

public class DirectZipTestZipFolderWithPassword {

    public static void main(String[] args) {
        String dir = "c:\\temp\\zip4j_test_1";

        String zipFilename = FileHelper.concatPathes(dir,
                "daten_per_Programm_verpackt_mit_passwort.zip");
        String directoryToZip = FileHelper.concatPathes(dir, "daten");
        String password = "Geheim";

        ZipParameters zipParameters = new ZipParameters();
        zipParameters.setEncryptFiles(true);
        zipParameters.setEncryptionMethod(EncryptionMethod.AES);
        // Below line is optional. AES 256 is used by default. You can override it to use AES 128.
        // AES 192 is supported only for extracting.
        zipParameters.setAesKeyStrength(AesKeyStrength.KEY_STRENGTH_256);

        try (ZipFile zip = new ZipFile(zipFilename, password.toCharArray())) {
            zip.addFolder(new File(directoryToZip), zipParameters);
        }
        catch (ZipException exception) {
            throw new RuntimeException(exception);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

}
