/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.datetime.time.watch;

import de.duehl.basics.datetime.time.TimeHelper;
import de.duehl.basics.datetime.time.watch.WatchBase;
import java.io.Serializable;

public class StopWatch
implements WatchBase,
Serializable {
    private static final long serialVersionUID = 1L;
    private long startTime;
    private boolean stopped;
    private long stopTime;

    public StopWatch() {
        this.start();
    }

    public StopWatch(StopWatch stopWatch) {
        this.startTime = stopWatch.startTime;
        this.stopped = stopWatch.stopped;
        this.stopTime = stopWatch.stopTime;
    }

    public void start() {
        this.startTime = TimeHelper.getCurrentTimeInMilliseconds();
        this.stopped = false;
    }

    @Override
    public String getTime() {
        return TimeHelper.secondsToHoursMinutesSeconds(this.getTimeInSeconds());
    }

    @Override
    public long getTimeInSeconds() {
        return this.getTimeInMilliSeconds() / 1000L;
    }

    long getTimeInMilliSeconds() {
        if (this.stopped) {
            return this.stopTime - this.startTime;
        }
        return TimeHelper.getCurrentTimeInMilliseconds() - this.startTime;
    }

    public void stop() {
        if (!this.stopped) {
            this.stopTime = TimeHelper.getCurrentTimeInMilliseconds();
            this.stopped = true;
        }
    }

    public void restart() {
        if (this.stopped) {
            long l = TimeHelper.getCurrentTimeInMilliseconds();
            long l2 = this.getTimeInMilliSeconds();
            this.startTime = l - l2;
            this.stopped = false;
            this.stopTime = 0L;
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public String toString() {
        return "StopWatch [" + this.getTime() + "]";
    }
}

