/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.retry;

import de.duehl.basics.logging.Logger;
import de.duehl.basics.random.Randomizer;
import de.duehl.basics.retry.Retryable;
import de.duehl.basics.system.ExceptionHelper;
import de.duehl.basics.system.SystemTools;

public class Retry {
    private static final int INITIAL_MAXIMUM_NUMBER_OF_TRIES = 10;
    private static final long INITIAL_MILLISECONDS_TO_SLEEP_BY_ERRORS = 250L;
    private final Retryable retryable;
    private final int maximumNumberOfTries;
    private final long millisecondsToSleepByErrors;
    private final Logger logger;
    private int tryCount;
    private boolean sucessfullyDone;
    private boolean allTriesFailed;
    private boolean randomizeSleepTime;
    private final Randomizer randomizer;

    public Retry(Retryable retryable) {
        this(retryable, 10, 250L, null);
    }

    public Retry(Retryable retryable, Logger logger) {
        this(retryable, 10, 250L, logger);
    }

    public Retry(Retryable retryable, int n, long l) {
        this(retryable, n, l, null);
    }

    public Retry(Retryable retryable, int n, long l, Logger logger) {
        this.retryable = retryable;
        this.maximumNumberOfTries = n;
        this.millisecondsToSleepByErrors = l;
        this.logger = logger;
        this.tryCount = 0;
        this.sucessfullyDone = false;
        this.allTriesFailed = false;
        this.randomizeSleepTime = false;
        this.randomizer = new Randomizer();
    }

    public void randomizeSleepTime() {
        this.randomizeSleepTime = true;
    }

    public void tryAndTry() {
        this.checkTryCountStart();
        this.loop();
    }

    private void checkTryCountStart() {
        if (this.tryCount != 0) {
            String string = "Diese Klasse darf nicht mehrfach verwendet werden!";
            this.log(string);
            throw new RuntimeException(string);
        }
    }

    private void loop() {
        while (!this.sucessfullyDone && !this.allTriesFailed) {
            ++this.tryCount;
            this.log("tryCount = '" + this.tryCount + "'");
            this.checkTryCountInLoop();
            if (this.allTriesFailed) continue;
            this.tryRetryable();
        }
    }

    private void checkTryCountInLoop() {
        if (this.tryCount > this.maximumNumberOfTries) {
            this.allTriesFailed = true;
            this.log("Zu viele Versuche!");
        }
    }

    private void tryRetryable() {
        block2: {
            try {
                this.retryable.tryIt();
                this.sucessfullyDone = true;
                this.log("Success!");
            }
            catch (Exception exception) {
                String string = "Beim Versuch, die Aufgabe zu erledigen trat eine Ausnahme auf: " + ExceptionHelper.getExceptionNameAndMessage(exception);
                this.log(string);
                if (this.tryCount >= this.maximumNumberOfTries) break block2;
                this.sleep();
            }
        }
    }

    private void sleep() {
        SystemTools.sleep(this.determineSleepTime());
    }

    private long determineSleepTime() {
        if (this.randomizeSleepTime) {
            return this.calculateRandomizedSleeptime();
        }
        return this.millisecondsToSleepByErrors;
    }

    private long calculateRandomizedSleeptime() {
        return this.randomizeFrom90To110Percent(this.millisecondsToSleepByErrors);
    }

    long randomizeFrom90To110Percent(long l) {
        return this.randomizer.randomizeFrom90To110Percent(l);
    }

    public final boolean haveAllTriesFailed() {
        return this.allTriesFailed;
    }

    public final boolean isSucessfullyDone() {
        return this.sucessfullyDone;
    }

    private void log(String string) {
        if (null != this.logger) {
            this.logger.log(string, 1);
        }
    }
}

