/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.system;

import de.duehl.basics.text.Text;
import de.duehl.basics.text.html.generation.HtmlBuilder;

public class ExceptionHelper {
    private ExceptionHelper() {
    }

    public static String getDescriptionWithStackTrace(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        Class<?> clazz = throwable.getClass();
        String string = clazz.getName();
        stringBuilder.append("Klassenname: ").append(string).append(Text.LINE_BREAK);
        String string2 = throwable.getMessage();
        stringBuilder.append("Nachricht  : ").append(string2).append(Text.LINE_BREAK);
        stringBuilder.append("Stack-Trace: ").append(Text.LINE_BREAK);
        int n = 0;
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            stringBuilder.append(String.format("%6d: ", ++n)).append(stackTraceElement.toString()).append(Text.LINE_BREAK);
        }
        Throwable throwable2 = throwable.getCause();
        if (null != throwable2) {
            stringBuilder.append("Cause      : ").append(Text.LINE_BREAK).append(ExceptionHelper.getDescriptionWithStackTrace(throwable2));
        }
        return stringBuilder.toString();
    }

    public static String getDescriptionWithStackTraceHtml(Throwable throwable) {
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        Class<?> clazz = throwable.getClass();
        String string = clazz.getName();
        htmlBuilder.appendP("Klassenname: " + string);
        String string2 = throwable.getMessage();
        htmlBuilder.appendP("Nachricht  : " + string2);
        htmlBuilder.appendP("Stack-Trace:");
        htmlBuilder.appendOpeningOl();
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            htmlBuilder.appendLi(stackTraceElement.toString());
        }
        htmlBuilder.appendClosingOl();
        Throwable throwable2 = throwable.getCause();
        if (null != throwable2) {
            htmlBuilder.appendP("Cause      :").append(ExceptionHelper.getDescriptionWithStackTraceHtml(throwable2));
        }
        return htmlBuilder.toString();
    }

    public static String getExceptionNameAndMessage(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Klasse der Ausnahme: " + throwable.getClass().getName()).append(", ").append("Fehlermeldung der Ausnahme: " + throwable.getMessage());
        Throwable throwable2 = throwable.getCause();
        if (null != throwable2) {
            stringBuilder.append(" (caused by: ").append(ExceptionHelper.getExceptionNameAndMessage(throwable2)).append(")");
        }
        return stringBuilder.toString();
    }
}

