/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Lines
implements Iterable<String> {
    private final List<String> lines = new ArrayList<String>();

    public Lines() {
    }

    public Lines(List<String> list) {
        this();
        this.lines.addAll(list);
    }

    public Lines(Lines lines) {
        this(lines.getLines());
    }

    public void add(String string) {
        this.lines.add(string);
    }

    public void addAll(Lines lines) {
        this.lines.addAll(lines.getLines());
    }

    public void addAll(List<String> list) {
        this.lines.addAll(list);
    }

    public String remove(int n) {
        return this.lines.remove(n);
    }

    @Override
    public Iterator<String> iterator() {
        return this.lines.iterator();
    }

    public List<String> getLines() {
        return this.lines;
    }

    public String joinWithLineBreak() {
        return Text.joinWithLineBreak(this.lines);
    }

    public int size() {
        return this.lines.size();
    }

    public String get(int n) {
        return this.lines.get(n);
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public void writeToFile(String string) {
        this.writeToFile(string, Charset.ISO_8859_1);
    }

    public void writeToFile(String string, Charset charset) {
        FileHelper.writeLinesToFile(this.lines, string, charset);
    }

    public void skipFirstAndLast() {
        if (this.lines.size() < 2) {
            throw new RuntimeException("Zu wenige Zeilen vorhanden, um die erste und letzte Zeile zu entfernen.");
        }
        this.lines.remove(this.lines.size() - 1);
        this.lines.remove(0);
    }

    public int countEstimatedByteLength() {
        int n = 2 * this.lines.size();
        for (String string : this.lines) {
            n += string.getBytes().length;
        }
        return n;
    }

    public String toString() {
        return this.toNiceString();
    }

    public String toNiceString() {
        return CollectionsHelper.listListNice(this.lines);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.lines == null ? 0 : this.lines.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Lines lines = (Lines)object;
        return !(this.lines == null ? lines.lines != null : !this.lines.equals(lines.lines));
    }

    public static Lines readFileToLines(String string) {
        return new Lines(FileHelper.readFileToList(string));
    }

    public static Lines readFileToLines(String string, Charset charset) {
        return new Lines(FileHelper.readFileToList(string, charset));
    }

    public static Lines splitTextByLineBreaks(String string) {
        return new Lines(Text.splitByLineBreaks(string));
    }

    public static List<Lines> createListOfLinesFromListOfListOfStrings(List<List<String>> list) {
        ArrayList<Lines> arrayList = new ArrayList<Lines>();
        for (List<String> list2 : list) {
            arrayList.add(new Lines(list2));
        }
        return arrayList;
    }

    public static Lines buildListFrom(String ... stringArray) {
        return new Lines(CollectionsHelper.buildListFrom(stringArray));
    }

    public static Lines createFromMultipleLineInOneString(String string) {
        List<String> list = Text.splitByLineBreaks(string);
        return new Lines(list);
    }
}

