/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.textfile.dictionary.Dictionary;
import de.duehl.basics.io.textfile.dictionary.DictionaryEntry;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpellingErrorCorrector {
    private static final String DEFAULT_MASK_CHARACTRER = "\u3077";
    private final List<String> mispelledPhrases = new ArrayList<String>();
    private final Map<String, String> mispelledToCorrectWords = new HashMap<String, String>();
    private String maskCharacter;

    public SpellingErrorCorrector(Dictionary dictionary) {
        this.initListAndMapWithDictionary(dictionary);
        this.sortMispelledPhrasesByLengthDescanding();
        this.maskCharacter = DEFAULT_MASK_CHARACTRER;
    }

    private void initListAndMapWithDictionary(Dictionary dictionary) {
        for (DictionaryEntry dictionaryEntry : dictionary) {
            this.initListAndMapWithDictionaryList(dictionaryEntry);
        }
    }

    private void initListAndMapWithDictionaryList(DictionaryEntry dictionaryEntry) {
        String string = dictionaryEntry.getMainWord();
        List<String> list = dictionaryEntry.getAlternatives();
        if (list.isEmpty()) {
            throw new RuntimeException("Eine Liste im Dictionary enth\u00e4lt nur ein richtig geschriebenes Wort, aber keine falsch geschriebenen: '" + string + "'.");
        }
        for (String string2 : list) {
            if (this.mispelledPhrases.contains(string2)) {
                throw new RuntimeException("Falschgeschriebener Begriff ist doppelt vorhanden: '" + string2 + "'.");
            }
            this.mispelledPhrases.add(string2);
            this.mispelledToCorrectWords.put(string2, string);
        }
    }

    private void sortMispelledPhrasesByLengthDescanding() {
        CollectionsHelper.sortStringListByLengthDescanding(this.mispelledPhrases);
    }

    public void setMaskCharacter(String string) {
        this.maskCharacter = string;
    }

    public String correct(String string) {
        Object object = string;
        Object object2 = string;
        for (String string2 : this.mispelledPhrases) {
            int n = 0;
            boolean bl = true;
            while (bl && n < ((String)object).length()) {
                int n2 = ((String)object).indexOf(string2, n);
                if (-1 == n2) {
                    bl = false;
                    continue;
                }
                int n3 = n2 + string2.length();
                String string3 = ((String)object2).substring(n2, n3);
                if (!string3.contains(this.maskCharacter)) {
                    String string4 = ((String)object).substring(0, n2);
                    String string5 = ((String)object).substring(n3);
                    String string6 = this.mispelledToCorrectWords.get(string2);
                    object = string4 + string6 + string5;
                    String string7 = ((String)object2).substring(0, n2);
                    String string8 = ((String)object2).substring(n3);
                    String string9 = Text.multipleString(this.maskCharacter, string6.length());
                    object2 = string7 + string9 + string8;
                    n = n3 - string2.length() + string6.length();
                    continue;
                }
                n = n3;
            }
        }
        return object;
    }

    public void correct(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string;
            String string2 = list.get(i);
            if (string2.equals(string = this.correct(string2))) continue;
            list.set(i, string);
        }
    }

    public List<String> getMispelledPhrases() {
        return this.mispelledPhrases;
    }
}

