/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text.extract;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import de.duehl.basics.text.extract.tools.PrepareLines;
import de.duehl.basics.text.extract.tools.UnwantedWordsRemover;
import de.duehl.basics.text.sort.WordsSorter;
import java.util.ArrayList;
import java.util.List;

public class WordExtractor {
    private final String text;
    private List<String> lines;
    private List<String> words;

    public WordExtractor(String string) {
        this.text = string;
        this.extractWords();
    }

    private void extractWords() {
        this.prepareLines();
        this.splitLinesIntoWords();
        this.makeWordsDisjunkt();
        this.removeUnwantedWords();
        this.sortWords();
    }

    private void prepareLines() {
        PrepareLines prepareLines = new PrepareLines(this.text);
        this.lines = prepareLines.getLines();
    }

    private void splitLinesIntoWords() {
        this.words = new ArrayList<String>();
        for (String string : this.lines) {
            List<String> list = Text.splitByWhitespace(string.strip());
            this.words.addAll(list);
        }
    }

    private void makeWordsDisjunkt() {
        this.words = CollectionsHelper.createDisjunctList(this.words);
    }

    private void removeUnwantedWords() {
        UnwantedWordsRemover unwantedWordsRemover = new UnwantedWordsRemover(this.words);
        this.words = unwantedWordsRemover.getCleanedWords();
    }

    private void sortWords() {
        WordsSorter wordsSorter = new WordsSorter(this.words);
        wordsSorter.sort();
    }

    public List<String> getWords() {
        return this.words;
    }
}

