/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text.html;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.logic.Pair;
import de.duehl.basics.text.Text;
import de.duehl.basics.text.data.FoundSearch;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class HtmlTool {
    private static final List<Pair<String>> HTML_TO_UTF8 = HtmlTool.createHtmlEncodingList();
    private static final List<String> HTML5_KEY_WORDS = CollectionsHelper.buildLoweredListFrom("html", "title", "base", "link", "meta", "style", "script", "noscript", "body", "section", "nav", "aside", "h1", "h2", "h3", "h4", "h5", "h6", "header", "footer", "address", "main", "p", "hr", "pre", "blockquote", "ol", "ul", "li", "dl", "dt", "dd", "figure", "figcaption", "div", "a", "em", "strong", "small", "s", "cite", "q", "dfn", "abbr", "time", "code", "var", "samp", "kbd", "sub", "sup", "i", "b", "u", "mark", "ruby", "rt", "rp", "bdi", "bdo", "span", "br", "wbr", "ins", "del", "img", "iframe", "embed", "object", "param", "video", "audio", "source", "track", "canvas", "map", "area", "svg", "math", "table", "caption", "colgroup", "col", "tbody", "thead", "tfoot", "tr", "td", "th", "form", "fieldset", "legend", "label", "input", "button", "select", "datalist", "optgroup", "option", "textarea", "keygen", "output", "progress", "meter", "details", "summary", "command", "menu");
    private static final Pattern FILE_PATTERN = Pattern.compile("(.*(?:\\A|\\s))((?:file\\:)?(?:[A-Za-z]\\:[/\\\\]|[/\\\\]{2}).+?\\.[a-zA-Z]{3,4})((:\\s|\\z|\\.|,|\\!|\\?).*)");
    private static final Pattern SPACE_PATTERN = Pattern.compile("( {2,})");
    private static final String HTML_COMMENT_START = "<!--";
    private static final String HTML_COMMENT_END = "-->";

    private HtmlTool() {
    }

    public static String textToHtmlConvertingURLsToLinks(String string) {
        if (string == null) {
            return string;
        }
        return string.replaceAll("(\\A|\\s)((?:http|https|ftp|mailto):\\S+[^.,!?]|www\\.\\S+\\.[a-z]{2,3})(\\s|\\z|\\.|,|\\!|\\?)", "$1<a href=\"$2\">$2</a>$3");
    }

    public static String textToHtmlConvertingFilesToLinks(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        Object object = string;
        Matcher matcher = FILE_PATTERN.matcher((CharSequence)object);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            String string5 = Text.allBackslashesToSlashes(string3);
            object = string2 + "<a href=\"file:" + (string5.startsWith("//") ? "" : "//") + string5 + "\">" + string3 + "</a>" + string4;
            matcher = FILE_PATTERN.matcher((CharSequence)object);
        }
        return object;
    }

    public static String green(String string) {
        return HtmlTool.colorText("#00A000", string);
    }

    public static String red(String string) {
        return HtmlTool.colorText("#FF0000", string);
    }

    public static String orange(String string) {
        return HtmlTool.colorText("#FF6600", string);
    }

    public static String green(int n) {
        return HtmlTool.green(Integer.toString(n));
    }

    public static String red(int n) {
        return HtmlTool.red(Integer.toString(n));
    }

    public static String orange(int n) {
        return HtmlTool.orange(Integer.toString(n));
    }

    public static String colorText(String string, String string2) {
        return "<font color=\"" + string + "\">" + string2 + "</font>";
    }

    public static String createLink(String string, String string2) {
        return "<a href=\"" + string + "\">" + string2 + "</a>";
    }

    public static String createAnchor(String string) {
        return "<a name=\"" + string + "\" />";
    }

    public static String strong(String string) {
        return "<strong>" + string + "</strong>";
    }

    public static String strong(int n) {
        return HtmlTool.strong(Integer.toString(n));
    }

    public static String createContentFromUrl(URL uRL) {
        String string;
        URLConnection uRLConnection;
        try {
            uRLConnection = uRL.openConnection();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "FEHLER BEIM \u00d6FFNEN!!!" + iOException.getMessage();
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream(), StandardCharsets.UTF_8));
        try {
            String string2;
            string = string2 = bufferedReader.lines().collect(Collectors.joining(Text.LINE_BREAK));
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "FEHLER BEIM LESEN!!!" + exception.getMessage();
            }
        }
        bufferedReader.close();
        return string;
    }

    public static String createCenteredBigText(String string) {
        return "<html><center><p style=\"font-size:large\">" + string + "</p></center></html>";
    }

    public static String htmlify(String string) {
        int n = -1;
        return HtmlTool.htmlify(string, n);
    }

    public static String htmlify(String string, int n) {
        Object object = HtmlTool.htmlifyWithoutFrame(string, n);
        object = "<html>" + (String)object + "</html>";
        return object;
    }

    public static String htmlifyWithoutFrame(String string) {
        int n = -1;
        return HtmlTool.htmlifyWithoutFrame(string, n);
    }

    public static String htmlifyWithoutFrame(String string, int n) {
        Object object = HtmlTool.encodeHtmlOnlyLtGt(string);
        object = ((String)object).replaceAll("\t", "    ");
        if (n > 0) {
            object = Text.addLineBreaks((String)object, n);
        }
        Matcher matcher = SPACE_PATTERN.matcher((CharSequence)object);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            int n2 = matcher.start(1);
            int n3 = matcher.end(1);
            String string3 = Text.multipleString("&nbsp;", string2.length());
            String string4 = ((String)object).substring(0, n2);
            String string5 = ((String)object).substring(n3);
            object = string4 + string3 + string5;
            matcher = SPACE_PATTERN.matcher((CharSequence)object);
        }
        object = ((String)object).replaceAll("\\r?\\n", "<br/>" + Text.LINE_BREAK);
        return object;
    }

    public static String breakHtml(String string, int n) {
        String string2 = string;
        string2 = Text.addLineBreaks(string2, n);
        string2 = string2.replaceAll("\\r?\\n", "<br/>" + Text.LINE_BREAK);
        return string2;
    }

    public static String decodeHtmlOnlyLtGt(String string) {
        int n;
        Object object = string;
        while (((String)object).contains("&lt;")) {
            n = ((String)object).indexOf("&lt;");
            if (((String)object).length() > n + 4) {
                object = ((String)object).substring(0, n) + "<" + ((String)object).substring(n + 4);
                continue;
            }
            object = ((String)object).substring(0, n) + "<";
        }
        while (((String)object).contains("&gt;")) {
            n = ((String)object).indexOf("&gt;");
            if (((String)object).length() > n + 4) {
                object = ((String)object).substring(0, n) + ">" + ((String)object).substring(n + 4);
                continue;
            }
            object = ((String)object).substring(0, n) + ">";
        }
        return object;
    }

    public static String encodeHtmlOnlyLtGt(String string) {
        int n;
        Object object = string;
        while (((String)object).contains("<")) {
            n = ((String)object).indexOf("<");
            if (((String)object).length() > n + 1) {
                object = ((String)object).substring(0, n) + "&lt;" + ((String)object).substring(n + 1);
                continue;
            }
            object = ((String)object).substring(0, n) + "&lt;";
        }
        while (((String)object).contains(">")) {
            n = ((String)object).indexOf(">");
            if (((String)object).length() > n + 1) {
                object = ((String)object).substring(0, n) + "&gt;" + ((String)object).substring(n + 1);
                continue;
            }
            object = ((String)object).substring(0, n) + "&gt;";
        }
        return object;
    }

    public static String decodeHtmlAmpLtAndGt(String string) {
        String string2 = string;
        string2 = string2.replace("&amp;", "&");
        string2 = string2.replace("&lt;", "<");
        string2 = string2.replace("&gt;", ">");
        return string2;
    }

    public static String encodeHtmlAmpLtAndGt(String string) {
        String string2 = string;
        string2 = string2.replace("&", "&amp;");
        string2 = string2.replace("<", "&lt;");
        string2 = string2.replace(">", "&gt;");
        return string2;
    }

    private static List<Pair<String>> createHtmlEncodingList() {
        ArrayList<Pair<String>> arrayList = new ArrayList<Pair<String>>();
        arrayList.add(new Pair<String>("&amp;", "&"));
        arrayList.add(new Pair<String>("&quot;", "\""));
        arrayList.add(new Pair<String>("&lt;", "<"));
        arrayList.add(new Pair<String>("&gt;", ">"));
        arrayList.add(new Pair<String>("&apos;", "'"));
        arrayList.add(new Pair<String>("&nbsp;", " "));
        arrayList.add(new Pair<String>("&iexcl;", "\u00a1"));
        arrayList.add(new Pair<String>("&cent;", "\u00a2"));
        arrayList.add(new Pair<String>("&pound;", "\u00a3"));
        arrayList.add(new Pair<String>("&curren;", "\u00a4"));
        arrayList.add(new Pair<String>("&yen;", "\u00a5"));
        arrayList.add(new Pair<String>("&brvbar;", "\u00a6"));
        arrayList.add(new Pair<String>("&sect;", "\u00a7"));
        arrayList.add(new Pair<String>("&uml;", "\u00a8"));
        arrayList.add(new Pair<String>("&copy;", "\u00a9"));
        arrayList.add(new Pair<String>("&ordf;", "\u00aa"));
        arrayList.add(new Pair<String>("&laquo;", "\u00ab"));
        arrayList.add(new Pair<String>("&not;", "\u00ac"));
        arrayList.add(new Pair<String>("&reg;", "\u00ae"));
        arrayList.add(new Pair<String>("&macr;", "\u00af"));
        arrayList.add(new Pair<String>("&deg;", "\u00b0"));
        arrayList.add(new Pair<String>("&plusmn;", "\u00b1"));
        arrayList.add(new Pair<String>("&sup2;", "\u00b2"));
        arrayList.add(new Pair<String>("&sup3;", "\u00b3"));
        arrayList.add(new Pair<String>("&acute;", "\u00b4"));
        arrayList.add(new Pair<String>("&micro;", "\u00b5"));
        arrayList.add(new Pair<String>("&para;", "\u00b6"));
        arrayList.add(new Pair<String>("&middot;", "\u00b7"));
        arrayList.add(new Pair<String>("&cedil;", "\u00b8"));
        arrayList.add(new Pair<String>("&sup1;", "\u00b9"));
        arrayList.add(new Pair<String>("&ordm;", "\u00ba"));
        arrayList.add(new Pair<String>("&raquo;", " \u00bb"));
        arrayList.add(new Pair<String>("&frac14;", "\u00bc"));
        arrayList.add(new Pair<String>("&frac12;", "\u00bd"));
        arrayList.add(new Pair<String>("&frac34;", "\u00be"));
        arrayList.add(new Pair<String>("&iquest;", "\u00bf"));
        arrayList.add(new Pair<String>("&Agrave;", "\u00c0"));
        arrayList.add(new Pair<String>("&Aacute;", "\u00c1"));
        arrayList.add(new Pair<String>("&Acirc;", "\u00c2"));
        arrayList.add(new Pair<String>("&Atilde;", "\u00c3"));
        arrayList.add(new Pair<String>("&Auml;", "\u00c4"));
        arrayList.add(new Pair<String>("&Aring;", "\u00c5"));
        arrayList.add(new Pair<String>("&AElig;", "\u00c6"));
        arrayList.add(new Pair<String>("&Ccedil;", "\u00c7"));
        arrayList.add(new Pair<String>("&Egrave;", "\u00c8"));
        arrayList.add(new Pair<String>("&Eacute;", "\u00c9"));
        arrayList.add(new Pair<String>("&Ecirc;", "\u00ca"));
        arrayList.add(new Pair<String>("&Euml;", "\u00cb"));
        arrayList.add(new Pair<String>("&Igrave;", "\u00cc"));
        arrayList.add(new Pair<String>("&Iacute;", "\u00cd"));
        arrayList.add(new Pair<String>("&Icirc;", "\u00ce"));
        arrayList.add(new Pair<String>("&Iuml;", "\u00cf"));
        arrayList.add(new Pair<String>("&ETH;", "\u00d0"));
        arrayList.add(new Pair<String>("&Ntilde;", "\u00d1"));
        arrayList.add(new Pair<String>("&Ograve;", "\u00d2"));
        arrayList.add(new Pair<String>("&Oacute;", "\u00d3"));
        arrayList.add(new Pair<String>("&Ocirc;", "\u00d4"));
        arrayList.add(new Pair<String>("&Otilde;", "\u00d5"));
        arrayList.add(new Pair<String>("&Ouml;", "\u00d6"));
        arrayList.add(new Pair<String>("&times;", "\u00d7"));
        arrayList.add(new Pair<String>("&Oslash;", "\u00d8"));
        arrayList.add(new Pair<String>("&Ugrave;", "\u00d9"));
        arrayList.add(new Pair<String>("&Uacute;", "\u00da"));
        arrayList.add(new Pair<String>("&Ucirc;", "\u00db"));
        arrayList.add(new Pair<String>("&Uuml;", "\u00dc"));
        arrayList.add(new Pair<String>("&Yacute;", "\u00dd"));
        arrayList.add(new Pair<String>("&THORN;", "\u00de"));
        arrayList.add(new Pair<String>("&szlig;", "\u00df"));
        arrayList.add(new Pair<String>("&agrave;", "\u00e0"));
        arrayList.add(new Pair<String>("&aacute;", "\u00e1"));
        arrayList.add(new Pair<String>("&acirc;", "\u00e2"));
        arrayList.add(new Pair<String>("&atilde;", "\u00e3"));
        arrayList.add(new Pair<String>("&auml;", "\u00e4"));
        arrayList.add(new Pair<String>("&aring;", "\u00e5"));
        arrayList.add(new Pair<String>("&aelig;", "\u00e6"));
        arrayList.add(new Pair<String>("&ccedil;", "\u00e7"));
        arrayList.add(new Pair<String>("&egrave;", "\u00e8"));
        arrayList.add(new Pair<String>("&eacute;", "\u00e9"));
        arrayList.add(new Pair<String>("&ecirc;", "\u00ea"));
        arrayList.add(new Pair<String>("&euml;", "\u00eb"));
        arrayList.add(new Pair<String>("&igrave;", "\u00ec"));
        arrayList.add(new Pair<String>("&iacute;", "\u00ed"));
        arrayList.add(new Pair<String>("&icirc;", "\u00ee"));
        arrayList.add(new Pair<String>("&iuml;", "\u00ef"));
        arrayList.add(new Pair<String>("&eth;", "\u00f0"));
        arrayList.add(new Pair<String>("&ntilde;", "\u00f1"));
        arrayList.add(new Pair<String>("&ograve;", "\u00f2"));
        arrayList.add(new Pair<String>("&oacute;", "\u00f3"));
        arrayList.add(new Pair<String>("&ocirc;", "\u00f4"));
        arrayList.add(new Pair<String>("&otilde;", "\u00f5"));
        arrayList.add(new Pair<String>("&ouml;", "\u00f6"));
        arrayList.add(new Pair<String>("&divide;", "\u00f7"));
        arrayList.add(new Pair<String>("&oslash;", "\u00f8"));
        arrayList.add(new Pair<String>("&ugrave;", "\u00f9"));
        arrayList.add(new Pair<String>("&uacute;", "\u00fa"));
        arrayList.add(new Pair<String>("&ucirc;", "\u00fb"));
        arrayList.add(new Pair<String>("&uuml;", "\u00fc"));
        arrayList.add(new Pair<String>("&yacute;", "\u00fd"));
        arrayList.add(new Pair<String>("&thorn;", "\u00fe"));
        arrayList.add(new Pair<String>("&yuml;", "\u00ff"));
        arrayList.add(new Pair<String>("&OElig;", "\u0152"));
        arrayList.add(new Pair<String>("&oelig;", "\u0153"));
        arrayList.add(new Pair<String>("&Scaron;", "\u0160"));
        arrayList.add(new Pair<String>("&scaron;", "\u0161"));
        arrayList.add(new Pair<String>("&Yuml;", "\u0178"));
        arrayList.add(new Pair<String>("&fnof;", "\u0192"));
        arrayList.add(new Pair<String>("&circ;", "\u02c6"));
        arrayList.add(new Pair<String>("&tilde;", "\u02dc"));
        arrayList.add(new Pair<String>("&Alpha;", "\u0391"));
        arrayList.add(new Pair<String>("&alpha;", "\u03b1"));
        arrayList.add(new Pair<String>("&Beta;", "\u0392"));
        arrayList.add(new Pair<String>("&beta;", "\u03b2"));
        arrayList.add(new Pair<String>("&Gamma;", "\u0393"));
        arrayList.add(new Pair<String>("&gamma;", "\u03b3"));
        arrayList.add(new Pair<String>("&Delta;", "\u0394"));
        arrayList.add(new Pair<String>("&delta;", "\u03b4"));
        arrayList.add(new Pair<String>("&Epsilon;", "\u0395"));
        arrayList.add(new Pair<String>("&epsilon;", "\u03b5"));
        arrayList.add(new Pair<String>("&Zeta;", "\u0396"));
        arrayList.add(new Pair<String>("&zeta;", "\u03b6"));
        arrayList.add(new Pair<String>("&Eta;", "\u0397"));
        arrayList.add(new Pair<String>("&eta;", "\u03b7"));
        arrayList.add(new Pair<String>("&Theta;", "\u0398"));
        arrayList.add(new Pair<String>("&theta;", "\u03b8"));
        arrayList.add(new Pair<String>("&Iota;", "\u0399"));
        arrayList.add(new Pair<String>("&iota;", "\u03b9"));
        arrayList.add(new Pair<String>("&Kappa;", "\u039a"));
        arrayList.add(new Pair<String>("&kappa;", "\u03ba"));
        arrayList.add(new Pair<String>("&Lambda;", "\u039b"));
        arrayList.add(new Pair<String>("&lambda;", "\u03bb"));
        arrayList.add(new Pair<String>("&Mu;", "\u039c"));
        arrayList.add(new Pair<String>("&mu;", "\u03bc"));
        arrayList.add(new Pair<String>("&Nu;", "\u039d"));
        arrayList.add(new Pair<String>("&nu;", "\u03bd"));
        arrayList.add(new Pair<String>("&Xi;", "\u039e"));
        arrayList.add(new Pair<String>("&xi;", "\u03be"));
        arrayList.add(new Pair<String>("&Omicron;", "\u039f"));
        arrayList.add(new Pair<String>("&omicron;", "\u03bf"));
        arrayList.add(new Pair<String>("&Pi;", "\u03a0"));
        arrayList.add(new Pair<String>("&pi;", "\u03c0"));
        arrayList.add(new Pair<String>("&Rho;", "\u03a1"));
        arrayList.add(new Pair<String>("&rho;", "\u03c1"));
        arrayList.add(new Pair<String>("&Sigma;", "\u03a3"));
        arrayList.add(new Pair<String>("&sigmaf;", "\u03c2"));
        arrayList.add(new Pair<String>("&sigma;", "\u03c3"));
        arrayList.add(new Pair<String>("&Tau;", "\u03a4"));
        arrayList.add(new Pair<String>("&tau;", "\u03c4"));
        arrayList.add(new Pair<String>("&Upsilon;", "\u03a5"));
        arrayList.add(new Pair<String>("&upsilon;", "\u03c5"));
        arrayList.add(new Pair<String>("&Phi;", "\u03a6"));
        arrayList.add(new Pair<String>("&phi;", "\u03c6"));
        arrayList.add(new Pair<String>("&Chi;", "\u03a7"));
        arrayList.add(new Pair<String>("&chi;", "\u03c7"));
        arrayList.add(new Pair<String>("&Psi;", "\u03a8"));
        arrayList.add(new Pair<String>("&psi;", "\u03c8"));
        arrayList.add(new Pair<String>("&Omega;", "\u03a9"));
        arrayList.add(new Pair<String>("&omega;", "\u03c9"));
        arrayList.add(new Pair<String>("&thetasym;", "\u03d1"));
        arrayList.add(new Pair<String>("&upsih;", "\u03d2"));
        arrayList.add(new Pair<String>("&piv;", "\u03d6"));
        arrayList.add(new Pair<String>("&forall;", "\u2200"));
        arrayList.add(new Pair<String>("&part;", "\u2202"));
        arrayList.add(new Pair<String>("&exist;", "\u2203"));
        arrayList.add(new Pair<String>("&empty;", "\u2205"));
        arrayList.add(new Pair<String>("&nabla;", "\u2207"));
        arrayList.add(new Pair<String>("&isin;", "\u2208"));
        arrayList.add(new Pair<String>("&notin;", "\u2209"));
        arrayList.add(new Pair<String>("&ni;", "\u220b"));
        arrayList.add(new Pair<String>("&prod;", "\u220f"));
        arrayList.add(new Pair<String>("&sum;", "\u2211"));
        arrayList.add(new Pair<String>("&minus;", "\u2212"));
        arrayList.add(new Pair<String>("&lowast;", "\u2217"));
        arrayList.add(new Pair<String>("&radic;", "\u221a"));
        arrayList.add(new Pair<String>("&prop;", "\u221d"));
        arrayList.add(new Pair<String>("&infin;", "\u221e"));
        arrayList.add(new Pair<String>("&ang;", "\u2220"));
        arrayList.add(new Pair<String>("&and;", "\u2227"));
        arrayList.add(new Pair<String>("&or;", "\u2228"));
        arrayList.add(new Pair<String>("&cap;", "\u2229"));
        arrayList.add(new Pair<String>("&cup;", "\u222a"));
        arrayList.add(new Pair<String>("&int;", "\u222b"));
        arrayList.add(new Pair<String>("&there4;", "\u2234"));
        arrayList.add(new Pair<String>("&sim;", "\u223c"));
        arrayList.add(new Pair<String>("&cong;", "\u2245"));
        arrayList.add(new Pair<String>("&asymp;", "\u2248"));
        arrayList.add(new Pair<String>("&ne;", "\u2260"));
        arrayList.add(new Pair<String>("&equiv;", "\u2261"));
        arrayList.add(new Pair<String>("&le;", "\u2264"));
        arrayList.add(new Pair<String>("&ge;", "\u2265"));
        arrayList.add(new Pair<String>("&sub;", "\u2282"));
        arrayList.add(new Pair<String>("&sup;", "\u2283"));
        arrayList.add(new Pair<String>("&nsub;", "\u2284"));
        arrayList.add(new Pair<String>("&sube;", "\u2286"));
        arrayList.add(new Pair<String>("&supe;", "\u2287"));
        arrayList.add(new Pair<String>("&oplus;", "\u2295"));
        arrayList.add(new Pair<String>("&otimes;", "\u2297"));
        arrayList.add(new Pair<String>("&perp;", "\u22a5"));
        arrayList.add(new Pair<String>("&sdot;", "\u22c5"));
        arrayList.add(new Pair<String>("&loz;", "\u25ca"));
        arrayList.add(new Pair<String>("&lang;", "\u3008"));
        arrayList.add(new Pair<String>("&rang;", "\u3009"));
        arrayList.add(new Pair<String>("&larr;", "\u2190"));
        arrayList.add(new Pair<String>("&uarr;", "\u2191"));
        arrayList.add(new Pair<String>("&rarr;", "\u2192"));
        arrayList.add(new Pair<String>("&darr;", "\u2193"));
        arrayList.add(new Pair<String>("&harr;", "\u2194"));
        arrayList.add(new Pair<String>("&crarr;", "\u21b5"));
        arrayList.add(new Pair<String>("&lArr;", "\u21d0"));
        arrayList.add(new Pair<String>("&uArr;", "\u21d1"));
        arrayList.add(new Pair<String>("&rArr;", "\u21d2"));
        arrayList.add(new Pair<String>("&dArr;", "\u21d3"));
        arrayList.add(new Pair<String>("&hArr;", "\u21d4"));
        arrayList.add(new Pair<String>("&bull;", "\u2022"));
        arrayList.add(new Pair<String>("&prime;", "\u2032"));
        arrayList.add(new Pair<String>("&Prime;", "\u2033"));
        arrayList.add(new Pair<String>("&oline;", "\u203e"));
        arrayList.add(new Pair<String>("&frasl;", "\u2044"));
        arrayList.add(new Pair<String>("&weierp;", "\u2118"));
        arrayList.add(new Pair<String>("&image;", "\u2111"));
        arrayList.add(new Pair<String>("&real;", "\u211c"));
        arrayList.add(new Pair<String>("&trade;", "\u2122"));
        arrayList.add(new Pair<String>("&euro;", "\u20ac"));
        arrayList.add(new Pair<String>("&alefsym;", "\u2135"));
        arrayList.add(new Pair<String>("&spades;", "\u2660"));
        arrayList.add(new Pair<String>("&clubs;", "\u2663"));
        arrayList.add(new Pair<String>("&hearts;", "\u2665"));
        arrayList.add(new Pair<String>("&diams;", "\u2666"));
        arrayList.add(new Pair<String>("&ensp;", " "));
        arrayList.add(new Pair<String>("&emsp;", " "));
        arrayList.add(new Pair<String>("&thinsp;", " "));
        arrayList.add(new Pair<String>("-", "-"));
        arrayList.add(new Pair<String>("&zwnj;", " \u200c"));
        arrayList.add(new Pair<String>("&zwj;", " \u200d"));
        arrayList.add(new Pair<String>("&lrm;", "\u200e"));
        arrayList.add(new Pair<String>("&rlm;", "\u200f"));
        arrayList.add(new Pair<String>("&ndash;", "\u2013"));
        arrayList.add(new Pair<String>("&mdash;", "\u2014"));
        arrayList.add(new Pair<String>("&lsquo;", "\u2018"));
        arrayList.add(new Pair<String>("&rsquo;", "\u2019"));
        arrayList.add(new Pair<String>("&sbquo;", "\u201a"));
        arrayList.add(new Pair<String>("&ldquo;", "\u201c"));
        arrayList.add(new Pair<String>("&rdquo;", "\u201d"));
        arrayList.add(new Pair<String>("&bdquo;", "\u201e"));
        arrayList.add(new Pair<String>("&dagger;", "\u2020"));
        arrayList.add(new Pair<String>("&Dagger;", "\u2021"));
        arrayList.add(new Pair<String>("&hellip;", "\u2026"));
        arrayList.add(new Pair<String>("&permil;", "\u2030"));
        arrayList.add(new Pair<String>("&lsaquo;", "\u2039"));
        arrayList.add(new Pair<String>("&rsaquo;", "\u203a"));
        arrayList.add(new Pair<String>("&sup1;", "\u00b9"));
        arrayList.add(new Pair<String>("&sup2;", "\u00b2"));
        arrayList.add(new Pair<String>("&sup3;", "\u00b3"));
        return arrayList;
    }

    public static String encodeHtml(String string) {
        String string2 = string;
        for (Pair<String> pair : HTML_TO_UTF8) {
            String string3 = pair.getFirst();
            String string4 = pair.getSecond();
            string2 = string2.replace(string4, string3);
        }
        return string2;
    }

    public static String encodeHtmlWithoutSpaces(String string) {
        String string2 = string;
        for (Pair<String> pair : HTML_TO_UTF8) {
            String string3 = pair.getFirst();
            String string4 = pair.getSecond();
            if (" ".equals(string4)) continue;
            string2 = string2.replace(string4, string3);
        }
        return string2;
    }

    public static String decodeHtml(String string) {
        String string2 = string;
        for (Pair<String> pair : HTML_TO_UTF8) {
            String string3 = pair.getFirst();
            String string4 = pair.getSecond();
            string2 = string2.replace(string3, string4);
        }
        return string2;
    }

    public static String blockquote(String string) {
        return "<blockquote>" + string + "</blockquote>";
    }

    public static String tt(String string) {
        return "<tt>" + string + "</tt>";
    }

    public static String blockquoteTt(String string) {
        return HtmlTool.blockquote(HtmlTool.tt(string));
    }

    public static String removeHtmlComments(String string) {
        Object object = string;
        boolean bl = true;
        while (bl) {
            int n;
            int n2;
            bl = false;
            int n3 = ((String)object).indexOf(HTML_COMMENT_START);
            if (-1 == n3 || -1 == (n2 = ((String)object).indexOf(HTML_COMMENT_END, n = n3 + HTML_COMMENT_START.length()))) continue;
            String string2 = ((String)object).substring(0, n3);
            String string3 = ((String)object).substring(n2 + HTML_COMMENT_END.length());
            object = string2 + string3;
            bl = true;
        }
        return object;
    }

    public static String fillWithSpaces(String string, int n) {
        if (n <= string.length()) {
            return string;
        }
        String string2 = Text.multipleString("&nbsp;", n - string.length());
        return string + string2;
    }

    public static String fillWithSpacesAtFront(String string, int n) {
        if (n <= string.length()) {
            return string;
        }
        String string2 = Text.multipleString("&nbsp;", n - string.length());
        return string2 + string;
    }

    public static String removeLinks(String string) {
        return string.replaceAll("<a(?: +| *\n *)href(?: *| *\n *)=[^<>]+>[^<>]+</a>", "");
    }

    public static String removeLinksSecure(String string) {
        List<String> list = CollectionsHelper.buildListFrom("<a ", "<A ", "<a\n", "<A\n", "<a\r\n", "<A\r\n", "<a" + Text.LINE_BREAK, "<A" + Text.LINE_BREAK);
        List<String> list2 = CollectionsHelper.buildListFrom("</a>", "</A>");
        return Text.removeAllPartsWithStartsAndEnds(string, list, list2);
    }

    public static String removeLinksSecureButKeepLinkDescription(String string) {
        List<String> list = CollectionsHelper.buildListFrom("<a ", "<A ", "<a\n", "<A\n", "<a\r\n", "<A\r\n", "<a" + Text.LINE_BREAK, "<A" + Text.LINE_BREAK);
        List<String> list2 = CollectionsHelper.buildListFrom("</a>", "</A>");
        Object object = string;
        boolean bl = true;
        while (bl) {
            FoundSearch foundSearch = Text.findFirstPosition((String)object, list);
            int n = foundSearch.getIndex();
            if (n == -1) {
                bl = false;
                continue;
            }
            String string2 = foundSearch.getSearch();
            FoundSearch foundSearch2 = Text.findFirstPosition((String)object, list2, n + string2.length());
            int n2 = foundSearch2.getIndex();
            if (n2 == -1) {
                object = ((String)object).substring(0, n);
                continue;
            }
            String string3 = foundSearch2.getSearch();
            String string4 = ((String)object).substring(n, n2);
            int n3 = string4.lastIndexOf(">");
            String string5 = n3 == -1 ? "" : string4.substring(n3 + 1);
            object = ((String)object).substring(0, n) + string5 + ((String)object).substring(n2 + string3.length());
        }
        return object;
    }

    public static boolean isHtml5KeyWord(String string) {
        String string2 = string.toLowerCase();
        return HTML5_KEY_WORDS.contains(string2);
    }

    public static String removeComments(String string) {
        String string2 = HTML_COMMENT_START;
        String string3 = HTML_COMMENT_END;
        return Text.removeAllPartsWithStartAndEnd(string, string2, string3);
    }

    public static String removeScripts(String string) {
        List<String> list = HtmlTool.createUpperAndLowerCaseHtmlTagStarts("script");
        List<String> list2 = HtmlTool.createUpperAndLowerCaseHtmlEndingTags("script");
        return Text.removeAllPartsWithStartsAndEnds(string, list, list2);
    }

    public static String removeImages(String string) {
        List<String> list = HtmlTool.createUpperAndLowerCaseHtmlTagStarts("img");
        List<String> list2 = CollectionsHelper.buildListFrom("/>", ">");
        return Text.removeAllPartsWithStartsAndEnds(string, list, list2);
    }

    public static String removeDefinitionLists(String string) {
        List<String> list = HtmlTool.createUpperAndLowerCaseHtmlTagStarts("dl");
        List<String> list2 = HtmlTool.createUpperAndLowerCaseHtmlEndingTags("dl");
        return Text.removeAllPartsWithStartsAndEnds(string, list, list2);
    }

    static List<String> createUpperAndLowerCaseHtmlTagStarts(String string) {
        String string2 = Text.toLowerCase(string);
        String string3 = Text.toUpperCase(string);
        return CollectionsHelper.buildListFrom("<" + string2 + ">", "<" + string3 + ">", "<" + string2 + " ", "<" + string3 + " ", "<" + string2 + "\n", "<" + string3 + "\n", "<" + string2 + "\r\n", "<" + string3 + "\r\n", "<" + string2 + Text.LINE_BREAK, "<" + string3 + Text.LINE_BREAK);
    }

    static List<String> createUpperAndLowerCaseHtmlEndingTags(String string) {
        String string2 = Text.toLowerCase(string);
        String string3 = Text.toUpperCase(string);
        return CollectionsHelper.buildListFrom("</" + string2 + ">", "</" + string3 + ">");
    }

    public static String lowerTagNames(String string) {
        String string2 = string;
        for (String string3 : HTML5_KEY_WORDS) {
            string2 = string2.replaceAll("(?i)<" + string3, "<" + string3);
            string2 = string2.replaceAll("(?i)</" + string3, "</" + string3);
        }
        return string2;
    }

    public static String removeHtmlMarkup(String string) {
        return string.replaceAll("</?[^>]+>", "");
    }
}

