/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.html.download.data;

import de.duehl.basics.logging.Logger;
import de.duehl.html.download.data.RedirectHandling;
import de.duehl.html.download.proxy.Proxy;
import de.duehl.html.download.proxy.RotatingProxies;

public class DownloadParameters {
    private final String website;
    private RedirectHandling redirectHandling;
    private boolean useProxy;
    private Proxy proxy;
    private boolean useRotatingProxies;
    private RotatingProxies rotatingProxies;
    private int maximumNumberOfTries;
    private long secondsToSleep;
    private Logger logger;
    private boolean useTimedThreadRunner;
    private int secondsBeforeKill;
    private long millisecondsBetweenWatching;

    public DownloadParameters(String string) {
        this.website = string;
        this.redirectHandling = RedirectHandling.STANDARD;
        this.useProxy = false;
        this.maximumNumberOfTries = 1;
        this.useTimedThreadRunner = false;
        this.secondsBeforeKill = -1;
        this.millisecondsBetweenWatching = -1L;
    }

    public String getWebsite() {
        return this.website;
    }

    public RedirectHandling getRedirectHandling() {
        return this.redirectHandling;
    }

    public boolean useProxy() {
        return this.useProxy;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public boolean useRotatingProxies() {
        return this.useRotatingProxies;
    }

    public RotatingProxies getRotatingProxies() {
        return this.rotatingProxies;
    }

    public int getMaximumNumberOfTries() {
        return this.maximumNumberOfTries;
    }

    public long getSecondsToSleep() {
        return this.secondsToSleep;
    }

    public boolean weHaveALogger() {
        return this.logger != null;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean useTimedThreadRunner() {
        return this.useTimedThreadRunner;
    }

    public int getSecondsBeforeKill() {
        return this.secondsBeforeKill;
    }

    public long getMillisecondsBetweenWatching() {
        return this.millisecondsBetweenWatching;
    }

    public void setRedirectHandling(RedirectHandling redirectHandling) {
        this.redirectHandling = redirectHandling;
    }

    public void setUseProxy(boolean bl) {
        this.useProxy = bl;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setUseRotatingProxies(boolean bl) {
        this.useRotatingProxies = bl;
    }

    public void setRotatingProxies(RotatingProxies rotatingProxies) {
        this.rotatingProxies = rotatingProxies;
    }

    public void setMaximumNumberOfTries(int n) {
        this.maximumNumberOfTries = n;
    }

    public void setSecondsToSleep(long l) {
        this.secondsToSleep = l;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setUseTimedThreadRunner(boolean bl) {
        this.useTimedThreadRunner = bl;
    }

    public void setSecondsBeforeKill(int n) {
        this.secondsBeforeKill = n;
    }

    public void setMillisecondsBetweenWatching(long l) {
        this.millisecondsBetweenWatching = l;
    }

    public String toString() {
        return "DownloadParameters [website=" + this.website + ", redirectHandling=" + this.redirectHandling + ", useProxy=" + this.useProxy + ", proxy=" + this.proxy + ", useRotatingProxies=" + this.useRotatingProxies + ", rotatingProxies=" + this.rotatingProxies + ", maximumNumberOfTries=" + this.maximumNumberOfTries + ", secondsToSleep=" + this.secondsToSleep + ", logger=" + this.logger + ", useTimedThreadRunner=" + this.useTimedThreadRunner + ", secondsBeforeKill=" + this.secondsBeforeKill + ", millisecondsBetweenWatching=" + this.millisecondsBetweenWatching + "]";
    }
}

