/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.html.download.logic;

import de.duehl.basics.logging.Logger;
import de.duehl.basics.retry.Retry;
import de.duehl.html.download.data.DownloadInfo;
import de.duehl.html.download.data.DownloadParameters;
import de.duehl.html.download.data.DownloadStatus;
import de.duehl.html.download.logic.HttpClientCreator;
import de.duehl.html.download.logic.HttpGetter;
import de.duehl.html.download.proxy.RotatingProxies;
import de.duehl.threads.timed.TimedThreadRunner;
import java.io.IOException;
import org.apache.http.impl.client.CloseableHttpClient;

public class InternalDownloader {
    private final DownloadInfo downloadInfo;
    private final DownloadParameters parameters;
    private int outerLoopStepNumber;
    private int innerLoopStepNumber;

    public InternalDownloader(DownloadParameters downloadParameters) {
        this.parameters = downloadParameters;
        this.downloadInfo = new DownloadInfo(downloadParameters.getWebsite());
    }

    public DownloadInfo download() {
        this.log("website = " + this.parameters.getWebsite());
        this.outerLoop();
        return this.downloadInfo;
    }

    private void outerLoop() {
        this.log("Start");
        this.outerLoopStepNumber = 0;
        int n = this.parameters.getMaximumNumberOfTries();
        long l = this.parameters.getSecondsToSleep();
        Retry retry = new Retry(this::outerLoopStep, n, l * 1000L);
        retry.tryAndTry();
        if (!retry.isSucessfullyDone()) {
            DownloadStatus downloadStatus = this.downloadInfo.getStatus();
            if (downloadStatus == DownloadStatus.OK) {
                throw new RuntimeException("Logikfeler!");
            }
            this.log("Ganz und gar kein Erfolg in allen Versuchen.");
        }
        this.log("Ende");
    }

    private void outerLoopStep() {
        ++this.outerLoopStepNumber;
        this.log("Start outerLoopStepNumber = " + this.outerLoopStepNumber);
        if (this.parameters.useRotatingProxies()) {
            this.innerLoop();
        } else {
            this.innerLoopStep();
        }
        this.log("Ende outerLoopStepNumber = " + this.outerLoopStepNumber);
    }

    private void innerLoop() {
        this.log("Start outerLoopStepNumber = " + this.outerLoopStepNumber);
        this.innerLoopStepNumber = 0;
        RotatingProxies rotatingProxies = this.parameters.getRotatingProxies();
        int n = rotatingProxies.getNumberOfProxies();
        this.log("numberOfProxies = " + n);
        Retry retry = new Retry(this::innerLoopStep, n, 0L);
        retry.tryAndTry();
        if (!retry.isSucessfullyDone()) {
            throw new RuntimeException("inner loop not successfull");
        }
        this.log("Ende outerLoopStepNumber = " + this.outerLoopStepNumber);
    }

    private void innerLoopStep() {
        ++this.innerLoopStepNumber;
        this.log("Start outerLoopStepNumber = " + this.outerLoopStepNumber + ", innerLoopStepNumber = " + this.innerLoopStepNumber);
        if (this.parameters.useRotatingProxies()) {
            String string = this.parameters.getRotatingProxies().getProxy().toString();
            this.log("rotating-proxies - proxy = " + string);
        }
        if (this.parameters.useTimedThreadRunner()) {
            this.log("TimedThread download");
            int n = this.parameters.getSecondsBeforeKill();
            long l = this.parameters.getMillisecondsBetweenWatching();
            TimedThreadRunner timedThreadRunner = new TimedThreadRunner(n, l, () -> this.singleDownload());
            timedThreadRunner.runTask();
            TimedThreadRunner.TaskState taskState = timedThreadRunner.getTaskState();
            if (taskState == TimedThreadRunner.TaskState.FINISHED_IN_TIME) {
                this.log("Download finished in time!");
            } else {
                this.log("Download wurde abgebrochen!");
                this.downloadInfo.downloadCanceled();
            }
        } else {
            this.log("direct download");
            this.singleDownload();
        }
        this.log("Ende outerLoopStepNumber = " + this.outerLoopStepNumber + ", innerLoopStepNumber = " + this.innerLoopStepNumber);
    }

    private void singleDownload() {
        this.log("Start");
        HttpClientCreator httpClientCreator = new HttpClientCreator(this.parameters);
        try (CloseableHttpClient closeableHttpClient = httpClientCreator.createClosableHttpClient();){
            HttpGetter httpGetter = new HttpGetter(this.parameters, this.downloadInfo);
            httpGetter.loadHttpGet(closeableHttpClient);
            this.log("Ende");
        }
        catch (IOException iOException) {
            this.log("Fehler beim Download: " + iOException.getMessage());
        }
    }

    private void log(String string) {
        if (this.parameters.weHaveALogger()) {
            Logger logger = this.parameters.getLogger();
            logger.log(string, 1);
        }
    }
}

