/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.mp3.player.javazoom;

import de.duehl.mp3.player.javazoom.data.MoreAdvancedPlaybackEvent;
import de.duehl.mp3.player.javazoom.data.MoreAdvancesPlaybackListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;

public class MoreAdvancedPlayer {
    private Bitstream bitstream;
    private Decoder decoder;
    private AudioDevice audioDevide;
    private boolean closed;
    private boolean complete;
    private int lastPosition;
    private List<MoreAdvancesPlaybackListener> listeners;
    private int lastPlayedFrame;
    private int frameIndexCurrent;

    public MoreAdvancedPlayer(InputStream inputStream) {
        this(inputStream, null);
    }

    public MoreAdvancedPlayer(InputStream inputStream, AudioDevice audioDevice) {
        this.bitstream = new Bitstream(inputStream);
        this.closed = false;
        this.complete = false;
        this.lastPosition = -1;
        this.lastPlayedFrame = -1;
        this.listeners = new ArrayList<MoreAdvancesPlaybackListener>();
        if (audioDevice != null) {
            this.audioDevide = audioDevice;
        } else {
            this.createAudioDevice();
        }
        this.openInAudioDevice();
    }

    private void createAudioDevice() {
        try {
            this.tryToCreateAudioDevice();
        }
        catch (JavaLayerException javaLayerException) {
            throw new RuntimeException("Fehler beim Erstellen eines eigenen AudioDevice: ", javaLayerException);
        }
    }

    private void tryToCreateAudioDevice() throws JavaLayerException {
        this.audioDevide = FactoryRegistry.systemRegistry().createAudioDevice();
    }

    private void openInAudioDevice() {
        try {
            this.tryToOpenInAudioDevice();
        }
        catch (JavaLayerException javaLayerException) {
            throw new RuntimeException("Fehler beim \u00d6ffnen des Streams im AudioDevice: ", javaLayerException);
        }
    }

    private void tryToOpenInAudioDevice() throws JavaLayerException {
        this.decoder = new Decoder();
        this.audioDevide.open(this.decoder);
    }

    public void addPlayBackListener(MoreAdvancesPlaybackListener moreAdvancesPlaybackListener) {
        this.listeners.add(moreAdvancesPlaybackListener);
    }

    public boolean play() {
        return this.playFromFrame(0);
    }

    public boolean playFromFrame(int n) {
        return this.play(n, Integer.MAX_VALUE);
    }

    public boolean play(int n, int n2) {
        boolean bl = true;
        int n3 = n;
        while (n3-- > 0 && bl) {
            bl = this.skipFrame();
        }
        return this.playNumberOfFrames(n2 - n);
    }

    private boolean playNumberOfFrames(int n) {
        try {
            return this.tryToPlay(n);
        }
        catch (JavaLayerException javaLayerException) {
            throw new RuntimeException("Fehler beim Abspielen: ", javaLayerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryToPlay(int n) throws JavaLayerException {
        boolean bl = true;
        this.reportStartToListener();
        this.frameIndexCurrent = 0;
        while (this.frameIndexCurrent < n && bl) {
            this.lastPlayedFrame = this.frameIndexCurrent++;
            bl = this.decodeFrame();
        }
        AudioDevice audioDevice = this.audioDevide;
        if (audioDevice != null) {
            audioDevice.flush();
            MoreAdvancedPlayer moreAdvancedPlayer = this;
            synchronized (moreAdvancedPlayer) {
                this.complete = !this.closed;
                this.close();
            }
            this.reportEndToListenerWithOwnPosition(audioDevice);
        }
        return bl;
    }

    private void reportStartToListener() {
        for (MoreAdvancesPlaybackListener moreAdvancesPlaybackListener : this.listeners) {
            moreAdvancesPlaybackListener.playbackStarted(this.createEvent(2));
        }
    }

    private void reportEndToListenerWithOwnPosition(AudioDevice audioDevice) {
        for (MoreAdvancesPlaybackListener moreAdvancesPlaybackListener : this.listeners) {
            moreAdvancesPlaybackListener.playbackFinished(this.createEvent(1, audioDevice.getPosition()));
        }
    }

    private void reportEndToListener() {
        for (MoreAdvancesPlaybackListener moreAdvancesPlaybackListener : this.listeners) {
            moreAdvancesPlaybackListener.playbackFinished(this.createEvent(1));
        }
    }

    private synchronized void close() {
        AudioDevice audioDevice = this.audioDevide;
        if (audioDevice != null) {
            this.closeWithNonNullAUdioDevice(audioDevice);
        }
    }

    private void closeWithNonNullAUdioDevice(AudioDevice audioDevice) {
        this.closed = true;
        this.audioDevide = null;
        audioDevice.close();
        this.lastPosition = audioDevice.getPosition();
        this.closeBitStream();
    }

    private void closeBitStream() {
        try {
            this.bitstream.close();
        }
        catch (BitstreamException bitstreamException) {
            // empty catch block
        }
    }

    protected boolean decodeFrame() {
        try {
            return this.tryToDecodeFrame();
        }
        catch (Exception exception) {
            throw new RuntimeException("Fehler beim Abspielen eines Audio-Frames: ", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryToDecodeFrame() throws BitstreamException, DecoderException, JavaLayerException {
        AudioDevice audioDevice = this.audioDevide;
        if (audioDevice == null) {
            return false;
        }
        Header header = this.bitstream.readFrame();
        if (header == null) {
            return false;
        }
        SampleBuffer sampleBuffer = (SampleBuffer)this.decoder.decodeFrame(header, this.bitstream);
        MoreAdvancedPlayer moreAdvancedPlayer = this;
        synchronized (moreAdvancedPlayer) {
            audioDevice = this.audioDevide;
            if (audioDevice != null) {
                audioDevice.write(sampleBuffer.getBuffer(), 0, sampleBuffer.getBufferLength());
            }
        }
        this.bitstream.closeFrame();
        return true;
    }

    protected boolean skipFrame() {
        try {
            return this.tryToSkipFrame();
        }
        catch (Exception exception) {
            throw new RuntimeException("Fehler beim \u00dcberspringen eines Audio-Frames: ", exception);
        }
    }

    private boolean tryToSkipFrame() throws BitstreamException {
        Header header = this.bitstream.readFrame();
        if (header == null) {
            return false;
        }
        this.bitstream.closeFrame();
        return true;
    }

    private MoreAdvancedPlaybackEvent createEvent(int n) {
        return this.createEvent(n, this.audioDevide.getPosition());
    }

    private MoreAdvancedPlaybackEvent createEvent(int n, int n2) {
        return new MoreAdvancedPlaybackEvent(this, n, n2);
    }

    public void stop() {
        this.reportEndToListener();
        this.close();
    }

    public void flush() {
        if (this.audioDevide != null) {
            this.audioDevide.flush();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public int getLastPosition() {
        return this.lastPosition;
    }

    public int getLastPlayedFrame() {
        return this.lastPlayedFrame;
    }
}

