/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.debug;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.Text;
import de.duehl.swing.debug.data.DebugMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GuiDebugSaver {
    private final List<String> categories;
    private final Map<String, List<DebugMessage>> messagesByCategory;

    public GuiDebugSaver(List<String> list, Map<String, List<DebugMessage>> map) {
        this.categories = list;
        this.messagesByCategory = map;
    }

    public void saveAll(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.appendToLines(arrayList, "###_ALL_DO_NOT_USE_ELSEWHERE###");
        this.writeFile(arrayList, string);
    }

    public void saveByCategories(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.categories) {
            this.appendToLines(arrayList, string2);
        }
        this.writeFile(arrayList, string);
    }

    private void appendToLines(List<String> list, String string) {
        Object object = string.equals("###_ALL_DO_NOT_USE_ELSEWHERE###") ? "Alles:" : string + ":";
        list.add((String)object);
        String string2 = Text.multipleString("~", ((String)object).length());
        list.add(string2);
        list.add("");
        for (DebugMessage debugMessage : this.messagesByCategory.get(string)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(debugMessage.getDate().toString()).append(" ");
            stringBuilder.append(debugMessage.getTime().toString()).append(" ");
            if (string.equals("###_ALL_DO_NOT_USE_ELSEWHERE###")) {
                stringBuilder.append(debugMessage.getCategory()).append(" ");
            }
            stringBuilder.append(debugMessage.getClassName()).append(" ");
            stringBuilder.append(debugMessage.getMethodName()).append(" ");
            stringBuilder.append(debugMessage.getLineNumber()).append(" ");
            stringBuilder.append(debugMessage.getMessage()).append(" ");
            String string3 = stringBuilder.toString();
            list.add(string3);
        }
        list.add("");
        list.add("");
    }

    private void writeFile(List<String> list, String string) {
        FileHelper.writeLinesToFile(list, string, Charset.UTF_8);
    }
}

