/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.debug.dialog;

import de.duehl.basics.system.SystemTools;
import de.duehl.basics.text.NumberString;
import de.duehl.swing.debug.GuiDebugSaver;
import de.duehl.swing.debug.data.DebugMessage;
import de.duehl.swing.debug.dialog.CategoryPanel;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GuiDebugDialog
extends NonModalFrameDialogBase {
    private static final Dimension DILOG_DIMENSION = new Dimension(1800, 1000);
    public static final float DEFAULT_FONT_SIZE = 15.0f;
    private final List<String> categories;
    private final Map<String, List<DebugMessage>> messagesByCategory;
    private final JTabbedPane tabs;
    private final List<CategoryPanel> tabPanels;
    private final JButton increaseFontSizeButton;
    private final JButton standardFontSizeButton;
    private final JButton decreaseFontSizeButton;

    public GuiDebugDialog(List<String> list, Map<String, List<DebugMessage>> map, Point point, Image image) {
        super(point, image, "Optionen", DILOG_DIMENSION);
        this.categories = list;
        this.messagesByCategory = map;
        this.tabs = new JTabbedPane();
        this.tabPanels = new ArrayList<CategoryPanel>();
        this.increaseFontSizeButton = new JButton();
        this.standardFontSizeButton = new JButton();
        this.decreaseFontSizeButton = new JButton();
        this.init();
        this.fillDialog();
    }

    private void init() {
        this.createTabPanelsAndAddToTabs();
        this.showFirstTab();
    }

    private void createTabPanelsAndAddToTabs() {
        this.createAllTab();
        for (String string : this.categories) {
            if (string.equals("###_ALL_DO_NOT_USE_ELSEWHERE###")) continue;
            this.createCategoryTab(string);
        }
    }

    private void createAllTab() {
        List<DebugMessage> list = this.messagesByCategory.get("###_ALL_DO_NOT_USE_ELSEWHERE###");
        CategoryPanel categoryPanel = new CategoryPanel(list);
        categoryPanel.showCategory();
        categoryPanel.crateGui();
        this.tabPanels.add(categoryPanel);
        this.tabs.add("Alle Meldungen", categoryPanel.getPanel());
    }

    private void createCategoryTab(String string) {
        List<DebugMessage> list = this.messagesByCategory.get(string);
        CategoryPanel categoryPanel = new CategoryPanel(list);
        categoryPanel.crateGui();
        this.tabPanels.add(categoryPanel);
        this.tabs.add(string, categoryPanel.getPanel());
    }

    private void showFirstTab() {
        this.tabs.setSelectedIndex(0);
    }

    @Override
    protected void populateDialog() {
        this.initElements();
        this.add(this.tabs, "Center");
        this.add(this.createButtonsPart(), "South");
    }

    private void initElements() {
        this.initIncreaseFontSizeButton();
        this.initStandardFontSizeButton();
        this.initDecreaseFontSizeButton();
    }

    private void initIncreaseFontSizeButton() {
        this.increaseFontSizeButton.setText("+");
        this.increaseFontSizeButton.addActionListener(actionEvent -> this.increaseFontSize());
    }

    private void increaseFontSize() {
        for (CategoryPanel categoryPanel : this.tabPanels) {
            categoryPanel.increaseFontSize();
        }
    }

    private void initStandardFontSizeButton() {
        String string = "default size (" + NumberString.twoDecimalPlaces(15.0) + ")";
        this.standardFontSizeButton.setText(string);
        this.standardFontSizeButton.addActionListener(actionEvent -> this.standardFontSize());
    }

    private void standardFontSize() {
        for (CategoryPanel categoryPanel : this.tabPanels) {
            categoryPanel.standardFontSize();
        }
    }

    private void initDecreaseFontSizeButton() {
        this.decreaseFontSizeButton.setText("-");
        this.decreaseFontSizeButton.addActionListener(actionEvent -> this.decreaseFontSize());
    }

    private void decreaseFontSize() {
        for (CategoryPanel categoryPanel : this.tabPanels) {
            categoryPanel.decreaseFontSize();
        }
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createLeftButtonsPart(), "West");
        jPanel.add(this.createOkButton(), "East");
        return jPanel;
    }

    private Component createLeftButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createSaveAllButton(), "West");
        jPanel.add(this.createSaveByCategoriesButton(), "East");
        return jPanel;
    }

    private Component createSaveAllButton() {
        JButton jButton = new JButton("<html><center>Alle Meldungen in eine<br>chronologische Datei speichern</center></html>");
        jButton.addActionListener(actionEvent -> this.saveAll());
        return jButton;
    }

    private void saveAll() {
        String string = GuiTools.saveFileAs(this.getWindowAsComponent(), SystemTools.getHomeDirectory(), GuiTools.createTextFileFilter());
        if (!string.isBlank()) {
            this.saveAll(string);
        }
    }

    private void saveAll(String string) {
        GuiDebugSaver guiDebugSaver = new GuiDebugSaver(this.categories, this.messagesByCategory);
        guiDebugSaver.saveAll(string);
    }

    private Component createSaveByCategoriesButton() {
        JButton jButton = new JButton("<html><center>Meldungen nach Kategorien in eine Datei<br>mit Bl\u00f6cken pro Kategorie speichern</center></html>");
        jButton.addActionListener(actionEvent -> this.saveByCategories());
        return jButton;
    }

    private void saveByCategories() {
        String string = GuiTools.saveFileAs(this.getWindowAsComponent(), SystemTools.getHomeDirectory(), GuiTools.createTextFileFilter());
        if (!string.isBlank()) {
            this.saveByCategories(string);
        }
    }

    private void saveByCategories(String string) {
        GuiDebugSaver guiDebugSaver = new GuiDebugSaver(this.categories, this.messagesByCategory);
        guiDebugSaver.saveByCategories(string);
    }

    private Component createOkButton() {
        JButton jButton = new JButton("Beenden");
        jButton.addActionListener(actionEvent -> this.closeDialog());
        return jButton;
    }
}

