/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui;

import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class PaintableAreaCalculator {
    private final int paintableWidth;
    private final int paintableHeight;
    private final int upperLeftX;
    private final int upperLeftY;
    private final Point upperLeftPoint;
    private final int lowerRightX;
    private final int lowerRightY;
    private final Point lowerRightPoint;
    private final Rectangle rectangle;

    public PaintableAreaCalculator(Container container) {
        int n = container.getWidth();
        int n2 = container.getHeight();
        Insets insets = container.getInsets();
        this.paintableWidth = n - insets.left - insets.right - 1;
        this.paintableHeight = n2 - insets.top - insets.bottom - 1;
        this.upperLeftX = insets.left;
        this.upperLeftY = insets.top;
        this.upperLeftPoint = new Point(this.upperLeftX, this.upperLeftY);
        this.lowerRightX = n - insets.right - 1;
        this.lowerRightY = n2 - insets.bottom - 1;
        this.lowerRightPoint = new Point(this.lowerRightX, this.lowerRightY);
        this.rectangle = new Rectangle(this.upperLeftX, this.upperLeftY, this.paintableWidth, this.paintableHeight);
    }

    public int getPaintableWidth() {
        return this.paintableWidth;
    }

    public int getPaintableHeight() {
        return this.paintableHeight;
    }

    public int getUpperLeftX() {
        return this.upperLeftX;
    }

    public int getUpperLeftY() {
        return this.upperLeftY;
    }

    public Point getUpperLeftPoint() {
        return this.upperLeftPoint;
    }

    public int getLowerRightX() {
        return this.lowerRightX;
    }

    public int getLowerRightY() {
        return this.lowerRightY;
    }

    public Point getLowerRightPoint() {
        return this.lowerRightPoint;
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }
}

