/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.buttons;

import de.duehl.swing.ui.GuiTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ThumbnailAndTextButtonPair {
    private static final int DEFAULT_MAX_TEXT_LENGTH = 50;
    private final String text;
    private final JPanel panel;
    private boolean thumbnailShown = false;
    private int maxTextLenght;
    private final JButton thumbnailButton;
    private final JButton textButton;

    public ThumbnailAndTextButtonPair(String string) {
        this.text = string;
        this.thumbnailShown = false;
        this.maxTextLenght = 50;
        this.panel = new JPanel();
        this.thumbnailButton = new JButton();
        this.textButton = new JButton();
        this.initElements();
    }

    public void setThumbnail(BufferedImage bufferedImage) {
        this.thumbnailShown = true;
        this.thumbnailButton.setIcon(new ImageIcon(bufferedImage));
        this.thumbnailButton.setMargin(new Insets(0, 0, 5, 0));
    }

    public void setMaxTextLenght(int n) {
        this.maxTextLenght = n;
    }

    private void initElements() {
        this.initTextButton();
        this.dispatchMouseScrollEvent();
    }

    private void initTextButton() {
        String string = this.createCollectionText();
        this.textButton.setText(string);
    }

    private void dispatchMouseScrollEvent() {
        GuiTools.dispatchMouseScrollEvent(this.panel, 4);
        GuiTools.dispatchMouseScrollEvent(this.thumbnailButton, 5);
        GuiTools.dispatchMouseScrollEvent(this.textButton, 5);
    }

    private String createCollectionText() {
        return GuiTools.createHtmlTextForButtonsWithUnderscoreReplacement(this.text, this.maxTextLenght);
    }

    public void createGui() {
        this.panel.setLayout(new BorderLayout());
        if (this.thumbnailShown) {
            this.panel.add((Component)this.thumbnailButton, "Center");
        }
        this.panel.add((Component)this.textButton, "South");
    }

    public void addActionListener(Runnable runnable) {
        this.textButton.addActionListener((ActionEvent actionEvent) -> runnable.run());
        this.thumbnailButton.addActionListener((ActionEvent actionEvent) -> runnable.run());
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

