/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.buttons.painted;

import de.duehl.swing.ui.buttons.painted.PaintedButton;
import de.duehl.swing.ui.geometry.PixelPoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.RenderingHints;
import java.util.ArrayList;

public final class LinedStarButton
extends PaintedButton {
    private static final long serialVersionUID = 1L;
    private static final boolean SHOW_AREA_RECTANGLE = false;
    private int number;

    public LinedStarButton() {
        this(5);
    }

    public LinedStarButton(int n) {
        this(Color.BLACK, n);
    }

    public LinedStarButton(Color color, int n) {
        super(color);
        this.number = n;
    }

    @Override
    protected void paintHorizontalSymbolRectangle() {
        this.paintSymbol();
    }

    @Override
    protected void paintVerticalSymbolRectangle() {
        this.paintSymbol();
    }

    @Override
    protected void paintHorizontalSymbolSquare() {
        this.paintSymbol();
    }

    @Override
    protected void paintVerticalSymbolSquare() {
        this.paintSymbol();
    }

    private void paintSymbol() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.isForceSquare()) {
            n2 = n = Math.min(n, n2);
        }
        int n3 = 6;
        int n4 = (this.getWidth() - n) / 2;
        int n5 = n4 + n3;
        int n6 = n4 + n - 1;
        int n7 = n6 - n3;
        int n8 = (this.getHeight() - n2) / 2;
        int n9 = n8 + n3;
        int n10 = n8 + n2 - 1;
        int n11 = n10 - n3;
        float f = 360.0f / (float)this.number;
        float f2 = -90.0f;
        int n12 = n7 - n5;
        int n13 = n11 - n9;
        int n14 = n5 + n12 / 2;
        int n15 = n9 + n13 / 2;
        int n16 = Math.min(n, n2) / 2;
        int n17 = n16 - n3;
        ArrayList<PixelPoint> arrayList = new ArrayList<PixelPoint>();
        for (int i = 0; i < this.number; ++i) {
            double d = (float)(2 * i) * f;
            double d2 = d + (double)f2;
            double d3 = Math.PI * d2 / 180.0;
            int n18 = (int)((double)n17 * Math.cos(d3)) + n14;
            int n19 = (int)((double)n17 * Math.sin(d3)) + n15;
            PixelPoint pixelPoint = new PixelPoint(n18, n19);
            arrayList.add(pixelPoint);
        }
        this.graphics2.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this.graphics2.setStroke(new BasicStroke(1.0f, 1, 1));
        this.paintHollowPolygon(arrayList);
    }
}

