/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.buttons.painted.state;

import de.duehl.swing.ui.buttons.painted.state.PaintedStateButton;
import de.duehl.swing.ui.geometry.PixelPoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.RenderingHints;
import java.util.ArrayList;

public final class StarButton
extends PaintedStateButton {
    private static final long serialVersionUID = 1L;
    private static final int LINE_WIDTH = 1;
    private static final boolean SHOW_AREA_RECTANGLE = false;
    private static final double INNER_FROM_OUTER_RATION = 0.4;
    private static final int CORRECTION_TO_RADIUS = 2;
    private static final int CORRECTION_TO_CENTER_X = 0;
    private static final int CORRECTION_TO_CENTER_Y = 0;
    private int spikeNumber;

    public StarButton() {
        this(5);
    }

    public StarButton(int n) {
        this(Color.BLACK, n);
    }

    public StarButton(Color color, int n) {
        super(color);
        this.spikeNumber = n;
    }

    @Override
    protected void paintHorizontalSymbolRectangle() {
        this.paintSymbol();
    }

    @Override
    protected void paintVerticalSymbolRectangle() {
        this.paintSymbol();
    }

    @Override
    protected void paintHorizontalSymbolSquare() {
        this.paintSymbol();
    }

    @Override
    protected void paintVerticalSymbolSquare() {
        this.paintSymbol();
    }

    private void paintSymbol() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.isForceSquare()) {
            n2 = n = Math.min(n, n2);
        }
        int n3 = 6;
        int n4 = (this.getWidth() - n) / 2;
        int n5 = n4 + n3;
        int n6 = n4 + n - 1;
        int n7 = n6 - n3;
        int n8 = (this.getHeight() - n2) / 2;
        int n9 = n8 + n3;
        int n10 = n8 + n2 - 1;
        int n11 = n10 - n3;
        int n12 = n7 - n5;
        int n13 = n11 - n9;
        int n14 = 0 + n5 + n12 / 2;
        int n15 = 0 + n9 + n13 / 2;
        int n16 = Math.min(n, n2) / 2;
        int n17 = 2 + n16 - n3;
        int n18 = (int)((double)n17 * 0.4);
        double d = Math.toRadians(-90.0);
        double d2 = Math.PI / (double)this.spikeNumber;
        ArrayList<PixelPoint> arrayList = new ArrayList<PixelPoint>();
        for (int i = 0; i < this.spikeNumber * 2; ++i) {
            double d3 = i % 2 == 0 ? (double)n17 : (double)n18;
            double d4 = (double)n14 + Math.cos(d) * d3;
            double d5 = (double)n15 + Math.sin(d) * d3;
            arrayList.add(new PixelPoint((int)d4, (int)d5));
            d += d2;
        }
        this.graphics2.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this.graphics2.setStroke(new BasicStroke(1.0f, 1, 1));
        if (this.isElected()) {
            this.paintPolygon(arrayList);
        } else {
            this.paintHollowPolygon(arrayList);
        }
    }
}

