/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.layout.VerticalLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MultipleElementsPanel<C extends Component>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int MAXIMAL_NUMBER_OF_COLUMNNS = 10;
    private static final int MAXIMAL_NUMBER_OF_ELEMENTS_PER_COLUMNN = 30;
    private final List<C> elements = new ArrayList<C>();
    private int columns;
    private final int maximalNumberOfColumns;
    private final int wantedMaximalNumberOfElementsPerColumn;
    private int maximalNumberOfElementsPerColumn;
    private final List<JPanel> columnPanels;

    public MultipleElementsPanel() {
        this(new ArrayList(), 10, 30);
    }

    public MultipleElementsPanel(List<C> list) {
        this(list, 10, 30);
    }

    public MultipleElementsPanel(int n, int n2) {
        this(new ArrayList(), n, n2);
    }

    public MultipleElementsPanel(List<C> list, int n, int n2) {
        this.elements.addAll(list);
        this.maximalNumberOfColumns = n;
        this.wantedMaximalNumberOfElementsPerColumn = n2;
        this.columnPanels = new ArrayList<JPanel>();
        this.fillPanel();
    }

    private void fillPanel() {
        this.removeAll();
        this.columnPanels.clear();
        this.maximalNumberOfElementsPerColumn = this.wantedMaximalNumberOfElementsPerColumn;
        this.columns = this.determineNumberOfColumns();
        this.setLayout(new GridLayout(0, this.columns));
        this.createColumnPanels();
        this.addColumnPanels();
        this.distributeElements();
        this.validate();
    }

    private int determineNumberOfColumns() {
        int n = this.elements.size();
        int n2 = n / this.maximalNumberOfElementsPerColumn;
        if (n2 * this.maximalNumberOfElementsPerColumn < n) {
            ++n2;
        }
        if (n2 == 0) {
            return 1;
        }
        if (n2 > this.maximalNumberOfColumns) {
            ++this.maximalNumberOfElementsPerColumn;
            return this.determineNumberOfColumns();
        }
        return n2;
    }

    private void createColumnPanels() {
        for (int i = 0; i < this.columns; ++i) {
            this.columnPanels.add(this.createColumnPanel());
        }
    }

    private JPanel createColumnPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        return jPanel;
    }

    private void addColumnPanels() {
        for (Component component : this.columnPanels) {
            this.add(component);
        }
    }

    private void distributeElements() {
        for (int i = 0; i < this.elements.size(); ++i) {
            Component component = (Component)this.elements.get(i);
            int n = this.determineColumn(i);
            JPanel jPanel = this.columnPanels.get(n);
            jPanel.add(component);
        }
    }

    private int determineColumn(int n) {
        int n2 = 0;
        while (n + 1 > (n2 + 1) * this.maximalNumberOfElementsPerColumn) {
            ++n2;
        }
        if (n2 >= this.columns) {
            throw new RuntimeException("Fehler in der Berechnung!\n\tcolumn = " + n2 + "\n\tcolumns = " + this.columns + "\n\tindex = " + n + "\n\telements = " + this.elements);
        }
        return n2;
    }

    public void colorize(Colorizer colorizer) {
        colorizer.setColors(this);
        for (Component component : this.elements) {
            colorizer.setColors(component);
        }
        for (Component component : this.columnPanels) {
            colorizer.setColors(component);
        }
    }

    public void addElement(C c) {
        this.elements.add(c);
        this.fillPanel();
    }

    public void removeElement(C c) {
        this.elements.remove(c);
        this.fillPanel();
    }

    public List<C> getElements() {
        return this.elements;
    }

    public static MultipleElementsPanel<JLabel> createFromTexts(List<String> list) {
        return MultipleElementsPanel.createFromTexts(list, 10, 30);
    }

    public static MultipleElementsPanel<JLabel> createFromTexts(List<String> list, int n, int n2) {
        ArrayList<JLabel> arrayList = new ArrayList<JLabel>();
        for (String string : list) {
            JLabel jLabel = MultipleElementsPanel.createTextLabel(string);
            arrayList.add(jLabel);
        }
        return new MultipleElementsPanel<JLabel>(arrayList, n, n2);
    }

    public static JLabel createTextLabel(String string) {
        JLabel jLabel = new JLabel(string);
        GuiTools.biggerFont(jLabel, 2);
        jLabel.setBorder(BorderFactory.createLineBorder(Color.BLUE, 1));
        return jLabel;
    }
}

