/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.elements;

import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.components.elements.TextFieldWithChangeButton;
import de.duehl.swing.ui.components.selections.OptionSelection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TextFieldWithChangeButtonAndOption {
    private final OptionSelection titleBox;
    private final TextFieldWithChangeButton fieldWithButton;
    private final Component panel;

    public TextFieldWithChangeButtonAndOption(String string) {
        this.titleBox = new OptionSelection(string);
        this.fieldWithButton = new TextFieldWithChangeButton();
        this.addChangeListener(this.createCheckBoxChangeListener());
        this.panel = this.createPanel();
    }

    private ChangeListener createCheckBoxChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TextFieldWithChangeButtonAndOption.this.reactOnCheckBoxClick();
            }
        };
    }

    private void reactOnCheckBoxClick() {
        boolean bl = this.titleBox.isSelected();
        this.fieldWithButton.setEnabled(bl);
    }

    private void addChangeListener(ChangeListener changeListener) {
        this.titleBox.addChangeListener(changeListener);
    }

    public boolean isSelected() {
        return this.titleBox.isSelected();
    }

    public void setSelected(boolean bl) {
        this.titleBox.setSelected(bl);
    }

    private Component createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.titleBox.getCheckBox(), "West");
        jPanel.add(this.fieldWithButton.getPanel(), "Center");
        return jPanel;
    }

    public Component getPanel() {
        return this.panel;
    }

    public void colorize(Colorizer colorizer) {
        colorizer.setColors(this.panel);
        this.titleBox.colorize(colorizer);
        this.fieldWithButton.colorize(colorizer);
    }

    public void addButtonActionListener(ActionListener actionListener) {
        this.fieldWithButton.addButtonActionListener(actionListener);
    }

    public String getText() {
        return this.fieldWithButton.getText();
    }

    public void setText(String string) {
        this.fieldWithButton.setText(string);
    }

    public void setButtonText(String string) {
        this.fieldWithButton.setButtonText(string);
    }

    public void setPreferredSize(Dimension dimension) {
        this.fieldWithButton.setPreferredSize(dimension);
    }

    public void setButtonPreferredSize(Dimension dimension) {
        this.fieldWithButton.setButtonPreferredSize(dimension);
    }

    public void clickButton() {
        this.fieldWithButton.clickButton();
    }

    public void addKeyListener(KeyListener keyListener) {
        this.fieldWithButton.addKeyListener(keyListener);
    }

    public void addReturnKeyClickButtonListener() {
        this.fieldWithButton.addReturnKeyClickButtonListener();
    }
}

