/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.MultipleElementsPanel;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;

public class CharsetDialog
extends ModalDialogBase {
    private static final Color CHARSET_BUTTON_BACKGROUND = new Color(230, 230, 255);
    private static final Color DEFAULT_CHARSET_BUTTON_BACKGROUND = new Color(230, 255, 230);
    private Charset selectedCharset = Charset.getDefaultCharset();
    private JButton defaultCharsetButton;

    public CharsetDialog(Point point, Image image, String string) {
        super(point, image, CharsetDialog.createTitle(string));
        this.fillDialog();
        this.defaultCharsetButton.requestFocusInWindow();
    }

    private static String createTitle(String string) {
        return "Bitte das Charset f\u00fcr die Datei" + FileHelper.getBareName(string) + " ausw\u00e4hlen.";
    }

    @Override
    protected void populateDialog() {
        this.add(this.createCharsetButtonPart(), "Center");
        this.add(this.createButtonPart(), "South");
        this.addEscapeBehaviour();
    }

    private Component createCharsetButtonPart() {
        List<JButton> list = this.createCharsetButtons();
        return this.createMultiplePanel(list);
    }

    private List<JButton> createCharsetButtons() {
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        for (Charset charset : this.sortedCharsets()) {
            arrayList.add(this.createCharsetButtonWithSelection(charset));
        }
        return arrayList;
    }

    protected List<Charset> sortedCharsets() {
        ArrayList<Charset> arrayList = new ArrayList<Charset>();
        for (Charset charset : Charset.values()) {
            arrayList.add(charset);
        }
        Collections.sort(arrayList, new Comparator<Charset>(){

            @Override
            public int compare(Charset charset, Charset charset2) {
                String string = charset.getCharsetAsString();
                String string2 = charset2.getCharsetAsString();
                return string.compareTo(string2);
            }
        });
        return arrayList;
    }

    private JButton createCharsetButtonWithSelection(Charset charset) {
        JButton jButton = this.createCharsetButton(charset);
        if (Charset.getDefaultCharset() == charset) {
            jButton.setBackground(DEFAULT_CHARSET_BUTTON_BACKGROUND);
            this.defaultCharsetButton = jButton;
        }
        return jButton;
    }

    private JButton createCharsetButton(Charset charset) {
        JButton jButton = new JButton(charset.getCharsetAsString());
        jButton.addActionListener(actionEvent -> this.buttonPressed(charset));
        jButton.setOpaque(true);
        jButton.setBackground(CHARSET_BUTTON_BACKGROUND);
        GuiTools.biggerFont(jButton, 5);
        return jButton;
    }

    private void buttonPressed(Charset charset) {
        this.selectedCharset = charset;
        this.closeDialog();
    }

    private Component createMultiplePanel(List<JButton> list) {
        int n = 3;
        int n2 = 3;
        return new MultipleElementsPanel<JButton>(list, n, n2);
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createQuitButton(), "East");
        return jPanel;
    }

    private JButton createQuitButton() {
        JButton jButton = new JButton("Schlie\u00dfen");
        this.setColors(jButton);
        jButton.addActionListener(actionEvent -> this.closeDialog());
        jButton.setFocusable(false);
        return jButton;
    }

    public Charset getSelectedCharset() {
        return this.selectedCharset;
    }
}

