/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs.base;

import de.duehl.swing.logic.Quitter;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.dialogs.base.AbstractDialogBase;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;

public abstract class ModalDialogBase
extends AbstractDialogBase {
    private final JDialog dialog = new JDialog();

    public ModalDialogBase(String string) {
        this(new Point(0, 0), null, string, IGNORE_DIMENSION, null);
        this.ignoreSize();
    }

    public ModalDialogBase(String string, Dimension dimension) {
        this(new Point(0, 0), null, string, dimension, null);
    }

    public ModalDialogBase(Point point, Image image, String string) {
        this(point, image, string, IGNORE_DIMENSION, null);
        this.ignoreSize();
    }

    public ModalDialogBase(Point point, Image image, String string, Dimension dimension) {
        this(point, image, string, dimension, null);
    }

    public ModalDialogBase(Point point, Image image, String string, Colorizer colorizer) {
        this(point, image, string, IGNORE_DIMENSION, colorizer);
        this.ignoreSize();
    }

    public ModalDialogBase(Point point, Image image, String string, Dimension dimension, Colorizer colorizer) {
        super(point, image, dimension, colorizer);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.setTitle(string);
        this.setWindow(this.dialog);
    }

    public void setUndecorated(boolean bl) {
        this.dialog.setUndecorated(bl);
    }

    protected final void changeTitle(String string) {
        this.dialog.setTitle(string);
        this.refresh();
    }

    public String getTitle() {
        return this.dialog.getTitle();
    }

    public void setTitle(String string) {
        this.changeTitle(string);
    }

    @Override
    public final JRootPane getRootPane() {
        return this.dialog.getRootPane();
    }

    @Override
    public void addClosingWindowListener(Quitter quitter) {
        super.addClosingWindowListener(quitter);
        this.dialog.setDefaultCloseOperation(0);
    }

    public JDialog getRealDialog() {
        return this.dialog;
    }

    public void addMenu(JMenuBar jMenuBar) {
        this.dialog.setJMenuBar(jMenuBar);
        this.dialog.validate();
    }

    public void setLocationRelativeToNothing() {
        this.dialog.setLocationRelativeTo(null);
    }
}

