/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs.lists.logic;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.dialogs.lists.logic.LogicalEditableList;
import de.duehl.swing.ui.dialogs.lists.logic.LogicalEditableListElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class LogicalEditableListBase<Element extends LogicalEditableListElement>
implements LogicalEditableList<Element>,
Iterable<Element> {
    private final List<Element> list = new ArrayList<Element>();

    @Override
    public final Iterator<Element> iterator() {
        return this.list.iterator();
    }

    @Override
    public final boolean contains(Element Element2) {
        return this.list.contains(Element2);
    }

    @Override
    public final void add(Element Element2) {
        if (!this.canWeAdd(Element2)) {
            throw new IllegalArgumentException("Das Element\n\t" + Element2 + "\nkann nicht zur Liste hinzugef\u00fcgt werden, bitte vorher mit canWeAdd(element) \u00fcberpr\u00fcfen!");
        }
        this.list.add(Element2);
    }

    @Override
    public boolean canWeAdd(Element Element2) {
        return !this.contains(Element2);
    }

    @Override
    public final void remove(Element Element2) {
        this.checkIfElementIsContainedInList(Element2);
        this.list.remove(Element2);
    }

    @Override
    public final boolean canMoveUp(Element Element2) {
        this.checkIfElementIsContainedInList(Element2);
        return this.list.indexOf(Element2) > 0;
    }

    @Override
    public final void moveUp(Element Element2) {
        this.checkIfElementIsContainedInList(Element2);
        if (this.canMoveUp(Element2)) {
            int n = this.list.indexOf(Element2);
            int n2 = n - 1;
            Collections.swap(this.list, n, n2);
        }
    }

    @Override
    public final boolean canMoveDown(Element Element2) {
        this.checkIfElementIsContainedInList(Element2);
        return this.list.indexOf(Element2) < this.list.size() - 1;
    }

    @Override
    public final void moveDown(Element Element2) {
        this.checkIfElementIsContainedInList(Element2);
        if (this.canMoveDown(Element2)) {
            int n = this.list.indexOf(Element2);
            int n2 = n + 1;
            Collections.swap(this.list, n, n2);
        }
    }

    private void checkIfElementIsContainedInList(Element Element2) {
        if (!this.list.contains(Element2)) {
            throw new IllegalArgumentException("Das \u00fcbergebene Element " + Element2 + " ist nicht in der Liste enthalten!");
        }
    }

    public final int size() {
        return this.list.size();
    }

    public final Element get(int n) {
        return (Element)((LogicalEditableListElement)this.list.get(n));
    }

    protected final List<Element> getList() {
        return this.list;
    }

    @Override
    public final boolean containedMoreThanOnce(Element Element2) {
        return CollectionsHelper.containedMoreThanOnce(this.list, Element2);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public String toString() {
        return "LogicalEditableListBase [list=" + this.list + "]";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.list == null ? 0 : this.list.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LogicalEditableListBase logicalEditableListBase = (LogicalEditableListBase)object;
        return !(this.list == null ? logicalEditableListBase.list != null : !this.list.equals(logicalEditableListBase.list));
    }
}

