/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.progress;

import de.duehl.basics.system.SystemTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.elements.progress.StandardColoredProgressPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class ProgressDialog
extends ModalDialogBase {
    private static final int DIALOG_WIDTH = 800;
    private final StandardColoredProgressPanel progressPanel;

    public ProgressDialog(String string, Point point, Image image) {
        super(point, image, string);
        this.addClosingWindowListener(() -> {});
        this.progressPanel = new StandardColoredProgressPanel();
    }

    public ProgressDialog setProgressTitle(String string) {
        this.progressPanel.setProgressTitle(string);
        return this;
    }

    public ProgressDialog setCountPrefix(String string) {
        this.progressPanel.setCountPrefix(string);
        return this;
    }

    public ProgressDialog setTimerPrefix(String string) {
        this.progressPanel.setTimerPrefix(string);
        return this;
    }

    public ProgressDialog setActualElementPrefix(String string) {
        this.progressPanel.setActualElementPrefix(string);
        return this;
    }

    public ProgressDialog setActualElementPrefixBeforeStart(String string) {
        this.progressPanel.setActualElementPrefixBeforeStart(string);
        return this;
    }

    public ProgressDialog setActualElementWhenDone(String string) {
        this.progressPanel.setActualElementWhenDone(string);
        return this;
    }

    public ProgressDialog createProgressPanel() {
        this.progressPanel.createProgressPanel();
        return this;
    }

    public void createUi() {
        SwingUtilities.invokeLater(() -> this.createUiInEdt());
    }

    private void createUiInEdt() {
        this.fillDialog();
        this.setVisible(true);
    }

    @Override
    protected void populateDialog() {
        this.add(this.createDummyLabelForDialogWidth(), "North");
        this.add(this.progressPanel.getComponent(), "Center");
    }

    private Component createDummyLabelForDialogWidth() {
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(800, 0));
        return jLabel;
    }

    public void initNumberOfTasksToDo(int n) {
        this.progressPanel.initNumberOfTasksToDo(n);
    }

    public void startingWithTask() {
        this.progressPanel.startingWithTask();
    }

    public void aboutToExceuteOneTaskSoon(String string) {
        this.progressPanel.aboutToExceuteOneTaskSoon(string);
    }

    public void oneTaskDone(String string) {
        this.progressPanel.oneTaskDone(string);
    }

    public void quit() {
        this.progressPanel.quit();
    }

    public void closeUi() {
        SystemTools.sleep(250L);
        SwingUtilities.invokeLater(() -> this.closeUiInEdt());
    }

    private void closeUiInEdt() {
        this.closeDialog();
    }
}

