/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.filter.method.combination;

import de.duehl.swing.ui.filter.exceptions.FilterException;
import de.duehl.swing.ui.filter.method.Method;
import de.duehl.swing.ui.filter.method.combination.CombinationElementType;

public class CombinationElement<Data> {
    private CombinationElementType type;
    private Method<Data> method;

    public CombinationElement(CombinationElementType combinationElementType) {
        this.type = combinationElementType;
        this.method = null;
        if (combinationElementType == CombinationElementType.METHOD) {
            throw new FilterException("Falscher Filtermethodenkombinationsaufruf 1");
        }
    }

    public CombinationElement(Method<Data> method) {
        this.type = CombinationElementType.METHOD;
        this.method = method;
        if (null == method) {
            throw new FilterException("Falscher Filtermethodenkombinationsaufruf 2");
        }
    }

    public boolean isOpeningBrace() {
        return this.type == CombinationElementType.BRACE_OPEN;
    }

    public boolean isClosingBrace() {
        return this.type == CombinationElementType.BRACE_CLOSE;
    }

    public boolean isNegation() {
        return this.type == CombinationElementType.NOT;
    }

    public boolean isIntersection() {
        return this.type == CombinationElementType.INTERSECTION;
    }

    public boolean isUnion() {
        return this.type == CombinationElementType.UNION;
    }

    public boolean isMethod() {
        return this.type == CombinationElementType.METHOD;
    }

    public Method<Data> getMethod() {
        if (this.type != CombinationElementType.METHOD) {
            throw new FilterException("Es wurde eine Methode eines Nicht-Methoden-Kombinationselements abgefragt.");
        }
        return this.method;
    }

    public String toString() {
        return "CombinationElement [type=" + this.type + ", method=" + this.method + "]";
    }
}

