/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.move;

import de.duehl.swing.ui.buttons.painted.DownButton;
import de.duehl.swing.ui.buttons.painted.FirstButton;
import de.duehl.swing.ui.buttons.painted.LastButton;
import de.duehl.swing.ui.buttons.painted.UpButton;
import de.duehl.swing.ui.colors.ColorTool;
import de.duehl.swing.ui.move.data.VerticalMoveButtonsUser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JPanel;

public class VerticalMoveButtons {
    public static final String DEFAULT_MOVE_BUTTON_COLOR = "darkgreen";
    public static final String DEFAULT_DISABLED_COLOR = "darkgray";
    public static final Dimension DEFAULT_BUTTON_DIMENSION = new Dimension(35, 35);
    private final VerticalMoveButtonsUser moveButtonsUser;
    private final JPanel panel;
    private final FirstButton firstButton;
    private final UpButton upButton;
    private final DownButton downButton;
    private final LastButton lastButton;
    private Color moveButtonColor;
    private Color disabledColor;
    private Dimension buttonDimension;

    public VerticalMoveButtons(VerticalMoveButtonsUser verticalMoveButtonsUser) {
        this.moveButtonsUser = verticalMoveButtonsUser;
        this.panel = new JPanel();
        this.moveButtonColor = ColorTool.getColorByName(DEFAULT_MOVE_BUTTON_COLOR);
        this.disabledColor = ColorTool.getColorByName(DEFAULT_DISABLED_COLOR);
        this.buttonDimension = DEFAULT_BUTTON_DIMENSION;
        this.firstButton = new FirstButton(this.disabledColor);
        this.upButton = new UpButton(this.disabledColor);
        this.downButton = new DownButton(this.disabledColor);
        this.lastButton = new LastButton(this.disabledColor);
        this.init();
    }

    private void init() {
        this.initMoveUpAndDownButtonsPanel();
        this.initMoveButtons();
    }

    private void initMoveUpAndDownButtonsPanel() {
        this.panel.setLayout(new GridLayout(1, 0, 2, 2));
        this.panel.add(this.firstButton);
        this.panel.add(this.upButton);
        this.panel.add(this.downButton);
        this.panel.add(this.lastButton);
    }

    private void initMoveButtons() {
        this.firstButton.setHorizontal(false);
        this.firstButton.forceSquare();
        this.firstButton.addActionListener(actionEvent -> this.moveButtonsUser.moveMoveButtonsUserToFirst());
        this.upButton.forceSquare();
        this.upButton.addActionListener(actionEvent -> this.moveButtonsUser.moveMoveButtonsUserUp());
        this.downButton.forceSquare();
        this.downButton.addActionListener(actionEvent -> this.moveButtonsUser.moveMoveButtonsUserDown());
        this.lastButton.setHorizontal(false);
        this.lastButton.forceSquare();
        this.lastButton.addActionListener(actionEvent -> this.moveButtonsUser.moveMoveButtonsUserToLast());
        this.initMoveButtonsPreferredSize();
    }

    private void initMoveButtonsPreferredSize() {
        this.firstButton.setPreferredSize(this.buttonDimension);
        this.upButton.setPreferredSize(this.buttonDimension);
        this.downButton.setPreferredSize(this.buttonDimension);
        this.lastButton.setPreferredSize(this.buttonDimension);
    }

    public void setMoveButtonColor(Color color) {
        this.moveButtonColor = color;
        this.setUpAndDownButtonColorsAndEnabled();
    }

    public void setDisabledColor(Color color) {
        this.disabledColor = color;
        this.setUpAndDownButtonColorsAndEnabled();
    }

    public void setMoveButtonColor(String string) {
        this.moveButtonColor = ColorTool.getColorByName(string);
        this.setUpAndDownButtonColorsAndEnabled();
    }

    public void setDisabledColor(String string) {
        this.disabledColor = ColorTool.getColorByName(string);
        this.setUpAndDownButtonColorsAndEnabled();
    }

    public void setButtonDimension(Dimension dimension) {
        this.buttonDimension = dimension;
        this.initMoveButtonsPreferredSize();
    }

    public void setUpAndDownButtonColorsAndEnabled() {
        boolean bl = this.moveButtonsUser.canMoveButtonsUserMoveUp();
        Color color = bl ? this.moveButtonColor : this.disabledColor;
        this.upButton.setSymbolColor(color);
        this.upButton.setEnabled(bl);
        this.upButton.repaint();
        this.firstButton.setSymbolColor(color);
        this.firstButton.setEnabled(bl);
        this.firstButton.repaint();
        boolean bl2 = this.moveButtonsUser.canMoveButtonsUserMoveDown();
        Color color2 = bl2 ? this.moveButtonColor : this.disabledColor;
        this.downButton.setSymbolColor(color2);
        this.downButton.setEnabled(bl2);
        this.downButton.repaint();
        this.lastButton.setSymbolColor(color2);
        this.lastButton.setEnabled(bl2);
        this.lastButton.repaint();
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

