/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.tabs.bars.generic;

import de.duehl.swing.ui.tabs.Tabulator;
import de.duehl.swing.ui.tabs.close.CloseButtonReaktor;
import de.duehl.swing.ui.tabs.elements.TabElements;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;

public class TabBar<T extends Component> {
    private final boolean showCloseButton;
    private final JTabbedPane tabs;
    private final List<TabElements<T>> tabElementsList;

    public TabBar() {
        this(true);
    }

    protected TabBar(JTabbedPane jTabbedPane) {
        this(true, jTabbedPane);
    }

    public TabBar(boolean bl) {
        this(bl, TabBar.createTabs());
    }

    protected TabBar(boolean bl, JTabbedPane jTabbedPane) {
        this.showCloseButton = bl;
        this.tabs = jTabbedPane;
        this.tabElementsList = new ArrayList<TabElements<T>>();
    }

    private static JTabbedPane createTabs() {
        return new JTabbedPane(1, 1);
    }

    protected final int getSelectedIndex() {
        return this.tabs.getSelectedIndex();
    }

    protected final int getTabCount() {
        return this.tabs.getTabCount();
    }

    public TabElements<T> addTab(String string, T t) {
        TabElements<T> tabElements = this.createNewTabElements(string, t);
        this.addTab(tabElements);
        return tabElements;
    }

    private TabElements<T> createNewTabElements(String string, T t) {
        Tabulator tabulator = this.createTabulator(string);
        return new TabElements<T>(string, tabulator, t);
    }

    private Tabulator createTabulator(String string) {
        String string2 = "Title: " + string;
        if (this.showCloseButton) {
            return new Tabulator(string2, string, this.createCloseReaktor(string), this.showCloseButton);
        }
        return new Tabulator(string2, string, this.showCloseButton);
    }

    private CloseButtonReaktor createCloseReaktor(final String string) {
        return new CloseButtonReaktor(){

            @Override
            public void closeButtonPressed(String string2) {
                TabBar.this.removeTab(string);
            }
        };
    }

    public final void addTab(TabElements<T> tabElements) {
        this.checkForAlreadyUsedTitles(tabElements.getTitle());
        this.tabElementsList.add(tabElements);
        this.populateOneTab(tabElements);
    }

    private void checkForAlreadyUsedTitles(String string) {
        if (this.isTitleAlreadyInUse(string)) {
            throw new IllegalArgumentException("Der Titel '" + string + "' wird bereites verwendet!");
        }
    }

    public final boolean isTitleAlreadyInUse(String string) {
        for (TabElements<T> tabElements : this.tabElementsList) {
            String string2 = tabElements.getTitle();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private void populateOneTab(TabElements<T> tabElements) {
        String string = tabElements.getTitle();
        this.tabs.add(string, (Component)tabElements.getShownComponent());
        int n = this.tabs.indexOfTab(string);
        Tabulator tabulator = tabElements.getTabulator();
        this.tabs.setTabComponentAt(n, tabulator);
    }

    public void removeTab(String string) {
        for (TabElements<T> tabElements : this.tabElementsList) {
            String string2 = tabElements.getTitle();
            if (!string.equals(string2)) continue;
            this.tabElementsList.remove(tabElements);
            this.tabs.remove((Component)tabElements.getShownComponent());
            return;
        }
    }

    public void removeAllTabs() {
        this.tabs.removeAll();
        this.tabElementsList.clear();
    }

    public final Component getComponent() {
        return this.tabs;
    }

    public final void validate() {
        this.tabs.validate();
    }

    public final List<TabElements<T>> getTabElementsList() {
        return this.tabElementsList;
    }

    private TabElements<T> getTabElementsListByTitle(String string) {
        for (TabElements<T> tabElements : this.tabElementsList) {
            String string2 = tabElements.getTitle();
            if (!string.equals(string2)) continue;
            return tabElements;
        }
        throw new IllegalArgumentException("Zum Titel '" + string + "' wurden keine Tabulator-Elemente gefunden!");
    }

    public final Tabulator getTabulatorByTitle(String string) {
        TabElements<T> tabElements = this.getTabElementsListByTitle(string);
        return tabElements.getTabulator();
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.tabs.addChangeListener(changeListener);
    }

    public TabElements<T> getSelectedTabElements() {
        int n = this.tabs.getSelectedIndex();
        if (-1 != n) {
            TabElements<T> tabElements = this.tabElementsList.get(n);
            return tabElements;
        }
        return null;
    }

    public final void select(TabElements<Component> tabElements) {
        this.tabs.setSelectedComponent(tabElements.getShownComponent());
    }

    public final void select(String string) {
        TabElements<T> tabElements = this.getTabElementsListByTitle(string);
        this.tabs.setSelectedComponent((Component)tabElements.getShownComponent());
    }

    public String generateNotUsedTitle(String string) {
        Object object = string;
        while (this.isTitleAlreadyInUse((String)object)) {
            object = (String)object + "_";
        }
        return object;
    }
}

