/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.text.html;

import de.duehl.basics.text.html.HtmlTool;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.text.TextPanel;
import de.duehl.swing.ui.text.html.HtmlPanel;
import de.duehl.swing.ui.text.html.HtmlPanelCard;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.JPanel;

public class HtmlCardPanel {
    private static final Dimension PANEL_DIMENSION = new Dimension(1000, 750);
    private final JPanel cardPanel;
    private final CardLayout cardLayout;
    private HtmlPanelCard currentCard;
    private final HtmlPanel htmlPanel = new HtmlPanel();
    private final TextPanel sourceCodePanel = new TextPanel();

    public HtmlCardPanel() {
        this.cardPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.initShowPartsAndScrolls();
        this.fillThePanel();
    }

    private void initShowPartsAndScrolls() {
        this.initSourceCodeTextArea();
        this.setPreferredSize(PANEL_DIMENSION);
    }

    private void initSourceCodeTextArea() {
        this.sourceCodePanel.biggerFont(3);
        this.sourceCodePanel.useMonoscpacedText();
    }

    private void fillThePanel() {
        this.cardPanel.setLayout(this.cardLayout);
        this.cardPanel.add(this.htmlPanel.getComponent(), HtmlPanelCard.HTML.name());
        this.cardPanel.add(this.sourceCodePanel.getComponent(), HtmlPanelCard.SOURCE_CODE.name());
        this.currentCard = HtmlPanelCard.HTML;
    }

    public void switchCard() {
        this.currentCard = this.currentCard.getNext();
        this.cardLayout.show(this.cardPanel, this.currentCard.name());
        this.cardPanel.validate();
    }

    public HtmlPanelCard getCurrentCard() {
        return this.currentCard;
    }

    public void showHtml(URL uRL) {
        this.htmlPanel.showHtml(uRL);
        this.sourceCodePanel.setText(HtmlTool.createContentFromUrl(uRL));
    }

    public void setColors(Colorizer colorizer) {
        if (null != colorizer) {
            this.htmlPanel.setColors(colorizer);
            this.sourceCodePanel.setColors(colorizer);
            colorizer.setColors(this.cardPanel);
        }
    }

    public void setText(String string) {
        this.htmlPanel.setText(string);
        this.sourceCodePanel.setText(string);
    }

    public void setTextAndScrollToTop(String string) {
        this.setText(string);
        this.scrollScrollbarToMinimumLater();
    }

    public JPanel getCardPanel() {
        return this.cardPanel;
    }

    public void scrollScrollbarToMinimumLater() {
        this.htmlPanel.scrollScrollbarToMinimumLater();
        this.sourceCodePanel.scrollScrollbarToMinimumLater();
    }

    public void scrollScrollbarToMaximumLater() {
        this.htmlPanel.scrollScrollbarToMaximumLater();
        this.sourceCodePanel.scrollScrollbarToMaximumLater();
    }

    public void scrollScrollbarToPreviousSectionLater() {
        this.htmlPanel.scrollScrollbarToPreviousSectionLater();
        this.sourceCodePanel.scrollScrollbarToPreviousSectionLater();
    }

    public void scrollScrollbarToNextSectionLater() {
        this.htmlPanel.scrollScrollbarToNextSectionLater();
        this.sourceCodePanel.scrollScrollbarToNextSectionLater();
    }

    public int getTextLength() {
        return this.htmlPanel.getTextLength();
    }

    public void repaint() {
        this.htmlPanel.repaint();
        this.sourceCodePanel.repaint();
    }

    public void setPreferredSize(Dimension dimension) {
        this.setPreferredSize(dimension.width, dimension.height);
    }

    public void setPreferredSize(int n, int n2) {
        this.htmlPanel.setPreferredSize(n, n2);
        this.sourceCodePanel.setPreferredSize(n, n2);
    }

    public void setDragEnabled(boolean bl) {
        this.htmlPanel.setDragEnabled(bl);
    }

    public void setCaretPosition(int n) {
        this.htmlPanel.setCaretPosition(n);
    }

    public int getCaretPosition() {
        return this.htmlPanel.getCaretPosition();
    }

    public Rectangle getVisibleRect() {
        return this.htmlPanel.getVisibleRect();
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        this.htmlPanel.scrollRectToVisible(rectangle);
    }

    public int getSelectionStart() {
        return this.htmlPanel.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.htmlPanel.getSelectionEnd();
    }

    public void setSelectionStart(int n) {
        this.htmlPanel.setSelectionStart(n);
    }

    public void setSelectionEnd(int n) {
        this.htmlPanel.setSelectionEnd(n);
    }

    public String getSelectedText() {
        return this.htmlPanel.getSelectedText();
    }

    public void clearSelection() {
        this.htmlPanel.clearSelection();
    }

    public boolean hasFocus() {
        return this.htmlPanel.hasFocus();
    }

    public void setBackground(Color color) {
        this.htmlPanel.setBackground(color);
        this.sourceCodePanel.setBackground(color);
    }

    public void ignorePageUpAndPageDown() {
        this.htmlPanel.ignorePageUpAndPageDown();
        this.sourceCodePanel.ignorePageUpAndPageDown();
    }

    public void ignoreUpAndDown() {
        this.htmlPanel.ignoreUpAndDown();
        this.sourceCodePanel.ignoreUpAndDown();
    }

    public void ignoreCtrlPos1AndCtrlEnd() {
        this.htmlPanel.ignoreCtrlPos1AndCtrlEnd();
        this.sourceCodePanel.ignoreCtrlPos1AndCtrlEnd();
    }

    public void showCursor() {
        this.htmlPanel.showCursor();
    }

    public void storeVerticalPosition() {
        this.htmlPanel.storeVerticalPosition();
    }

    public void restoreVerticalPosition() {
        this.htmlPanel.restoreVerticalPosition();
    }

    public String getHtmlText() {
        return this.htmlPanel.getHtmlText();
    }

    public void sourceCodePanelBiggerFont(int n) {
        this.sourceCodePanel.biggerFont(n);
    }
}

