/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.common.data;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class InternalAdditionalKanaData {
    private String filename = "";
    private String key = "";
    private int testCount = 0;
    private int correctTestCount = 0;
    private ImmutualDate lastTestDate = InternalAdditionalVocableData.NOT_SEEN_DATE;
    private ImmutualDate lastCorrectTestDate = InternalAdditionalVocableData.NOT_SEEN_DATE;
    private List<Boolean> lastTenTestResults = new ArrayList<Boolean>();
    private static final int NUMBER_OF_LINES = 6;

    public String getFilename() {
        return this.filename;
    }

    public InternalAdditionalKanaData setFilename(String string) {
        this.filename = string;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public InternalAdditionalKanaData setKey(String string) {
        this.key = string;
        return this;
    }

    public int getTestCount() {
        return this.testCount;
    }

    public InternalAdditionalKanaData setTestCount(int n) {
        this.testCount = n;
        return this;
    }

    public int getCorrectTestCount() {
        return this.correctTestCount;
    }

    public InternalAdditionalKanaData setCorrectTestCount(int n) {
        this.correctTestCount = n;
        return this;
    }

    public ImmutualDate getLastTestDate() {
        return this.lastTestDate;
    }

    public InternalAdditionalKanaData setLastTestDate(ImmutualDate immutualDate) {
        this.lastTestDate = immutualDate;
        return this;
    }

    public ImmutualDate getLastCorrectTestDate() {
        return this.lastCorrectTestDate;
    }

    public InternalAdditionalKanaData setLastCorrectTestDate(ImmutualDate immutualDate) {
        this.lastCorrectTestDate = immutualDate;
        return this;
    }

    public String getLastTenTestResultsAsStorageString() {
        return InternalAdditionalVocableData.lastTenTestResultsToStorageString(this.lastTenTestResults);
    }

    public List<Boolean> getLastTenTestResults() {
        return this.lastTenTestResults;
    }

    public int getLastTenTestsCount() {
        return this.lastTenTestResults.size();
    }

    public int getLastCorrectTestsCount() {
        return InternalAdditionalVocableData.getLastCorrectTestsCount(this.lastTenTestResults);
    }

    public InternalAdditionalKanaData initLastTenTestResultsFromStorageString(String string) {
        InternalAdditionalVocableData.initLastTenTestResultsFromStorageString(this.lastTenTestResults, string);
        return this;
    }

    public void tested(boolean bl) {
        this.testedWithoutSave(bl);
        this.save();
    }

    private void testedWithoutSave(boolean bl) {
        ImmutualDate immutualDate = new ImmutualDate();
        this.increaseTestCount();
        this.setLastTestDate(immutualDate);
        if (bl) {
            this.increaseCorrectTestCount();
            this.setLastCorrectTestDate(immutualDate);
        }
        this.lastTenTestResults.add(bl);
        while (this.lastTenTestResults.size() > 10) {
            this.lastTenTestResults.remove(0);
        }
    }

    private void increaseTestCount() {
        ++this.testCount;
    }

    private void increaseCorrectTestCount() {
        ++this.correctTestCount;
    }

    public static InternalAdditionalKanaData load(String string) {
        List<String> list = FileHelper.readFileToList(string, Charset.UTF_8);
        if (list.size() == 6) {
            return InternalAdditionalKanaData.loadFromNormalFormat(string, list);
        }
        throw new RuntimeException("Die Datei " + string + " enth\u00e4lt nicht wie erwartet 6 Zeilen.");
    }

    private static InternalAdditionalKanaData loadFromNormalFormat(String string, List<String> list) {
        int n = 0;
        String string2 = list.get(n++);
        String string3 = list.get(n++);
        String string4 = list.get(n++);
        String string5 = list.get(n++);
        String string6 = list.get(n++);
        String string7 = list.get(n++);
        int n2 = NumberString.parseInt(string3);
        int n3 = NumberString.parseInt(string4);
        ImmutualDate immutualDate = new ImmutualDate(string5);
        ImmutualDate immutualDate2 = new ImmutualDate(string6);
        InternalAdditionalKanaData internalAdditionalKanaData = new InternalAdditionalKanaData();
        internalAdditionalKanaData.setFilename(string);
        internalAdditionalKanaData.setKey(string2);
        internalAdditionalKanaData.setTestCount(n2);
        internalAdditionalKanaData.setCorrectTestCount(n3);
        internalAdditionalKanaData.setLastTestDate(immutualDate);
        internalAdditionalKanaData.setLastCorrectTestDate(immutualDate2);
        internalAdditionalKanaData.initLastTenTestResultsFromStorageString(string7);
        return internalAdditionalKanaData;
    }

    public void save() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.key);
        arrayList.add(Integer.toString(this.testCount));
        arrayList.add(Integer.toString(this.correctTestCount));
        arrayList.add(this.lastTestDate.toString());
        arrayList.add(this.lastCorrectTestDate.toString());
        arrayList.add(InternalAdditionalVocableData.lastTenTestResultsToStorageString(this.lastTenTestResults));
        FileHelper.writeLinesToFile(arrayList, this.filename, Charset.UTF_8);
    }

    public String toString() {
        return "InternalAdditionalKanaData [filename=" + this.filename + ", key=" + this.key + ", testCount=" + this.testCount + ", correctTestCount=" + this.correctTestCount + ", lastTestDate=" + this.lastTestDate + ", lastCorrectTestDate=" + this.lastCorrectTestDate + ", lastTenTestResults=" + this.lastTenTestResults + "]";
    }

    public String toNiceString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Text.multipleString(" ", n);
        stringBuilder.append(string + "InternalAdditionalKanaData:\n");
        stringBuilder.append(string + "filename           : " + this.filename + "\n");
        stringBuilder.append(string + "key                : " + this.key + "\n");
        stringBuilder.append(string + "getestet          : " + this.testCount + "\n");
        stringBuilder.append(string + "correctTestCount   : " + this.correctTestCount + "\n");
        stringBuilder.append(string + "lastTestDate       : " + this.lastTestDate + "\n");
        stringBuilder.append(string + "lastCorrectTestDate: " + this.lastCorrectTestDate + "\n");
        stringBuilder.append(string + "lastTenTestResults : " + InternalAdditionalVocableData.lastTenTestResultsToStorageString(this.lastTenTestResults) + "\n");
        return stringBuilder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.correctTestCount, this.filename, this.key, this.lastCorrectTestDate, this.lastTenTestResults, this.lastTestDate, this.testCount);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        InternalAdditionalKanaData internalAdditionalKanaData = (InternalAdditionalKanaData)object;
        return this.correctTestCount == internalAdditionalKanaData.correctTestCount && Objects.equals(this.filename, internalAdditionalKanaData.filename) && Objects.equals(this.key, internalAdditionalKanaData.key) && Objects.equals(this.lastCorrectTestDate, internalAdditionalKanaData.lastCorrectTestDate) && Objects.equals(this.lastTenTestResults, internalAdditionalKanaData.lastTenTestResults) && Objects.equals(this.lastTestDate, internalAdditionalKanaData.lastTestDate) && this.testCount == internalAdditionalKanaData.testCount;
    }
}

