/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.common.website.update.vocables;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.common.website.download.WebsiteFileContentDownloader;
import de.duehl.vocabulary.japanese.common.website.update.vocables.parser.VocableVersionParser;
import java.util.List;

public class VocablesActualityChecker {
    private final String vocabulariesPath;
    private boolean versionOnWebserverDetermined;
    private String websiteVocableVersion;
    private boolean localVersionDetermined;
    private String localVocableVersion;
    private ImmutualDate websiteDate;
    private int websiteNumber;
    private ImmutualDate localDate;
    private int localNumber;
    private boolean actual;

    public VocablesActualityChecker(String string) {
        this.vocabulariesPath = string;
    }

    public void check() {
        this.init();
        this.downloadVersionFromWebsite();
        if (this.versionOnWebserverDetermined) {
            this.parseVocableVersionFromWebsite();
            if (this.versionOnWebserverDetermined) {
                this.determineLocalVocablesVersion();
                if (this.localVersionDetermined) {
                    this.parseLocalVocableVersion();
                    if (this.localVersionDetermined) {
                        this.compareWebsiteAndLocalVocableVersion();
                    }
                }
            }
        }
    }

    private void init() {
        this.versionOnWebserverDetermined = false;
        this.websiteVocableVersion = "";
        this.localVersionDetermined = false;
        this.localVocableVersion = "";
        this.actual = false;
    }

    private void downloadVersionFromWebsite() {
        this.websiteVocableVersion = WebsiteFileContentDownloader.downloadFileViaUrlFromServerAndGetContentOfFirstLine("https://www.duehl.de/vokabel_trainer_japanisch/Neuste_Version_Vokabeln.txt");
        if (this.websiteVocableVersion.equals("Kein Erfolg beim Download!")) {
            this.versionOnWebserverDetermined = false;
            this.websiteVocableVersion = "";
        } else {
            this.versionOnWebserverDetermined = true;
        }
    }

    private void parseVocableVersionFromWebsite() {
        VocableVersionParser vocableVersionParser = new VocableVersionParser(this.websiteVocableVersion);
        vocableVersionParser.parse();
        if (vocableVersionParser.isSuccess()) {
            this.websiteDate = vocableVersionParser.getDate();
            this.websiteNumber = vocableVersionParser.getNumber();
        } else {
            this.versionOnWebserverDetermined = false;
        }
    }

    private void determineLocalVocablesVersion() {
        this.localVocableVersion = VocablesActualityChecker.determineLocalVocableVersion(this.vocabulariesPath);
        this.localVersionDetermined = !this.localVocableVersion.isEmpty();
    }

    static String determineLocalVocableVersion(String string) {
        List<String> list;
        String string2 = FileHelper.concatPathes(string, "Version_Vokabeln.txt");
        if (!FileHelper.isFile(string2)) {
            list = FileHelper.findAllDirectoriesNio2(string);
            boolean bl = false;
            for (String string3 : list) {
                string2 = FileHelper.concatPathes(string3, "Version_Vokabeln.txt");
                if (!FileHelper.isFile(string2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                Text.say("Keine Version der lokalen Vokabeln vorhanden, denn die lokale Datei '" + string2 + "' existiert nicht.");
                return "";
            }
        }
        if ((list = FileHelper.readFileToList(string2)).isEmpty()) {
            Text.say("Keine Version der lokalen Vokabeln vorhanden, denn die lokale Datei '" + string2 + "' ist leer.");
            return "";
        }
        return list.get(0).trim();
    }

    private void parseLocalVocableVersion() {
        VocableVersionParser vocableVersionParser = new VocableVersionParser(this.localVocableVersion);
        vocableVersionParser.parse();
        if (vocableVersionParser.isSuccess()) {
            this.localDate = vocableVersionParser.getDate();
            this.localNumber = vocableVersionParser.getNumber();
        } else {
            this.localVersionDetermined = false;
        }
    }

    private void compareWebsiteAndLocalVocableVersion() {
        this.actual = this.websiteDate.before(this.localDate) ? true : (this.websiteDate.after(this.localDate) ? false : this.localNumber >= this.websiteNumber);
    }

    public boolean isVersionOnWebserverDetermined() {
        return this.versionOnWebserverDetermined;
    }

    public String getWebsiteVocableVersion() {
        return this.websiteVocableVersion;
    }

    public boolean isLocalVersionDetermined() {
        return this.localVersionDetermined;
    }

    public String getLocalVocableVersion() {
        return this.localVocableVersion;
    }

    public boolean isActual() {
        return this.actual;
    }
}

