/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.data.symbol;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.List;

public enum Kanji {
    FISCH("\u9b5a", CollectionsHelper.buildListFrom("Fisch"), CollectionsHelper.buildListFrom("GYO"), CollectionsHelper.buildListFrom("sakana", "uo"), "\u9b5a", "\u3055\u304b\u306a", 290, 112, 1),
    FLEISCH("\u8089", CollectionsHelper.buildListFrom("Fleisch"), CollectionsHelper.buildListFrom("NIKU"), CollectionsHelper.buildListFrom(new String[0]), "\u8089", "\u306b\u304f", 223, 102, 2),
    EI("\u5375", CollectionsHelper.buildListFrom("Ei"), CollectionsHelper.buildListFrom("RAN"), CollectionsHelper.buildListFrom("tamago"), "\u5375", "\u305f\u307e\u3054", 1103, 228, 3),
    WASSER("\u6c34", CollectionsHelper.buildListFrom("Wasser"), CollectionsHelper.buildListFrom("SUI"), CollectionsHelper.buildListFrom("mizu"), "\u6c34", "\u307f\u305a", 21, 73, 4),
    ESSEN("\u98df", CollectionsHelper.buildListFrom("essen"), CollectionsHelper.buildListFrom("SHOKU", "[JIKI]"), CollectionsHelper.buildListFrom("ta(beru)", "ku(u)", "ku(rau)"), "\u98df\u3079\u308b", "\u305f\u3079\u308b", 322, 116, 5),
    TRINKEN("\u98f2", CollectionsHelper.buildListFrom("trinken"), CollectionsHelper.buildListFrom("IN"), CollectionsHelper.buildListFrom("no(mu)"), "\u98f2\u3080", "\u306e\u3080", 323, 117, 6),
    GROSS("\u5927", CollectionsHelper.buildListFrom("gro\u00df"), CollectionsHelper.buildListFrom("DAI", "TAI"), CollectionsHelper.buildListFrom("oo(kii)", "oo-", "oo(ini)"), "\u5927\u304d\u3044", "\u3061\u3044\u3055\u3044", 26, 74, 7),
    KLEIN("\u5c0f", CollectionsHelper.buildListFrom("klein"), CollectionsHelper.buildListFrom("SHOU"), CollectionsHelper.buildListFrom("chii(sai)", "ko-", "o-"), "\u5c0f\u3055\u3044", "\u3061\u3044\u3055\u3044", 27, 74, 8),
    NEU("\u65b0", CollectionsHelper.buildListFrom("neu"), CollectionsHelper.buildListFrom("SHIN"), CollectionsHelper.buildListFrom("atara(shii)", "ara(ta)", "nii-"), "\u65b0\u3057\u3044", "\u3042\u305f\u3089\u3057\u3044", 174, 95, 9),
    ALT("\u53e4", CollectionsHelper.buildListFrom("alt"), CollectionsHelper.buildListFrom("KO"), CollectionsHelper.buildListFrom("furu(i)", "furu(su)"), "\u53e4\u3044", "\u3075\u308b\u3044", 172, 95, 10),
    TAG_SONNE("\u65e5", CollectionsHelper.buildListFrom("Tag", "Sonne"), CollectionsHelper.buildListFrom("NICHI", "JITSU"), CollectionsHelper.buildListFrom("hi", "ka"), "\u65e5", "\u306b\u3061", 5, 71, 11),
    BUCH_URSPRUNG("\u672c", CollectionsHelper.buildListFrom("Buch", "Ursprung", "Haupt-"), CollectionsHelper.buildListFrom("HON"), CollectionsHelper.buildListFrom("moto"), "\u672c", "\u307b\u3093", 25, 74, 12),
    PERSON_MENSCH("\u4eba", CollectionsHelper.buildListFrom("Person", "Mensch"), CollectionsHelper.buildListFrom("JIN", "NIN"), CollectionsHelper.buildListFrom("hito"), "\u4eba", "\u3072\u3068", 1, 71, 13),
    GEHEN_FAHREN("\u884c", CollectionsHelper.buildListFrom("gehen", "fahren", "fliegen"), CollectionsHelper.buildListFrom("KOU", "[AN]", "GYOU"), CollectionsHelper.buildListFrom("i(ku)", "yu(ku)", "okona(u)"), "\u884c\u304f", "\u3044\u304f", 68, 80, 14),
    ELEKTRIZITAET("\u96fb", CollectionsHelper.buildListFrom("Elektrizit\u00e4t"), CollectionsHelper.buildListFrom("DEN"), CollectionsHelper.buildListFrom(new String[0]), "\u96fb\u8eca", "\u3067\u3093\u3057\u3083", 108, 86, 15),
    AUTO_WAGEN_RAD("\u8eca", CollectionsHelper.buildListFrom("Auto", "Wagen", "Rad"), CollectionsHelper.buildListFrom("SHA"), CollectionsHelper.buildListFrom("kuruma"), "\u8eca", "\u304f\u308b\u307e", 133, 89, 16),
    FRAU("\u5973", CollectionsHelper.buildListFrom("Frau", "weiblich"), CollectionsHelper.buildListFrom("JO", "NYO", "[NYOU]"), CollectionsHelper.buildListFrom("onna", "me"), "\u5973", "\u304a\u3093\u306a", 102, 85, 17),
    MANN("\u7537", CollectionsHelper.buildListFrom("Mann"), CollectionsHelper.buildListFrom("DAN", "NAN"), CollectionsHelper.buildListFrom("otoko"), "\u7537", "\u304a\u3068\u3053", 101, 85, 18),
    SPRECHEN("\u8a71", CollectionsHelper.buildListFrom("sprechen", "reden"), CollectionsHelper.buildListFrom("WA"), CollectionsHelper.buildListFrom("hanashi", "hana(su)"), "\u8a71\u3059", "\u306f\u306a\u3059", 238, 104, 19),
    SICH_TREFFEN("\u4f1a", CollectionsHelper.buildListFrom("sich treffen", "sich versammeln"), CollectionsHelper.buildListFrom("KAI", "E"), CollectionsHelper.buildListFrom("a(u)"), "\u4f1a\u3046", "\u3042\u3046", 158, 93, 20),
    SICH_AUSRUHEN("\u4f11", CollectionsHelper.buildListFrom("sich ausruhen", "ruhen", "ruhen lassen"), CollectionsHelper.buildListFrom("KYUU"), CollectionsHelper.buildListFrom("yasu(mu)", "yasu(meru)", "yasu(maru)"), "\u4f11\u3080", "\u4f11", 60, 79, 21),
    SEHEN_ANSEHEN("\u898b", CollectionsHelper.buildListFrom("sehen", "ansehen"), CollectionsHelper.buildListFrom("KEN"), CollectionsHelper.buildListFrom("mi(ru)", "mi(eru)", "mi(seru)"), "\u898b\u308b", "\u307f\u308b", 63, 79, 22),
    HIMMEL_PARADIES("\u5929", CollectionsHelper.buildListFrom("Himmel", "Paradies"), CollectionsHelper.buildListFrom("TEN"), CollectionsHelper.buildListFrom("ame", "[ama]"), "\u5929\u6c17", "\u3066\u3093\u304d", 141, 91, 23),
    GEIST_SEELE_ENERGIE("\u6c17", CollectionsHelper.buildListFrom("Geist", "Seele", "Energie"), CollectionsHelper.buildListFrom("KI", "KE"), CollectionsHelper.buildListFrom(new String[0]), "\u5143\u6c17", "\u3052\u3093\u304d", 134, 90, 24),
    STADT_ORTSCHAFT("\u753a", CollectionsHelper.buildListFrom("Stadt", "Ortschaft"), CollectionsHelper.buildListFrom("CHOU"), CollectionsHelper.buildListFrom("machi"), "\u753a", "\u307e\u3061", 182, 96, 25),
    LERNEN("\u5b66", CollectionsHelper.buildListFrom("lernen", "Wissenschaft", "Studium"), CollectionsHelper.buildListFrom("GAKU"), CollectionsHelper.buildListFrom("mana(bu)"), "\u5927\u5b66", "\u3060\u3044\u304c\u304f", 109, 86, 26),
    BLUME("\u82b1", CollectionsHelper.buildListFrom("Blume", "Bl\u00fcte"), CollectionsHelper.buildListFrom("KA"), CollectionsHelper.buildListFrom("hana"), "\u82b1", "\u306f\u306a", 255, 107, 27),
    JETZT("\u4eca", CollectionsHelper.buildListFrom("jetzt", "gegenw\u00e4rtig", "dieser"), CollectionsHelper.buildListFrom("KON", "KIN"), CollectionsHelper.buildListFrom("ima"), "\u4eca", "\u3044\u307e", 51, 78, 28),
    ZEIT_STUNDE("\u6642", CollectionsHelper.buildListFrom("Zeit", "Stunde", "... Uhr"), CollectionsHelper.buildListFrom("JI"), CollectionsHelper.buildListFrom("toki"), "\u6642", "\u3058", 42, 76, 29),
    TEILEN_VERSTEHEN_TEIL_MINUTE("\u5206", CollectionsHelper.buildListFrom("teilen", "Teil", "Minute", "verstehen", "Prozent", "geteilt sein"), CollectionsHelper.buildListFrom("BUN", "BU", "FUN", "PUN"), CollectionsHelper.buildListFrom("wa(keru)", "wa(katsu)", "wa(kareru)", "wa(karu)"), "\u5206\u304b\u308b", "\u308f\u304b\u308b", 38, 76, 30),
    SPITZE_ZUVOR("\u5148", CollectionsHelper.buildListFrom("Spitze", "zuvor", "fr\u00fcher", "voraus", "k\u00fcnftig"), CollectionsHelper.buildListFrom("SEN"), CollectionsHelper.buildListFrom("saki"), "\u5148", "\u3055\u304d", 50, 78, 31),
    GEBAEREN_LEBEN("\u751f", CollectionsHelper.buildListFrom("geb\u00e4ren", "leben", "lebendig sein", "beleben"), CollectionsHelper.buildListFrom("SEI", "SHOU"), CollectionsHelper.buildListFrom("i(kiru)", "i(keru)", "i(kasu)", "u(mu)", "ha(yasu)", "ha(eru)", "o(u)"), "\u751f\u3080", "\u3046\u3080", 44, 77, 32),
    SPRACHE("\u8a9e", CollectionsHelper.buildListFrom("Sprache", "sprechen", "erz\u00e4hlen"), CollectionsHelper.buildListFrom("GO"), CollectionsHelper.buildListFrom("kata(ru)", "kata(rau)"), "\u8a9e", "\u3054", 67, 80, 33),
    REGEN("\u96e8", CollectionsHelper.buildListFrom("Regen"), CollectionsHelper.buildListFrom("U"), CollectionsHelper.buildListFrom("ame", "[ama]"), "\u96e8", "\u3042\u3081", 30, 75, 34),
    KOMMEN("\u6765", CollectionsHelper.buildListFrom("kommen", "f\u00fchren zu"), CollectionsHelper.buildListFrom("RAI"), CollectionsHelper.buildListFrom("ku(ru)", "kita(ru)", "kita(su)"), "\u6765\u308b", "\u304f\u308b", 69, 80, 35),
    FEUER("\u706b", CollectionsHelper.buildListFrom("Feuer"), CollectionsHelper.buildListFrom("KA"), CollectionsHelper.buildListFrom("hi", "[ho]"), "\u706b", "\u3072", 20, 73, 36),
    BAUM_HOLZ("\u6728", CollectionsHelper.buildListFrom("Baum", "Holz"), CollectionsHelper.buildListFrom("BOKU", "MOKU"), CollectionsHelper.buildListFrom("ki", "[ka]"), "\u6728", "\u304d", 22, 74, 37),
    WENIG("\u5c11", CollectionsHelper.buildListFrom("wenig", "gering", "ein wenig", "etwas"), CollectionsHelper.buildListFrom("SHOU"), CollectionsHelper.buildListFrom("suko(shi)", "suku(nai)"), "\u5c11\u3057", "\u3059\u3053\u3057", 144, 91, 38),
    VIEL_ZAHLREICH("\u591a", CollectionsHelper.buildListFrom("viel", "zahlreich", "viele", "gro\u00df"), CollectionsHelper.buildListFrom("TA"), CollectionsHelper.buildListFrom("oo(i)"), "\u591a\u3044", "\u304a\u304a\u3044", 229, 103, 39),
    WAS("\u4f55", CollectionsHelper.buildListFrom("was", "welcher", "wie viele"), CollectionsHelper.buildListFrom("KA"), CollectionsHelper.buildListFrom("nani", "[nan]"), "\u4f55", "\u306a\u306b", 392, 126, 40),
    HOEREN_FRAGEN("\u805e", CollectionsHelper.buildListFrom("h\u00f6ren", "fragen", "zuh\u00f6ren", "vernehmbar sein"), CollectionsHelper.buildListFrom("BUN", "MON"), CollectionsHelper.buildListFrom("ki(ku)", "ki(koru)"), "\u805e\u304f", "\u304d\u304f", 64, 80, 41),
    KAUFEN("\u8cb7", CollectionsHelper.buildListFrom("kaufen"), CollectionsHelper.buildListFrom("BAI"), CollectionsHelper.buildListFrom("ka(u)"), "\u8cb7\u3046", "\u304b\u3046", 241, 105, 42),
    HOCH_TEUER("\u9ad8", CollectionsHelper.buildListFrom("hoch", "teuer", "steigen", "zunehmen"), CollectionsHelper.buildListFrom("KOU"), CollectionsHelper.buildListFrom("taka(i)", "taka", "taka(maru)", "taka(meru)"), "\u9ad8\u3044", "\u305f\u304b\u3044", 190, 98, 43),
    BILLIG_SICHER("\u5b89", CollectionsHelper.buildListFrom("billig", "(sicher)", "Friede", "Ruhe"), CollectionsHelper.buildListFrom("AN"), CollectionsHelper.buildListFrom("yasu(i)"), "\u5b89\u3044", "\u3084\u3059\u3044", 105, 85, 44),
    KIND("\u5b50", CollectionsHelper.buildListFrom("Kind"), CollectionsHelper.buildListFrom("SHI", "SU"), CollectionsHelper.buildListFrom("ko"), "\u5b50\u4f9b", "\u3053\u3069\u3082", 103, 85, 45),
    WEISS("\u767d", CollectionsHelper.buildListFrom("Wei\u00df"), CollectionsHelper.buildListFrom("HAKU", "BYAKU"), CollectionsHelper.buildListFrom("shiro(i)", "shiro"), "\u767d", "\u3057\u308d", 205, 100, 46),
    LADEN_GESCHAEFT("\u5e97", CollectionsHelper.buildListFrom("Laden", "Gesch\u00e4ft"), CollectionsHelper.buildListFrom("TEN"), CollectionsHelper.buildListFrom("mise"), "\u5e97", "\u307f\u305b", 168, 94, 47),
    MOND_MONAT("\u6708", CollectionsHelper.buildListFrom("Mond", "Monat"), CollectionsHelper.buildListFrom("GETSU", "GATSU"), CollectionsHelper.buildListFrom("tsuki"), "\u6708", "\u3064\u304d", 17, 73, 48),
    FUENF_5("\u4e94", CollectionsHelper.buildListFrom("f\u00fcnf", "5"), CollectionsHelper.buildListFrom("GO"), CollectionsHelper.buildListFrom("itsu(tsu)", "itsu-"), "\u4e94", "\u3054", 7, 71, 49),
    MITTE_INNEN("\u4e2d", CollectionsHelper.buildListFrom("Mitte", "innen", "China", "Inneres", "zwischen"), CollectionsHelper.buildListFrom("CHUU", "-CHUU", "-JUU"), CollectionsHelper.buildListFrom("naka"), "\u4e2d", "\u306a\u304b", 28, 74, 50),
    MITTAG("\u5348", CollectionsHelper.buildListFrom("Mittag"), CollectionsHelper.buildListFrom("GO"), CollectionsHelper.buildListFrom(new String[0]), "\u5348\u5f8c", "\u3054\u3054", 49, 77, 51),
    EINS_1("\u4e00", CollectionsHelper.buildListFrom("eins", "1"), CollectionsHelper.buildListFrom("ICHI", "ITSU"), CollectionsHelper.buildListFrom("hito(tsu)", "hito-"), "\u4e00", "\u3044\u3061", 2, 71, 52),
    ZWEI_2("\u4e8c", CollectionsHelper.buildListFrom("zwei", "2"), CollectionsHelper.buildListFrom("NI"), CollectionsHelper.buildListFrom("futa(tsu)", "futa-"), "\u4e8c", "\u306b", 3, 71, 53),
    DREI_3("\u4e09", CollectionsHelper.buildListFrom("drei", "3"), CollectionsHelper.buildListFrom("SAN"), CollectionsHelper.buildListFrom("mit(tsu)", "mi(tsu)", "mi-"), "\u4e09", "\u3054", 4, 71, 54),
    VIER_4("\u56db", CollectionsHelper.buildListFrom("vier", "4"), CollectionsHelper.buildListFrom("SHI"), CollectionsHelper.buildListFrom("yot(tsu)", "yo(tsu)", "yo-", "yon"), "\u56db", "\u3057", 6, 71, 55),
    SECHS_6("\u516d", CollectionsHelper.buildListFrom("sechs", "6"), CollectionsHelper.buildListFrom("ROKU"), CollectionsHelper.buildListFrom("mut(tsu)", "mu(tsu)", "mu-", "[mui-]"), "\u516d", "\u308d\u304f", 8, 72, 56),
    SIEBEN_7("\u4e03", CollectionsHelper.buildListFrom("sieben", "7"), CollectionsHelper.buildListFrom("SHICHI"), CollectionsHelper.buildListFrom("nana(tsu)", "nana-", "[nano-]"), "\u4e03", "\u306a\u306a", 9, 72, 57),
    ACHT_8("\u516b", CollectionsHelper.buildListFrom("acht", "8"), CollectionsHelper.buildListFrom("HACHI"), CollectionsHelper.buildListFrom("yat(tsu)", "ya(tsu)", "ya-", "[yo-]"), "\u516b", "\u306f\u3061", 10, 72, 58),
    NEUN_9("\u4e5d", CollectionsHelper.buildListFrom("neun", "9"), CollectionsHelper.buildListFrom("KYUU", "KU"), CollectionsHelper.buildListFrom("kokono(tsu)", "kokono-"), "\u4e5d", "\u304d\u3085\u3046", 11, 72, 59),
    ZEHN_10("\u5341", CollectionsHelper.buildListFrom("zehn", "10"), CollectionsHelper.buildListFrom("JUU", "JI'"), CollectionsHelper.buildListFrom("tou", "to-"), "\u5341", "\u3058\u3085\u3046", 12, 72, 60),
    HUNDERT_100("\u767e", CollectionsHelper.buildListFrom("hundert", "100"), CollectionsHelper.buildListFrom("HYAKU"), CollectionsHelper.buildListFrom(new String[0]), "\u767e", "\u3072\u3085\u304f", 14, 72, 61),
    TAUSEND_1000("\u5343", CollectionsHelper.buildListFrom("tausend", "1000"), CollectionsHelper.buildListFrom("SEN"), CollectionsHelper.buildListFrom("chi-"), "\u5343", "\u305b\u3093", 15, 73, 62),
    GOLD("\u91d1", CollectionsHelper.buildListFrom("Gold", "Metall", "Geld"), CollectionsHelper.buildListFrom("KIN", "KON"), CollectionsHelper.buildListFrom("kane", "[kana]"), "\u91d1", "\u304d\u3093", 23, 74, 63),
    BODEN_ERDE_GRUND("\u571f", CollectionsHelper.buildListFrom("Boden", "Erde", "Grund"), CollectionsHelper.buildListFrom("DO", "TO"), CollectionsHelper.buildListFrom("tsuchi"), "\u571f", "\u3069", 24, 74, 64),
    OBEN_RAUF_UEBER("\u4e0a", CollectionsHelper.buildListFrom("oben", "rauf", "\u00fcber", "steigen", "erheben"), CollectionsHelper.buildListFrom("JOU", "[SHOU]"), CollectionsHelper.buildListFrom("ue", "kami", "[uwa-]", "a(geru)", "nobo(ru)", "nobo(seru)", "nobo(su)"), "\u4e0a", "\u3046\u3048", 32, 75, 65),
    UNTEN_RUNTER_UNTER("\u4e0b", CollectionsHelper.buildListFrom("unten", "runter", "unter", "hinuntergehen", "herabsteigen"), CollectionsHelper.buildListFrom("KA", "GE"), CollectionsHelper.buildListFrom("shita", "moto", "shimo", "sa(geru)", "o(riru)", "kuda(ru)", "kuda(saru)"), "\u4e0b", "\u3057\u305f", 31, 75, 66),
    LINKS("\u5de6", CollectionsHelper.buildListFrom("links"), CollectionsHelper.buildListFrom("SA"), CollectionsHelper.buildListFrom("hidari"), "\u5de6", "\u3072\u3060\u308a", 75, 81, 67),
    RECHTS("\u53f3", CollectionsHelper.buildListFrom("rechts"), CollectionsHelper.buildListFrom("U", "YUU"), CollectionsHelper.buildListFrom("migi"), "\u53f3", "\u307f\u304e", 76, 81, 68),
    KREIS_YEN_RUND("\u5186", CollectionsHelper.buildListFrom("Kreis", "Yen", "rund", "kreisrund"), CollectionsHelper.buildListFrom("EN"), CollectionsHelper.buildListFrom("maru(i)"), "\u5186", "\u3048\u3093", 13, 72, 69),
    AUGE("\u76ee", CollectionsHelper.buildListFrom("Auge"), CollectionsHelper.buildListFrom("MOKU", "[BOKU]"), CollectionsHelper.buildListFrom("me", "[ma]"), "\u76ee", "\u3081", 55, 78, 70),
    HAELFTE_HALB("\u534a", CollectionsHelper.buildListFrom("H\u00e4lfte", "Halb-", "halb", "halb nach", "mitten in", "Mitte"), CollectionsHelper.buildListFrom("HAN"), CollectionsHelper.buildListFrom("naka(ba)"), "\u534a", "\u306f\u3093", 88, 83, 71),
    OHR("\u8033", CollectionsHelper.buildListFrom("Ohr"), CollectionsHelper.buildListFrom("JI"), CollectionsHelper.buildListFrom("mimi"), "\u8033", "\u307f\u307f", 56, 78, 72),
    MUND("\u53e3", CollectionsHelper.buildListFrom("Mund", "m\u00fcndlich", "reden", "Job", "Anfang"), CollectionsHelper.buildListFrom("KOU", "KU"), CollectionsHelper.buildListFrom("kuchi"), "\u53e3", "\u304f\u3061", 54, 78, 73),
    HAND("\u624b", CollectionsHelper.buildListFrom("Hand"), CollectionsHelper.buildListFrom("SHU"), CollectionsHelper.buildListFrom("te", "[ta]"), "\u624b", "\u3066", 57, 79, 74),
    BEIN_FUSS("\u8db3", CollectionsHelper.buildListFrom("Bein", "Fu\u00df", "Pfote", "addieren", "Schritt"), CollectionsHelper.buildListFrom("SOKU"), CollectionsHelper.buildListFrom("ashi", "ta(ru)", "ta(iru)", "ta(su)"), "\u8db3", "\u3042\u3057", 58, 79, 75),
    KRAFT("\u529b", CollectionsHelper.buildListFrom("Kraft"), CollectionsHelper.buildListFrom("RYOKU", "RIKI"), CollectionsHelper.buildListFrom("chikara"), "\u529b", "\u3061\u304b\u3089", 100, 85, 76),
    STEHEN_AUFSTEHEN("\u7acb", CollectionsHelper.buildListFrom("stehen", "aufstehen", "aufstellen", "errichten"), CollectionsHelper.buildListFrom("RITSU", "[RYUU]"), CollectionsHelper.buildListFrom("ta(tsu)", "ta(teru)"), "\u7acb\u3064", "\u305f\u3064", 121, 88, 77),
    HIMMEL_LEER("\u7a7a", CollectionsHelper.buildListFrom("Himmel", "leer", "frei machen", "frei werden"), CollectionsHelper.buildListFrom("KUU"), CollectionsHelper.buildListFrom("sora", "a(keru)", "a(ku)", "kara"), "\u7a7a", "\u305d\u3089", 140, 90, 78),
    BERG("\u5c71", CollectionsHelper.buildListFrom("Berg"), CollectionsHelper.buildListFrom("SAN"), CollectionsHelper.buildListFrom("yama"), "\u5c71", "\u3084\u307e", 34, 75, 79),
    FLUSS("\u5ddd", CollectionsHelper.buildListFrom("Fluss", "Strom"), CollectionsHelper.buildListFrom("SEN"), CollectionsHelper.buildListFrom("kawa"), "\u5ddd", "\u304b\u308f", 33, 75, 80),
    WORT_SAGEN("\u8a00", CollectionsHelper.buildListFrom("Wort", "sagen"), CollectionsHelper.buildListFrom("GEN", "GON"), CollectionsHelper.buildListFrom("-koto", "i(u)"), "\u8a00\u3046", "\u3044\u3046", 66, 80, 81),
    LESEN("\u8aad", CollectionsHelper.buildListFrom("lesen"), CollectionsHelper.buildListFrom("DOKU", "TOKU", "[TOU]"), CollectionsHelper.buildListFrom("yo(mu)"), "\u8aad\u3080", "\u3088\u3080", 244, 105, 82),
    SCHREIBEN("\u66f8", CollectionsHelper.buildListFrom("schreiben"), CollectionsHelper.buildListFrom("SHO"), CollectionsHelper.buildListFrom("ka(ku)"), "\u66f8\u304f", "\u304b\u304f", 131, 89, 83),
    WAELCHEN_WALD_FORST("\u6797", CollectionsHelper.buildListFrom("W\u00e4ldchen", "Wald", "Forst"), CollectionsHelper.buildListFrom("RIN"), CollectionsHelper.buildListFrom("hayashi"), "\u6797", "\u306f\u3084\u3057", 127, 89, 84),
    WALD_FORST("\u68ee", CollectionsHelper.buildListFrom("Wald", "Forst"), CollectionsHelper.buildListFrom("SHIN"), CollectionsHelper.buildListFrom("mori"), "\u68ee", "\u3082\u308a", 128, 89, 85),
    STEIN("\u77f3", CollectionsHelper.buildListFrom("Stein"), CollectionsHelper.buildListFrom("SEKI", "[SHAKU]", "[KOKU]"), CollectionsHelper.buildListFrom("ishi"), "\u77f3", "\u3044\u3057", 78, 82, 86),
    HUND("\u72ac", CollectionsHelper.buildListFrom("Hund"), CollectionsHelper.buildListFrom("KEN"), CollectionsHelper.buildListFrom("inu"), "\u72ac", "\u3044\u306c", 280, 110, 87),
    INSEKT_WURM("\u866b", CollectionsHelper.buildListFrom("Insekt", "Wurm"), CollectionsHelper.buildListFrom("CHUU"), CollectionsHelper.buildListFrom("mushi"), "\u866b", "\u3080\u3057", 893, 198, 88),
    JAHR("\u5e74", CollectionsHelper.buildListFrom("Jahr"), CollectionsHelper.buildListFrom("NEN"), CollectionsHelper.buildListFrom("toshi"), "\u5e74", "\u306d\u3093", 45, 77, 89),
    DORF("\u6751", CollectionsHelper.buildListFrom("Dorf"), CollectionsHelper.buildListFrom("SON"), CollectionsHelper.buildListFrom("mura"), "\u6751", "\u3080\u3089", 191, 98, 90),
    REISFELD("\u7530", CollectionsHelper.buildListFrom("Reisfeld", "Feld"), CollectionsHelper.buildListFrom("DEN"), CollectionsHelper.buildListFrom("ta"), "\u7530", "\u305f", 35, 75, 91),
    ABEND_NACHT("\u5915", CollectionsHelper.buildListFrom("Abend", "Nacht"), CollectionsHelper.buildListFrom("SEKI"), CollectionsHelper.buildListFrom("yuu"), "\u5915\u3079", "\u3086\u3046\u3079", 81, 82, 92),
    ROT("\u8d64", CollectionsHelper.buildListFrom("rot", "rot werden", "err\u00f6ten"), CollectionsHelper.buildListFrom("SEKI", "[SHAKU]"), CollectionsHelper.buildListFrom("aka(i)", "aka", "aka(ramu)", "aka(rameru)"), "\u8d64", "\u3042\u304b", 207, 100, 93),
    BLAU_GRUEN_UNREIF("\u9752", CollectionsHelper.buildListFrom("blau", "gr\u00fcn", "unreif"), CollectionsHelper.buildListFrom("SEI", "[SHOU]"), CollectionsHelper.buildListFrom("ao(i)", "ao"), "\u9752", "\u3042\u304a", 208, 100, 94),
    HERAUSNEHMEN_HERAUSKOMMEN("\u51fa", CollectionsHelper.buildListFrom("herausnehmen", "abschicken", "hinausgehen", "herauskommen"), CollectionsHelper.buildListFrom("SHUTSU", "[SUI]"), CollectionsHelper.buildListFrom("da(su)", "de(ru)"), "\u51fa\u53e3", "\u3067\u3050\u3061", 53, 78, 95),
    HINEINGEHEN_EINLASSEN("\u5165", CollectionsHelper.buildListFrom("hineingehen", "eintreten", "hereinstecken", "einlassen"), CollectionsHelper.buildListFrom("NYUU"), CollectionsHelper.buildListFrom("hai(ru)", "i(ru)", "i(eru)"), "\u5165\u308a\u53e3", "\u3044\u308a\u3050\u3061", 52, 78, 96),
    FRUEH_SCHNELL("\u65e9", CollectionsHelper.buildListFrom("fr\u00fch", "schnell"), CollectionsHelper.buildListFrom("SOU", "[SA']"), CollectionsHelper.buildListFrom("haya(i)", "haya(maru)", "haya(meru)"), "\u65e9\u3044", "\u306f\u3084\u3044", 248, 106, 97),
    SATZ_TEXT_LITERATUR_BRIEF("\u6587", CollectionsHelper.buildListFrom("Satz", "Text", "Literatur", "Brief"), CollectionsHelper.buildListFrom("BUN", "MON"), CollectionsHelper.buildListFrom("fumi"), "\u6587\u5b66", "\u3076\u3093\u304c\u304f", 111, 86, 98),
    NORDEN("\u5317", CollectionsHelper.buildListFrom("Norden"), CollectionsHelper.buildListFrom("HOKU"), CollectionsHelper.buildListFrom("kita"), "\u5317", "\u304d\u305f", 73, 81, 99),
    OSTEN("\u6771", CollectionsHelper.buildListFrom("Osten"), CollectionsHelper.buildListFrom("TOU"), CollectionsHelper.buildListFrom("higashi"), "\u6771", "\u3072\u304c\u3057", 71, 81, 100),
    SUEDEN("\u5357", CollectionsHelper.buildListFrom("S\u00fcden"), CollectionsHelper.buildListFrom("NAN", "[NA]"), CollectionsHelper.buildListFrom("minami"), "\u5357", "\u307f\u306a\u307f", 74, 81, 101),
    WESTEN("\u897f", CollectionsHelper.buildListFrom("Westen", "Spanien"), CollectionsHelper.buildListFrom("SEI", "SAI"), CollectionsHelper.buildListFrom("nishi"), "\u897f", "\u306b\u3057", 72, 81, 102),
    NAME_RUF_REPUTATION("\u540d", CollectionsHelper.buildListFrom("Name", "Ruf", "Reputation"), CollectionsHelper.buildListFrom("MEI", "MYOU"), CollectionsHelper.buildListFrom("na"), "\u540d\u524d", "\u306a\u307e\u3048", 82, 82, 103),
    SCHRIFTZEICHEN_BUCHSTABE("\u5b57", CollectionsHelper.buildListFrom("Schriftzeichen", "Buchstabe", "Weiler", "Gemeindeteil"), CollectionsHelper.buildListFrom("JI"), CollectionsHelper.buildListFrom("aza"), "\u6587\u5b57", "\u3082\u3058", 110, 86, 104),
    SCHULE_KORREKTUR("\u6821", CollectionsHelper.buildListFrom("Schule", "Korrektur"), CollectionsHelper.buildListFrom("KOU"), CollectionsHelper.buildListFrom(new String[0]), "\u5b66\u6821", "\u304c\u3063\u3053\u3046", 115, 87, 105),
    RICHTIG_GERECHT("\u6b63", CollectionsHelper.buildListFrom("richtig", "gerecht", "berichtigen", "verbessern", "genau", "sicher"), CollectionsHelper.buildListFrom("SEI", "SHOU"), CollectionsHelper.buildListFrom("tada(shii)", "tada(su)", "masa(ni)"), "\u6b63\u3059", "\u305f\u3060\u3059", 275, 110, 106),
    KOENIG("\u738b", CollectionsHelper.buildListFrom("K\u00f6nig"), CollectionsHelper.buildListFrom("OU"), CollectionsHelper.buildListFrom(new String[0]), "\u738b\u69d8", "\u304a\u3046\u3055\u307e", 294, 112, 107),
    TON_LAUT("\u97f3", CollectionsHelper.buildListFrom("Ton", "Laut"), CollectionsHelper.buildListFrom("ON", "IN"), CollectionsHelper.buildListFrom("oto", "ne"), "\u97f3\u697d", "\u304a\u3093\u304c\u304f", 347, 120, 108),
    FADEN("\u7cf8", CollectionsHelper.buildListFrom("Faden"), CollectionsHelper.buildListFrom("SHI"), CollectionsHelper.buildListFrom("ito"), "\u7cf8", "\u3044\u3068", 242, 105, 109),
    MUSCHEL("\u8c9d", CollectionsHelper.buildListFrom("Muschel"), CollectionsHelper.buildListFrom(new String[0]), CollectionsHelper.buildListFrom("kai"), "\u8c9d", "\u304b\u3044", 240, 105, 110),
    KUGEL_BALL("\u7389", CollectionsHelper.buildListFrom("Edelstein", "Juwel", "Kugel", "Ball"), CollectionsHelper.buildListFrom("GYOKU"), CollectionsHelper.buildListFrom("tama"), "\u7389", "\u305f\u307e", 295, 113, 111),
    GRAS_KRAUT("\u8349", CollectionsHelper.buildListFrom("Gras", "Kraut", "Entwurf"), CollectionsHelper.buildListFrom("SOU"), CollectionsHelper.buildListFrom("kusa"), "\u8349", "\u304f\u3055", 249, 106, 112),
    BAMBUS("\u7af9", CollectionsHelper.buildListFrom("Bambus"), CollectionsHelper.buildListFrom("CHIKU"), CollectionsHelper.buildListFrom("take"), "\u7af9", "\u305f\u3051", 129, 89, 113),
    ZEHNTAUSEND("\u4e07", CollectionsHelper.buildListFrom("10000", "10.000", "zehntausend", "Myriaden", "viele", "alle"), CollectionsHelper.buildListFrom("MAN", "BAN"), CollectionsHelper.buildListFrom(new String[0]), "\u4e07", "\u307e\u3093", 16, 73, 114),
    ZIEHEN_BILLIGER_MACHEN("\u5f15", CollectionsHelper.buildListFrom("ziehen", "anziehen", "schlie\u00dfen", "billiger machen"), CollectionsHelper.buildListFrom("IN"), CollectionsHelper.buildListFrom("hi(ku)"), "\u5f15\u304f", "\u3072\u304f", 216, 101, 115),
    WOLKE("\u96f2", CollectionsHelper.buildListFrom("Wolke"), CollectionsHelper.buildListFrom("UN"), CollectionsHelper.buildListFrom("kumo"), "\u96f2", "\u304f\u3082", 646, 163, 116),
    WEIT_FERN_ENTFERNT("\u9060", CollectionsHelper.buildListFrom("weit", "fern", "entfernt"), CollectionsHelper.buildListFrom("EN", "[ON]"), CollectionsHelper.buildListFrom("too(i)"), "\u9060\u3044", "\u3068\u304a\u3044", 453, 135, 117),
    LEHRFACH("\u79d1", CollectionsHelper.buildListFrom("Lehrfach", "Abteilung", "Fakult\u00e4t", "Schulfach"), CollectionsHelper.buildListFrom("KA"), CollectionsHelper.buildListFrom(new String[0]), "\u79d1\u5b66", "\u304b\u304c\u304f", 320, 116, 118),
    SOMMER("\u590f", CollectionsHelper.buildListFrom("Sommer"), CollectionsHelper.buildListFrom("KA", "[GE]"), CollectionsHelper.buildListFrom("natsu"), "\u590f", "\u306a\u3064", 469, 137, 119),
    HAN_CHINA("\u6f22", CollectionsHelper.buildListFrom("Han", "China", "Mann", "Kerl"), CollectionsHelper.buildListFrom("KAN"), CollectionsHelper.buildListFrom(new String[0]), "\u6f22\u5b57", "\u304b\u3093\u3058", 565, 151, 120),
    HAUPTSTADT("\u4eac", CollectionsHelper.buildListFrom("Hauptstadt"), CollectionsHelper.buildListFrom("KYOU", "KEI"), CollectionsHelper.buildListFrom(new String[0]), "\u4eac\u90fd", "\u304d\u3087\u3046\u3068", 189, 97, 121),
    LICHT_HELL("\u660e", CollectionsHelper.buildListFrom("Licht", "hell", "Helligkeit", "hell werden"), CollectionsHelper.buildListFrom("MEI", "MYOU"), CollectionsHelper.buildListFrom("a(kari)", "aka(rui)", "aki(raka)", "a(keru)", "aka(rumu)", "aka(ramu)", "a(ku)", "a(kasu)", "a(kuru)"), "\u660e\u304b\u308a", "\u3042\u304b\u308a", 18, 73, 122),
    HAUS_HEIM("\u5bb6", CollectionsHelper.buildListFrom("Haus", "Heim"), CollectionsHelper.buildListFrom("KA", "KE"), CollectionsHelper.buildListFrom("ie", "ya"), "\u5bb6", "\u3044\u3048", 165, 94, 123),
    GEDICHT_LIED_SINGEN("\u6b4c", CollectionsHelper.buildListFrom("Gedicht", "Lied", "singen"), CollectionsHelper.buildListFrom("KA"), CollectionsHelper.buildListFrom("uta", "uta(u)"), "\u6b4c", "\u3046\u305f", 395, 127, 124),
    BILD_STRICH("\u753b", CollectionsHelper.buildListFrom("Bild", "Strich"), CollectionsHelper.buildListFrom("GA", "KAKU"), CollectionsHelper.buildListFrom(new String[0]), "\u6620\u753b", "\u3048\u3044\u304c", 343, 119, 125),
    MAL_WIEDERKEHR_WEITERGABE_DREHEN("\u56de", CollectionsHelper.buildListFrom("Mal", "Wiederkehr", "Weitergabe", "drehen"), CollectionsHelper.buildListFrom("KAI", "[E]"), CollectionsHelper.buildListFrom("mawa(su)", "mawa(ru)"), "\u4e00\u56de", "\u3044\u3063\u304b\u3044", 90, 83, 126),
    MEER_SEE("\u6d77", CollectionsHelper.buildListFrom("Meer", "See"), CollectionsHelper.buildListFrom("KAI"), CollectionsHelper.buildListFrom("umi"), "\u6d77", "\u3046\u307f", 117, 87, 127),
    JEDER_JEDES("\u6bce", CollectionsHelper.buildListFrom("jeder", "jeden", "jedes"), CollectionsHelper.buildListFrom("MAI"), CollectionsHelper.buildListFrom(new String[0]), "\u6bce\u65e5", "\u307e\u3044\u306b\u3061", 116, 87, 128),
    EINZELSTUECK("\u7b87", CollectionsHelper.buildListFrom("Einzelst\u00fcck", "St\u00fcck"), CollectionsHelper.buildListFrom("KA"), CollectionsHelper.buildListFrom(new String[0]), "\u7b87\u6240", "\u304b\u3057\u3087", 1570, 295, 129),
    EINZELSTUECK_KURZFORM("\u30f6", CollectionsHelper.buildListFrom("Einzelst\u00fcck", "St\u00fcck"), CollectionsHelper.buildListFrom("KA"), CollectionsHelper.buildListFrom(new String[0]), "\u4e00\u30f6\u6708", "\u3044\u3063\u304b\u3052\u3064", 1570, 295, 129),
    ICH_PRIVAT("\u79c1", CollectionsHelper.buildListFrom("ich", "privat"), CollectionsHelper.buildListFrom("SHI"), CollectionsHelper.buildListFrom("watakushi", "watashi"), "\u79c1", "\u308f\u305f\u3057", 125, 88, 130),
    KATZE("\u732b", CollectionsHelper.buildListFrom("Katze"), CollectionsHelper.buildListFrom("BYOU"), CollectionsHelper.buildListFrom("neko"), "\u732b", "\u306d\u3053", 1567, 294, 131),
    BAHNHOF("\u99c5", CollectionsHelper.buildListFrom("Bahnhof"), CollectionsHelper.buildListFrom("EKI"), CollectionsHelper.buildListFrom(new String[0]), "\u99c5", "\u3048\u304d", 284, 111, 132),
    OEFFENTLICH_OFFIZIELL("\u516c", CollectionsHelper.buildListFrom("\u00f6ffentlich", "offiziell"), CollectionsHelper.buildListFrom("KOU"), CollectionsHelper.buildListFrom("ooyake"), "\u516c\u5712", "\u3053\u3046\u3048\u3093", 126, 88, 133),
    GARTEN_PARK("\u5712", CollectionsHelper.buildListFrom("Garten", "Park"), CollectionsHelper.buildListFrom("EN"), CollectionsHelper.buildListFrom("sono"), "\u516c\u5712", "\u3053\u3046\u3048\u3093", 454, 135, 134),
    AUSSENSEITE_DRAUSSEN("\u5916", CollectionsHelper.buildListFrom("Au\u00dfenseite", "drau\u00dfen", "ein anderer", "ein weiterer"), CollectionsHelper.buildListFrom("GAI", "GE"), CollectionsHelper.buildListFrom("soto", "hoka", "hazu(reru)", "hazu(su)"), "\u5916", "\u305d\u3068", 83, 82, 135),
    ZEICHNUNG_PLAN("\u56f3", CollectionsHelper.buildListFrom("Zeichnung", "Plan", "Skizze", "planen"), CollectionsHelper.buildListFrom("ZU", "TO"), CollectionsHelper.buildListFrom("haka(ru)"), "\u56f3\u66f8\u9928", "\u3068\u3057\u3087\u304b\u3093", 339, 119, 136),
    GEBAUEDE_HALLE("\u9928", CollectionsHelper.buildListFrom("gro\u00dfes Geb\u00e4ude", "Geb\u00e4ude", "Halle"), CollectionsHelper.buildListFrom("KAN"), CollectionsHelper.buildListFrom("yakata"), "\u56f3\u66f8\u9928", "\u3068\u3057\u3087\u304b\u3093", 327, 117, 137),
    MOEGEN_LIEBEN("\u597d", CollectionsHelper.buildListFrom("gern haben", "m\u00f6gen", "lieben"), CollectionsHelper.buildListFrom("KOU"), CollectionsHelper.buildListFrom("kono(mu)", "su(ku)"), "\u597d\u304d", "\u3059\u304d", 104, 85, 138),
    TEE("\u8336", CollectionsHelper.buildListFrom("Teestrauch", "Teebl\u00e4tter", "Tee"), CollectionsHelper.buildListFrom("CHA", "SA"), CollectionsHelper.buildListFrom(new String[0]), "\u304a\u8336", "\u304a\u3061\u3083", 251, 106, 139),
    VOR_VORNE_FRUEHER("\u524d", CollectionsHelper.buildListFrom("vorne", "vor", "fr\u00fcher"), CollectionsHelper.buildListFrom("ZEN"), CollectionsHelper.buildListFrom("mae"), "\u524d", "\u307e\u3048", 47, 77, 140),
    HINTER_DANACH_SPAETER("\u5f8c", CollectionsHelper.buildListFrom("danach", "sp\u00e4ter", "R\u00fcckseite", "hinten", "nach", "hinter", "zur\u00fcck"), CollectionsHelper.buildListFrom("GO", "KOU"), CollectionsHelper.buildListFrom("nochi", "ushi(ro)", "ato", "oku(reru)"), "\u5f8c\u308d", "\u3046\u3057\u308d", 48, 77, 141),
    SPRACHE_DIALEKT_UNTERSCHEIDUNG_BLATT("\u5f01", CollectionsHelper.buildListFrom("Sprache", "Dialekt", "Unterscheidung", "Blatt"), CollectionsHelper.buildListFrom("BEN"), CollectionsHelper.buildListFrom(new String[0]), "\u5f01\u5f53", "\u3079\u3093\u3068\u3046", 724, 174, 142),
    TREFFEN_ZUTREFFEN("\u5f53", CollectionsHelper.buildListFrom("treffen", "zutreffen"), CollectionsHelper.buildListFrom("TOU"), CollectionsHelper.buildListFrom("a(teru)", "a(taru)"), "\u5f01\u5f53", "\u3079\u3093\u3068\u3046", 77, 81, 143),
    GOTTHEIT_GOTT("\u795e", CollectionsHelper.buildListFrom("Gottheit", "Gott"), CollectionsHelper.buildListFrom("SHIN", "JIN"), CollectionsHelper.buildListFrom("kami", "[kan]", "[kou]"), "\u795e", "\u304b\u307f", 310, 115, 144),
    SHINTO_SCHREIN_GESELLSCHAFT_FIRMA("\u793e", CollectionsHelper.buildListFrom("Shinto-Schrein", "Gesellschaft", "Firma"), CollectionsHelper.buildListFrom("SHA"), CollectionsHelper.buildListFrom("yashiro"), "\u4f1a\u793e", "\u304b\u3044\u3057\u3083", 308, 114, 145),
    MACHEN_ANFERTIGEN("\u4f5c", CollectionsHelper.buildListFrom("machen", "anfertigen", "zubereiten", "herstellen"), CollectionsHelper.buildListFrom("SAKU", "SA"), CollectionsHelper.buildListFrom("tsuku(ru)"), "\u4f5c\u308b", "\u3079\u3093\u3068\u3046", 361, 122, 146),
    SCHLOSS_BURG("\u57ce", CollectionsHelper.buildListFrom("Schloss", "Burg"), CollectionsHelper.buildListFrom("JOU"), CollectionsHelper.buildListFrom("shiro"), "\u57ce", "\u3057\u308d", 733, 175, 147),
    TEMPEL("\u5bfa", CollectionsHelper.buildListFrom("Tempel"), CollectionsHelper.buildListFrom("JI"), CollectionsHelper.buildListFrom("tera"), "\u5bfa", "\u3066\u3089", 41, 76, 148),
    ANSTRENGUNG_HARTE_ARBEIT("\u52c9", CollectionsHelper.buildListFrom("Anstrengung", "harte Arbeit"), CollectionsHelper.buildListFrom("BEN"), CollectionsHelper.buildListFrom(new String[0]), "\u52c9\u5f37", "\u3079\u3093\u304d\u3087\u3046", 748, 177, 149),
    STAR_STAERKER_WERDEN("\u5f37", CollectionsHelper.buildListFrom("stark", "st\u00e4rker werden", "zwingen", "verst\u00e4rken"), CollectionsHelper.buildListFrom("KYOU", "GOU"), CollectionsHelper.buildListFrom("tsuyo(i)", "tsuyo(maru)", "tsuyo(meru)", "shi(iru)"), "\u52c9\u5f37", "\u3079\u3093\u304d\u3087\u3046", 217, 101, 150),
    LEHREN_UNTERRICHTEN("\u6559", CollectionsHelper.buildListFrom("lehren", "unterrichten", "lernen"), CollectionsHelper.buildListFrom("KYOU"), CollectionsHelper.buildListFrom("oshi(eru)", "oso(waru)"), "\u6559\u3048\u308b", "\u304a\u3057\u3048\u308b", 245, 105, 151),
    LAND_STAAT("\u56fd", CollectionsHelper.buildListFrom("Land", "Staat"), CollectionsHelper.buildListFrom("KOKU"), CollectionsHelper.buildListFrom("kuni"), "\u56fd", "\u304f\u306b", 40, 76, 152),
    EINSTEIGEN("\u4e57", CollectionsHelper.buildListFrom("einsteigen", "reiten", "fahren"), CollectionsHelper.buildListFrom("JOU"), CollectionsHelper.buildListFrom("no(ru)", "no(seru)"), "\u4e57\u308b", "\u306e\u308b", 532, 146, 153),
    STADT_MARKT("\u5e02", CollectionsHelper.buildListFrom("Stadt", "Markt"), CollectionsHelper.buildListFrom("SHI"), CollectionsHelper.buildListFrom("ichi"), "\u5e02", "\u3057", 181, 96, 154),
    PRAEFEKTUR("\u770c", CollectionsHelper.buildListFrom("Pr\u00e4fektur"), CollectionsHelper.buildListFrom("KEN"), CollectionsHelper.buildListFrom(new String[0]), "\u770c", "\u3051\u3093", 194, 98, 155),
    GESICHT_MASKE_FLAECHE("\u9762", CollectionsHelper.buildListFrom("Gesicht", "Maske", "Fl\u00e4che", "Oberfl\u00e4che", "Seite"), CollectionsHelper.buildListFrom("MEN"), CollectionsHelper.buildListFrom("omote", "omo", "tsura"), "\u9762\u767d\u3044", "\u304a\u3082\u3057\u308d\u3044", 274, 110, 156),
    KOPF_URSPRUNG_ANFANG("\u5143", CollectionsHelper.buildListFrom("Kopf", "Ursprung", "Anfang"), CollectionsHelper.buildListFrom("GEN", "GAN"), CollectionsHelper.buildListFrom("moto"), "\u5143\u6c17", "\u3052\u3093\u304d", 137, 90, 157),
    SEIN_EXISTIEREN("\u6709", CollectionsHelper.buildListFrom("sein", "existieren", "sich befinden", "haben"), CollectionsHelper.buildListFrom("YUU", "U"), CollectionsHelper.buildListFrom("a(ru)"), "\u6709\u540d", "\u3086\u3046\u3081\u3044", 265, 108, 158),
    SCHNEIDEN_ZU_ENDE_GEHEN("\u5207", CollectionsHelper.buildListFrom("schneiden", "gut schneiden", "zu Ende gehen"), CollectionsHelper.buildListFrom("SETSU", "[SAI]"), CollectionsHelper.buildListFrom("ki(ru)", "ki(eru)"), "\u5927\u5207", "\u305f\u3044\u305b\u3064", 39, 76, 159),
    UEBERSCHREITEN_UEBERGEBEN("\u6e21", CollectionsHelper.buildListFrom("\u00fcberschreiten", "\u00fcbergeben"), CollectionsHelper.buildListFrom("TO"), CollectionsHelper.buildListFrom("wata(ru)", "wata(su)"), "\u6e21\u3059", "\u308f\u305f\u3059", 379, 125, 160),
    NEHMEN("\u53d6", CollectionsHelper.buildListFrom("nehmen"), CollectionsHelper.buildListFrom("SHU"), CollectionsHelper.buildListFrom("to(ru)"), "\u53d6\u308b", "\u3068\u308b", 65, 80, 161),
    SETZEN_LEGEN_DALSSSEN("\u7f6e", CollectionsHelper.buildListFrom("setzen", "stellen", "legen", "dalassen", "lassen", "errichten"), CollectionsHelper.buildListFrom("CHI"), CollectionsHelper.buildListFrom("o(ku)"), "\u7f6e\u304f", "\u304a\u304f", 432, 132, 162),
    SCHNEE("\u96ea", CollectionsHelper.buildListFrom("Schnee"), CollectionsHelper.buildListFrom("SETSU"), CollectionsHelper.buildListFrom("yuki"), "\u96ea", "\u3086\u304d", 979, 210, 163),
    FALLEN("\u964d", CollectionsHelper.buildListFrom("fallen", "herabsteigen", "aussteigen", "regnen", "schneien"), CollectionsHelper.buildListFrom("KOU"), CollectionsHelper.buildListFrom("o(riru)", "o(rosu)", "fu(ru)"), "\u964d\u308b", "\u3075\u308b", 977, 210, 164),
    WIND("\u98a8", CollectionsHelper.buildListFrom("Wind", "Aussehen", "Mode", "Stil"), CollectionsHelper.buildListFrom("FUU", "[FU]"), CollectionsHelper.buildListFrom("kaze", "[kaza]"), "\u98a8", "\u304b\u305c", 29, 75, 165),
    BLASEN_WEHEN("\u5439", CollectionsHelper.buildListFrom("blasen", "wehen"), CollectionsHelper.buildListFrom("SUI"), CollectionsHelper.buildListFrom("fu(ku)"), "\u5439\u304f", "\u3075\u304f", 1326, 260, 166),
    HEISS__WETTER_("\u6691", CollectionsHelper.buildListFrom("hei\u00df", "hei\u00df (Wetter)"), CollectionsHelper.buildListFrom("SHO"), CollectionsHelper.buildListFrom("atsu(i)"), "\u6691", "\u3042\u3064\u3044", 648, 163, 167),
    HITZE_FIEBER_HEISS("\u71b1", CollectionsHelper.buildListFrom("Hitze", "Fieber", "hei\u00df", "hei\u00df (anfassbar)"), CollectionsHelper.buildListFrom("NETSU"), CollectionsHelper.buildListFrom("atsu(i)"), "\u71b1\u3044", "\u3042\u3064\u3044", 655, 164, 168),
    KAELTE_WINTER_KALT("\u5bd2", CollectionsHelper.buildListFrom("K\u00e4lte", "kalte Jahreszeit", "Winter", "kalt"), CollectionsHelper.buildListFrom("KAN"), CollectionsHelper.buildListFrom("samu(i)"), "\u5bd2\u3044", "\u3055\u3080\u3044", 464, 137, 169),
    KALT_KUEHLEN_KALT_WERDEN("\u51b7", CollectionsHelper.buildListFrom("kalt", "k\u00fchl", "k\u00fchlen", "kalt werden", "kaltes Wasser", "kalter Sake"), CollectionsHelper.buildListFrom("REI"), CollectionsHelper.buildListFrom("tsume(tai)", "hi(yasu)", "sa(masu)", "hi(eru)", "sa(meru)", "hi(ya)", "hi(yakasu)"), "\u51b7\u305f\u3044", "\u304a\u304f", 851, 192, 170),
    WARM_WARM_WERDEN_SICH_ERWAERMEN__WETTER__("\u6696", CollectionsHelper.buildListFrom("warm", "erw\u00e4rmen", "aufw\u00e4rmen", "warm werden", "sich erw\u00e4rmen", "angenehm warm", "(warmes Wetter)"), CollectionsHelper.buildListFrom("DAN"), CollectionsHelper.buildListFrom("atata(kai)", "atata(ka)", "atata(meru)", "atata(maru)"), "\u6696\u304b\u3044", "\u3042\u305f\u305f\u304b\u3044", 645, 163, 171),
    WARM_WARM_WERDEN_SICH_ERWAERMEN__ANFASSEN__("\u6e29", CollectionsHelper.buildListFrom("warm", "erw\u00e4rmen", "aufw\u00e4rmen", "warm werden", "sich erw\u00e4rmen", "angenehm warm", "(warm beim Anfassen)"), CollectionsHelper.buildListFrom("ON"), CollectionsHelper.buildListFrom("atata(kai)", "atata(ka)", "atata(meru)", "atata(maru)"), "\u6e29\u304b\u3044", "\u3042\u305f\u305f\u304b\u3044", 644, 162, 172),
    KUEHL_FRISCH_ERFRISCHEND("\u6dbc", CollectionsHelper.buildListFrom("k\u00fchl", "angenehm k\u00fchl", "frisch", "erfrischend", "sich drau\u00dfen erfrischen", "frische Luft sch\u00f6pfen"), CollectionsHelper.buildListFrom("RYOU"), CollectionsHelper.buildListFrom("suzu(shii)", "suzu(mu)"), "\u6dbc\u3057\u3044", "\u3059\u305a\u3057\u3044", 1267, 251, 173),
    SCHLECHT_SCHLIMM_BOESE("\u60aa", CollectionsHelper.buildListFrom("schlecht", "schlimm", "b\u00f6se"), CollectionsHelper.buildListFrom("AKU", "O"), CollectionsHelper.buildListFrom("waru(i)"), "\u60aa\u3044", "\u308f\u308b\u3044", 304, 114, 174),
    PFERD("\u99ac", CollectionsHelper.buildListFrom("Pferd"), CollectionsHelper.buildListFrom("BA"), CollectionsHelper.buildListFrom("uma", "[ma]"), "\u99ac", "\u3046\u307e", 283, 111, 175),
    VOGEL("\u9ce5", CollectionsHelper.buildListFrom("Vogel"), CollectionsHelper.buildListFrom("CHOU"), CollectionsHelper.buildListFrom("tori"), "\u9ce5", "\u3068\u308a", 285, 111, 176),
    RIND_KUH("\u725b", CollectionsHelper.buildListFrom("Rind", "Kuh"), CollectionsHelper.buildListFrom("GYUU"), CollectionsHelper.buildListFrom("ushi"), "\u725b", "\u3046\u3057", 281, 111, 177),
    SCHWEIN_HAUSSCHWEIN("\u8c5a", CollectionsHelper.buildListFrom("Schwein", "Hausschwein"), CollectionsHelper.buildListFrom("TON"), CollectionsHelper.buildListFrom("buta"), "\u8c5a", "\u3076\u305f", 810, 186, 178),
    BEWEGUNG_SICH_BEWEGEN("\u52d5", CollectionsHelper.buildListFrom("Bewegung", "sich bewegen", "bewegen"), CollectionsHelper.buildListFrom("DOU"), CollectionsHelper.buildListFrom("ugo(ku)", "ugo(kasu)"), "\u52d5\u7269", "\u3069\u3046\u3076\u3064", 231, 103, 179),
    DING_SACHE_GEGENSTAND("\u7269", CollectionsHelper.buildListFrom("Ding", "Sache", "Gegenstand"), CollectionsHelper.buildListFrom("BUTSU", "MOTSU"), CollectionsHelper.buildListFrom("mono"), "\u52d5\u7269", "\u3069\u3046\u3076\u3064", 79, 82, 180),
    MUSIK_BEQUEMLICHKEIT_ERFREULICH("\u697d", CollectionsHelper.buildListFrom("Musik", "Bequemlichkeit", "sich freuen", "genie\u00dfen", "froh", "erfreulich"), CollectionsHelper.buildListFrom("GAKU", "RAKU"), CollectionsHelper.buildListFrom("tano(shimu)", "tano(shii)"), "\u697d\u3057\u3044", "\u305f\u306e\u3057\u3044", 359, 122, 181),
    SCHWIERIG("\u96e3", CollectionsHelper.buildListFrom("schwierig", "kompliziert"), CollectionsHelper.buildListFrom("NAN"), CollectionsHelper.buildListFrom("muzuka(shii)", "kata(i)"), "\u96e3\u3057\u3044", "\u3080\u305a\u304b\u3057\u3044", 566, 151, 182),
    BEQUEMLICHKEIT_EXKREMENTE_POST("\u4fbf", CollectionsHelper.buildListFrom("Bequemlichkeit", "Exkremente", "Gelegenheit", "Post", "Nachricht", "Brief"), CollectionsHelper.buildListFrom("BEN", "BIN"), CollectionsHelper.buildListFrom("tayo(ri)"), "\u4fbf\u5229", "\u3079\u3093\u308a", 330, 118, 183),
    VORTEIL_ZINS_WIRKEN("\u5229", CollectionsHelper.buildListFrom("Vorteil", "Zins", "wirksam sein", "wirken"), CollectionsHelper.buildListFrom("RI"), CollectionsHelper.buildListFrom("ki(ku)"), "\u4fbf\u5229", "\u3079\u3093\u308a", 329, 117, 184),
    UN_NICHT("\u4e0d", CollectionsHelper.buildListFrom("un-", "nicht"), CollectionsHelper.buildListFrom("FU", "BU"), CollectionsHelper.buildListFrom(new String[0]), "\u4e0d\u4fbf", "\u3075\u3079\u3093", 94, 84, 185),
    WACHE_DIENST_NUMMER("\u756a", CollectionsHelper.buildListFrom("Wache", "Aufsicht", "Dienst", "Reihe", "Nummer"), CollectionsHelper.buildListFrom("BAN"), CollectionsHelper.buildListFrom(new String[0]), "\u756a\u53f7", "\u3070\u3093\u3054\u3046", 185, 97, 186),
    NUMMER_PSEUDONYM("\u53f7", CollectionsHelper.buildListFrom("Nummer", "Pseudonym", "verzweifeltes Schreien", "verzweifeltes lautes Schreien"), CollectionsHelper.buildListFrom("GOU"), CollectionsHelper.buildListFrom(new String[0]), "\u756a\u53f7", "\u3070\u3093\u3054\u3046", 266, 108, 187),
    BENUTZUNG_BOTE_BENUTZEN("\u4f7f", CollectionsHelper.buildListFrom("Benutzung", "Bote", "benutzen"), CollectionsHelper.buildListFrom("SHI"), CollectionsHelper.buildListFrom("tsuka(u)"), "\u4f7f\u3046", "\u3064\u304b\u3046", 331, 118, 188),
    SELBST("\u81ea", CollectionsHelper.buildListFrom("selbst"), CollectionsHelper.buildListFrom("JI", "SHI"), CollectionsHelper.buildListFrom("mizuka(ra)"), "\u81ea\u8ee2\u8eca", "\u3058\u3066\u3093\u3057\u3083", 62, 79, 189),
    ROLLEN_FALLEN_WAELZEN("\u8ee2", CollectionsHelper.buildListFrom("rollen", "fallen", "w\u00e4lzen", "hinfallen", "umwerfen"), CollectionsHelper.buildListFrom("TEN"), CollectionsHelper.buildListFrom("koro(bu)", "koro(garu)", "koro(geru)", "koro(gasu)"), "\u81ea\u8ee2\u8eca", "\u3058\u3066\u3093\u3057\u3083", 439, 133, 190),
    SCHWERT_MESSER("\u5200", CollectionsHelper.buildListFrom("Schwert", "Messer"), CollectionsHelper.buildListFrom("TOU"), CollectionsHelper.buildListFrom("katana"), "\u5200", "\u304b\u305f\u306a", 37, 76, 191),
    VATER("\u7236", CollectionsHelper.buildListFrom("Vater"), CollectionsHelper.buildListFrom("FU"), CollectionsHelper.buildListFrom("chichi"), "\u7236", "\u3061\u3061", 113, 87, 192),
    MUTTER("\u6bcd", CollectionsHelper.buildListFrom("Mutter"), CollectionsHelper.buildListFrom("BO"), CollectionsHelper.buildListFrom("haha"), "\u6bcd", "\u306f\u306f", 112, 86, 193),
    GROSS_STARK_STATUR_GROESSE("\u4e08", CollectionsHelper.buildListFrom("gro\u00df", "stark", "Statur", "Gr\u00f6\u00dfe"), CollectionsHelper.buildListFrom("JOU"), CollectionsHelper.buildListFrom("take"), "\u5927\u4e08\u592b", "\u3060\u3044\u3058\u3087\u3046\u3076", 1408, 272, 194),
    EHEMANN_MANN("\u592b", CollectionsHelper.buildListFrom("Ehemann", "Mann"), CollectionsHelper.buildListFrom("FU", "[FUU]"), CollectionsHelper.buildListFrom("otto"), "\u5927\u4e08\u592b", "\u3060\u3044\u3058\u3087\u3046\u3076", 315, 115, 195),
    BITTEN_BETEN_WUENSCHEN("\u9858", CollectionsHelper.buildListFrom("bitten", "beten", "w\u00fcnschen"), CollectionsHelper.buildListFrom("GAN"), CollectionsHelper.buildListFrom("nega(u)"), "\u304a\u9858\u3044\u3057\u307e\u3059", "\u304a\u9858\u3044\u3057\u307e\u3059", 590, 155, 196),
    ORT_STELLE("\u6240", CollectionsHelper.buildListFrom("Ort", "Stelle"), CollectionsHelper.buildListFrom("SHO"), CollectionsHelper.buildListFrom("tokoro"), "\u6240", "\u3068\u3053\u308d", 153, 92, 197),
    STRASSE_WEG_PFAD("\u9053", CollectionsHelper.buildListFrom("Stra\u00dfe", "Weg", "Pfad", "Dao/Tao"), CollectionsHelper.buildListFrom("DOU", "[TOU]"), CollectionsHelper.buildListFrom("michi"), "\u9053", "\u307f\u3061", 149, 92, 198),
    ZURUECKKEHREN("\u5e30", CollectionsHelper.buildListFrom("zur\u00fcckkehren", "nach Hause schicken"), CollectionsHelper.buildListFrom("KI"), CollectionsHelper.buildListFrom("kae(ru)", "kae(su)"), "\u5e30\u308b", "\u304b\u3048\u308b", 317, 116, 199),
    BAUEN_ERRICHTEN("\u5efa", CollectionsHelper.buildListFrom("bauen", "errichten", "errichtet werden"), CollectionsHelper.buildListFrom("KEN", "[KON]"), CollectionsHelper.buildListFrom("ta(teru)", "ta(tsu)"), "\u5efa\u7269", "\u305f\u3066\u3082\u306e", 913, 201, 200),
    STOCKWERK_ETAGE_EBENE("\u968e", CollectionsHelper.buildListFrom("Stockwerk", "Etage", "Ebene"), CollectionsHelper.buildListFrom("KAI"), CollectionsHelper.buildListFrom(new String[0]), "\u968e", "\u304b\u3044", 597, 156, 201),
    ERDE_LAND("\u5730", CollectionsHelper.buildListFrom("Erde", "Land"), CollectionsHelper.buildListFrom("CHI", "JI"), CollectionsHelper.buildListFrom(new String[0]), "\u5730\u4e0b", "\u3061\u304b", 118, 87, 202),
    BLATT_LAUB("\u8449", CollectionsHelper.buildListFrom("Blatt", "Laub"), CollectionsHelper.buildListFrom("YOU"), CollectionsHelper.buildListFrom("ha"), "\u8a00\u8449", "\u3053\u3068\u3070", 253, 107, 203),
    GLAENZEND_BEGABT_ENGLAND("\u82f1", CollectionsHelper.buildListFrom("gl\u00e4nzend", "brillant", "begabt", "England"), CollectionsHelper.buildListFrom("EI"), CollectionsHelper.buildListFrom(new String[0]), "\u82f1\u8a9e", "\u3048\u3044\u3054", 354, 121, 204),
    QUALITAET_NATUR_PFAD("\u8cea", CollectionsHelper.buildListFrom("Qualit\u00e4t", "Natur", "Pfad"), CollectionsHelper.buildListFrom("SHITSU", "SHICHI", "[CHI]"), CollectionsHelper.buildListFrom(new String[0]), "\u8cea\u554f", "\u3057\u3064\u3082\u3093", 176, 96, 205),
    FRAGE_PROBLEM_FRAGEN("\u554f", CollectionsHelper.buildListFrom("Frage", "Problem", "fragen", "sich k\u00fcmmern (um)"), CollectionsHelper.buildListFrom("MON"), CollectionsHelper.buildListFrom("to(i)", "[tou]", "to(u)"), "\u8cea\u554f", "\u3057\u3064\u3082\u3093", 162, 94, 206),
    ANTWORT_ANTWORTEN("\u7b54", CollectionsHelper.buildListFrom("Antwort", "antworten"), CollectionsHelper.buildListFrom("TOU"), CollectionsHelper.buildListFrom("kota(e)", "kota(eru)"), "\u7b54\u3048", "\u3053\u305f\u3048", 160, 93, 207),
    ER_JENER("\u5f7c", CollectionsHelper.buildListFrom("er", "jener"), CollectionsHelper.buildListFrom("HI"), CollectionsHelper.buildListFrom("kare", "[kano]"), "\u5f7c", "\u304b\u308c", 1010, 215, 208),
    FARBE_EROTIK("\u8272", CollectionsHelper.buildListFrom("Farbe", "Erotik"), CollectionsHelper.buildListFrom("SHOKU", "SHIKI"), CollectionsHelper.buildListFrom("iro"), "\u8272", "\u3044\u308d", 204, 100, 209),
    KANJI_WIEDERHOLUNGSZEICHEN("\u3005", CollectionsHelper.buildListFrom("Wiederholungszeichen", "Kanji Wiederholungszeichen"), CollectionsHelper.buildListFrom(new String[0]), CollectionsHelper.buildListFrom(new String[0]), "\u3005", "\u3005", 0, 0, 0),
    FRUEHLING("\u6625", CollectionsHelper.buildListFrom("Fr\u00fchling", "Fr\u00fchjahr"), CollectionsHelper.buildListFrom("SHUN"), CollectionsHelper.buildListFrom("haru"), "\u6625", "\u306f\u308b", 468, 137, 210),
    HERBST("\u79cb", CollectionsHelper.buildListFrom("Herbst"), CollectionsHelper.buildListFrom("SHUU"), CollectionsHelper.buildListFrom("aki"), "\u79cb", "\u3042\u304d", 470, 138, 211),
    WINTER("\u51ac", CollectionsHelper.buildListFrom("Winter"), CollectionsHelper.buildListFrom("TOU"), CollectionsHelper.buildListFrom("fuyu"), "\u51ac", "\u3075\u3086", 467, 137, 212),
    BILD("\u7d75", CollectionsHelper.buildListFrom("Bild"), CollectionsHelper.buildListFrom("KAI", "E"), CollectionsHelper.buildListFrom(new String[0]), "\u7d75", "\u3048", 345, 120, 213),
    ZWISCHENRAUM("\u9593", CollectionsHelper.buildListFrom("Zwischenraum", "Zeitraum", "Raum", "Zimmer"), CollectionsHelper.buildListFrom("KAN", "KEN"), CollectionsHelper.buildListFrom("aida"), "\u9593", "\u3042\u3044\u3060", 43, 77, 214),
    GESICHT("\u9854", CollectionsHelper.buildListFrom("Gesicht"), CollectionsHelper.buildListFrom("GAN"), CollectionsHelper.buildListFrom("kao"), "\u9854", "\u304b\u304a", 277, 110, 215),
    DAMPF("\u6c7d", CollectionsHelper.buildListFrom("Dampf"), CollectionsHelper.buildListFrom("KI"), CollectionsHelper.buildListFrom(new String[0]), "\u6c7d\u8eca", "\u304d\u3057\u3083", 135, 90, 216),
    VERGANGEN_GESTERN("\u6628", CollectionsHelper.buildListFrom("vergangen", "letzt", "gestern"), CollectionsHelper.buildListFrom("SAKU"), CollectionsHelper.buildListFrom(new String[0]), "\u6628\u65e5", "\u304d\u306e\u3046", 362, 122, 217),
    SCHMERZ_LEID_BITTER("\u82e6", CollectionsHelper.buildListFrom("Schmerz", "Leid", "leiden", "qu\u00e4len", "schmerzhaft", "bitter"), CollectionsHelper.buildListFrom("KU"), CollectionsHelper.buildListFrom("kuru(shimu)", "kuru(shimeru)", "kuru(shii)", "niga(i)", "niga(ru)"), "\u82e6", "\u306b\u304c\u3044", 554, 150, 218),
    KLAR_AUFKLAREN_AUFKLAEREN("\u6674", CollectionsHelper.buildListFrom("klar", "aufklaren", "kl\u00e4ren", "aufkl\u00e4ren"), CollectionsHelper.buildListFrom("SEI"), CollectionsHelper.buildListFrom("ha(re)", "ha(reru)", "ha(rasu)"), "\u6674\u308c", "\u306f\u308c", 673, 167, 219),
    WEIT_AUSDEHNEN("\u5e83", CollectionsHelper.buildListFrom("breit", "weit", "ausdehnen", "erweitern", "sich ausdehnen", "verbreiten", "sich verbreiten"), CollectionsHelper.buildListFrom("KOU"), CollectionsHelper.buildListFrom("hiro(i)", "hiro(geru)", "hiro(garu)", "hiro(meru)", "hiro(maru)"), "\u5e83\u3044", "\u3072\u308d\u3044", 707, 171, 220),
    SICH_BEW\u00d6LKEN("\u66c7", CollectionsHelper.buildListFrom("sich bew\u00f6lken", "sich tr\u00fcben"), CollectionsHelper.buildListFrom("DON"), CollectionsHelper.buildListFrom("kumo(ru)"), "\u66c7\u308b", "\u304f\u3082\u308b", 647, 163, 221),
    STERN("\u661f", CollectionsHelper.buildListFrom("Stern"), CollectionsHelper.buildListFrom("SEI", "[SHOU]"), CollectionsHelper.buildListFrom("hoshi"), "\u661f", "\u307b\u3057", 743, 177, 222),
    VERKEHR_PASSIEREN("\u901a", CollectionsHelper.buildListFrom("Verkehr", "passieren", "verkehren", "hindurchgehen", "durchlassen", "Stra\u00dfe"), CollectionsHelper.buildListFrom("TSUU", "[TSU]"), CollectionsHelper.buildListFrom("too(ru)", "too(su)", "kayo(u)"), "\u901a\u308a", "\u3068\u304a\u308a", 150, 92, 223),
    SCHWARZ("\u9ed2", CollectionsHelper.buildListFrom("schwarz"), CollectionsHelper.buildListFrom("KOKU"), CollectionsHelper.buildListFrom("kuro(i)", "kuro"), "\u9ed2", "\u304f\u308d", 206, 100, 224),
    SUCHEN("\u63a2", CollectionsHelper.buildListFrom("suchen", "tasten"), CollectionsHelper.buildListFrom("TAN"), CollectionsHelper.buildListFrom("sagu(ru)", "saga(su)"), "\u63a2\u3059", "\u3055\u304c\u3059", 544, 148, 225),
    DENKEN_GLAUBEN("\u601d", CollectionsHelper.buildListFrom("denken", "glauben"), CollectionsHelper.buildListFrom("SHI"), CollectionsHelper.buildListFrom("omo(u)"), "\u601d\u3046", "\u304a\u3082\u3046", 99, 85, 226),
    ZURUECKKEHREN_AUFBEGEHREN("\u623b", CollectionsHelper.buildListFrom("zur\u00fcckkehren", "aufbegehren", "versto\u00dfen", "zur\u00fcckgeben"), CollectionsHelper.buildListFrom("REI"), CollectionsHelper.buildListFrom("modo(ru)", "modo(su)"), "\u623b\u308b", "\u3082\u3069\u308b", 1304, 257, 227),
    BEGINN_SCHNUR("\u7dd2", CollectionsHelper.buildListFrom("Beginn", "Schnur", "Strick", "Riemen"), CollectionsHelper.buildListFrom("SHO", "[CHO]"), CollectionsHelper.buildListFrom("o"), "\u4e00\u7dd2\u306b", "\u3044\u3063\u3057\u3087\u306b", 881, 196, 228),
    PLATZ_STELLE_ORT("\u5834", CollectionsHelper.buildListFrom("Platz", "Stelle", "Ort"), CollectionsHelper.buildListFrom("JOU"), CollectionsHelper.buildListFrom("ba"), "\u5834\u6240", "\u3070\u3057\u3087", 154, 92, 229),
    WARTEN_ERWARTEN("\u5f85", CollectionsHelper.buildListFrom("warten", "erwarten"), CollectionsHelper.buildListFrom("TAI"), CollectionsHelper.buildListFrom("ma(tsu)"), "\u5f85\u3063\u3066", "\u307e\u3063\u3066", 459, 136, 230),
    WIEDERGABE_FOTOS_MACHEN("\u64ae", CollectionsHelper.buildListFrom("Wiedergabe", "Wiedergabe (Foto/Inhalt)", "(Fotos) machen"), CollectionsHelper.buildListFrom("SATSU"), CollectionsHelper.buildListFrom("to(ru)"), "\u64ae\u308a\u307e\u3059", "\u3068\u308a\u307e\u3059", 1621, 302, 231),
    AUFSCHREIBEN_NOTIEREN("\u8a18", CollectionsHelper.buildListFrom("aufschreiben", "notieren"), CollectionsHelper.buildListFrom("KI"), CollectionsHelper.buildListFrom("shiru(su)"), "\u65e5\u8a18", "\u306b\u3063\u304d", 372, 124, 232),
    HAUS_DACH_GESCHAEFT_HAENDLER("\u5c4b", CollectionsHelper.buildListFrom("Haus", "Dach", "Gesch\u00e4ft", "H\u00e4ndler"), CollectionsHelper.buildListFrom("OKU"), CollectionsHelper.buildListFrom("ya"), "\u9b5a\u5c4b", "\u3055\u304b\u306a\u3084", 167, 94, 233),
    HANG_STEIGUNG_DAMM("\u962a", CollectionsHelper.buildListFrom("Hang", "Steigung", "Damm"), CollectionsHelper.buildListFrom("HAN"), CollectionsHelper.buildListFrom("(saka)"), "\u5927\u962a", "\u304a\u304a\u3055\u304b", 450, 135, 234),
    WINKEL_ECKE_HORN("\u89d2", CollectionsHelper.buildListFrom("Winkel", "Viereck", "Ecke", "Horn"), CollectionsHelper.buildListFrom("KAKU"), CollectionsHelper.buildListFrom("kado", "tsuno"), "\u89d2", "\u304b\u3069", 481, 139, 235),
    NAHE("\u8fd1", CollectionsHelper.buildListFrom("nahe", "N\u00e4he"), CollectionsHelper.buildListFrom("KIN"), CollectionsHelper.buildListFrom("chika(i)"), "\u8fd1\u304f", "\u3061\u304b\u304f", 452, 135, 236),
    FORM_GESTALT("\u5f62", CollectionsHelper.buildListFrom("Form", "Gestalt"), CollectionsHelper.buildListFrom("KEI", "GYOU"), CollectionsHelper.buildListFrom("katachi", "kata"), "\u5f62", "\u304b\u305f\u3061", 399, 127, 237),
    MESSEN_PLAN_SUMME("\u8a08", CollectionsHelper.buildListFrom("Messen", "Plan", "Summe", "messen", "rechnen", "verfahren", "vorgehen", "behandeln"), CollectionsHelper.buildListFrom("KEI"), CollectionsHelper.buildListFrom("haka(ru)", "haka(rau)"), "\u8a08\u7b97\u6a5f", "\u3051\u3044\u3055\u3093\u304d", 340, 119, 238),
    HAUPTSTADT_METROPOLIS("\u90fd", CollectionsHelper.buildListFrom("Hauptstadt", "Metropole", "Metropolis"), CollectionsHelper.buildListFrom("TO", "TSU"), CollectionsHelper.buildListFrom("miyako"), "\u4eac\u90fd", "\u304d\u3087\u3046\u3068", 188, 97, 239),
    WOCHENTAG_TAG("\u66dc", CollectionsHelper.buildListFrom("Wochentag", "Tag"), CollectionsHelper.buildListFrom("YOU"), CollectionsHelper.buildListFrom(new String[0]), "\u6708\u66dc\u65e5", "\u3052\u3064\u3088\u3046\u3073", 19, 73, 240),
    URSPRUENGLICH_ORIGINAL_FELD("\u539f", CollectionsHelper.buildListFrom("urspr\u00fcnglich", "original", "Grund-", "Feld", "freies Feld", "Ebene"), CollectionsHelper.buildListFrom("GEN"), CollectionsHelper.buildListFrom("hara"), "\u539f\u5bbf", "\u306f\u3089\u3058\u304f", 136, 90, 241),
    TUER("\u6238", CollectionsHelper.buildListFrom("T\u00fcr"), CollectionsHelper.buildListFrom("KO"), CollectionsHelper.buildListFrom("to"), "\u6238\u53e3", "\u3068\u3050\u3061", 152, 92, 242),
    JAHR_JAHRE_ALT("\u6b73", CollectionsHelper.buildListFrom("Jahr", "Jahre alt"), CollectionsHelper.buildListFrom("SAI", "[SEI]"), CollectionsHelper.buildListFrom(new String[0]), "\u4e8c\u5341\u6b73", "\u306f\u305f\u3061", 487, 140, 243),
    TALENT_BEGABUNG_JAHRE_ALT("\u624d", CollectionsHelper.buildListFrom("Talent", "Begabung", "Jahre alt"), CollectionsHelper.buildListFrom("SAI"), CollectionsHelper.buildListFrom(new String[0]), "\u5929\u624d", "\u3066\u3093\u3055\u3044", 560, 150, 244),
    HALTEN_ANHALTEN_STOPPEN("\u6b62", CollectionsHelper.buildListFrom("halten", "anhalten", "stoppen"), CollectionsHelper.buildListFrom("SHI"), CollectionsHelper.buildListFrom("to(maru)", "to(meru)"), "\u6b62\u307e\u308b", "\u3068\u307e\u308b", 485, 140, 245),
    FELD_FLUR("\u91ce", CollectionsHelper.buildListFrom("Feld", "Flur"), CollectionsHelper.buildListFrom("YA"), CollectionsHelper.buildListFrom("no"), "\u91ce\u539f", "\u306e\u306f\u3089", 236, 104, 246),
    SACHE_ANGELEGENHEIT("\u4e8b", CollectionsHelper.buildListFrom("Sache", "Angelegenheit"), CollectionsHelper.buildListFrom("JI", "[ZU]"), CollectionsHelper.buildListFrom("koto"), "\u98df\u4e8b", "\u3057\u3087\u304f\u3058", 80, 82, 247),
    DIENEN_BEDIENEN("\u4ed5", CollectionsHelper.buildListFrom("dienen", "bedienen"), CollectionsHelper.buildListFrom("SHI", "[JI]"), CollectionsHelper.buildListFrom("tsuka(eru)"), "\u4ed5\u4e8b", "\u3057\u3054\u3068", 333, 118, 248),
    MORGEN_DYNASTIE("\u671d", CollectionsHelper.buildListFrom("Morgen", "Dynastie"), CollectionsHelper.buildListFrom("CHOU"), CollectionsHelper.buildListFrom("asa"), "\u671d", "\u3042\u3055", 477, 139, 249),
    TAG_MITTAG("\u663c", CollectionsHelper.buildListFrom("Tag", "Mittag"), CollectionsHelper.buildListFrom("CHUU"), CollectionsHelper.buildListFrom("hiru"), "\u663c", "\u3072\u308b", 478, 139, 250),
    NACHT("\u591c", CollectionsHelper.buildListFrom("Nacht"), CollectionsHelper.buildListFrom("YA"), CollectionsHelper.buildListFrom("yoru", "yo"), "\u591c", "\u3088\u308b", 479, 139, 251),
    INSEL("\u5cf6", CollectionsHelper.buildListFrom("Insel"), CollectionsHelper.buildListFrom("TOU"), CollectionsHelper.buildListFrom("shima"), "\u5cf6", "\u3057\u307e", 286, 111, 252),
    HAUESERBLOCK("\u4e01", CollectionsHelper.buildListFrom("H\u00e4userblock", "gerade Zahl", "Blatt", "Blatt Papier", "Z\u00e4hlwort f\u00fcr Essensportionen", "Nummer 4", "D", "junger Mann"), CollectionsHelper.buildListFrom("CHOU", "TEI"), CollectionsHelper.buildListFrom(new String[0]), "\u4e01", "\u3061\u3087\u3046", 184, 97, 253),
    BAU_BAUEN_ARBEITEN("\u5de5", CollectionsHelper.buildListFrom("Bau", "bauen", "arbeiten"), CollectionsHelper.buildListFrom("KOU", "KU"), CollectionsHelper.buildListFrom(new String[0]), "\u5de5\u4f5c", "\u3053\u3046\u3055\u304f", 139, 90, 254),
    KREUZUNG_VERKEHR_MISCHEN("\u4ea4", CollectionsHelper.buildListFrom("Kreuzung", "Verkehr", "vermischt sein", "gemischt sein", "mischen", "verkehren", "austauschen"), CollectionsHelper.buildListFrom("KOU"), CollectionsHelper.buildListFrom("ma(jiru)", "ma(zaru)", "maji(eru)", "ma(zeru)", "maji(waru)", "ka(u)", "ka(wasu)"), "\u4ea4\u5dee\u70b9", "\u3053\u3046\u3055\u3066\u3093", 114, 87, 255),
    LICHT_SCHEINEN("\u5149", CollectionsHelper.buildListFrom("Licht", "scheinen"), CollectionsHelper.buildListFrom("KOU"), CollectionsHelper.buildListFrom("hikari", "hika(ru)"), "\u89b3\u5149", "\u304b\u3093\u3053\u3046", 138, 90, 256),
    DENKEN_MEINEN_GLAUBEN("\u8003", CollectionsHelper.buildListFrom("denken", "meinen", "glauben"), CollectionsHelper.buildListFrom("KOU"), CollectionsHelper.buildListFrom("kanga(eru)"), "\u8003\u3048\u308b", "\u304b\u3093\u304c\u3048\u308b", 550, 149, 257);

    private final String character;
    private final List<String> germanMeanings;
    private final List<String> onLesungen;
    private final List<String> kunLesungen;
    private final String normalKanjiHiraganaWord;
    private final String normalHiraganaWord;
    private final int numberInKanjiAndKanaBook;
    private final int pageNumberInKanjiAndKanaBook;
    private final int numberInMyHandwrittenKanjiNotebooks;

    private Kanji(String string2, List<String> list, List<String> list2, List<String> list3, String string3, String string4, int n2, int n3, int n4) {
        this.character = string2;
        this.germanMeanings = list;
        this.onLesungen = list2;
        this.kunLesungen = list3;
        this.normalKanjiHiraganaWord = string3;
        this.normalHiraganaWord = string4;
        this.numberInKanjiAndKanaBook = n2;
        this.pageNumberInKanjiAndKanaBook = n3;
        this.numberInMyHandwrittenKanjiNotebooks = n4;
    }

    public String getCharacter() {
        return this.character;
    }

    public List<String> getGermanMeanings() {
        return CollectionsHelper.copyList(this.germanMeanings);
    }

    public List<String> getOnLesungen() {
        return CollectionsHelper.copyList(this.onLesungen);
    }

    public List<String> getKunLesungen() {
        return CollectionsHelper.copyList(this.kunLesungen);
    }

    public String getNormalKanjiHiraganaWord() {
        return this.normalKanjiHiraganaWord;
    }

    public String getNormalHiraganaWord() {
        return this.normalHiraganaWord;
    }

    public int getNumberInKanjiAndKanaBook() {
        return this.numberInKanjiAndKanaBook;
    }

    public int getPageNumberInKanjiAndKanaBook() {
        return this.pageNumberInKanjiAndKanaBook;
    }

    public int getNumberInMyHandwrittenKanjiNotebooks() {
        return this.numberInMyHandwrittenKanjiNotebooks;
    }

    public static List<Kanji> getAllKanjiAsList() {
        return CollectionsHelper.arrayToList(Kanji.values());
    }

    public static List<String> getAllKanjiAsStringList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Kanji kanji : Kanji.values()) {
            arrayList.add(kanji.getCharacter());
        }
        return arrayList;
    }

    public static boolean containsKanji(String string) {
        return Text.contains(string, Kanji.getAllKanjiAsStringList());
    }

    public static boolean containsOnlyKanji(String string) {
        if (string.isEmpty()) {
            return false;
        }
        List<String> list = Kanji.getAllKanjiAsStringList();
        for (String string2 : Text.textToCharactersList(string)) {
            if (list.contains(string2)) continue;
            return false;
        }
        return true;
    }

    public static int firstIndexOfKanji(String string) {
        List<String> list = Kanji.getAllKanjiAsStringList();
        List<String> list2 = Text.textToCharactersList(string);
        for (int i = 0; i < list2.size(); ++i) {
            String string2 = list2.get(i);
            if (!list.contains(string2)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfKanji(String string) {
        List<String> list = Kanji.getAllKanjiAsStringList();
        List<String> list2 = Text.textToCharactersList(string);
        for (int i = list2.size() - 1; i >= 0; --i) {
            String string2 = list2.get(i);
            if (!list.contains(string2)) continue;
            return i;
        }
        return -1;
    }

    public static int getNumberOfKnownKanji() {
        return Kanji.values().length;
    }

    public static Kanji getByCharacter(String string) {
        for (Kanji kanji : Kanji.values()) {
            if (!string.equals(kanji.getCharacter())) continue;
            return kanji;
        }
        throw new RuntimeException("Kein Kanji zum Zeichen '" + string + "' gefunden.");
    }

    public static List<Kanji> getAllKanjiFromText(String string) {
        ArrayList<Kanji> arrayList = new ArrayList<Kanji>();
        for (String string2 : Text.textToCharactersList(string)) {
            for (Kanji kanji : Kanji.values()) {
                String string3 = kanji.getCharacter();
                if (!string2.equals(string3)) continue;
                arrayList.add(kanji);
            }
        }
        return arrayList;
    }
}

