/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.io;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.definitions.DefinitionLineParser;
import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.data.Vocable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OwnListReader {
    static final String OWN_LIST_CATEGORY_KEY = "own-list-category";
    static final String OWN_LIST_SUB_CATEGORY_KEY = "own-list-sub-category";
    public static final String DEFAULT_OWN_LIST_CATEGORY = "Default";
    public static final String DEFAULT_OWN_LIST_SUB_CATEGORY = "Default";
    private final String name;
    private final Map<String, Vocable> keyToVocable;
    private String filename;
    private List<String> lines;
    private List<Vocable> vocables;
    private String ownListCategory;
    private String ownListSubCategory;
    private OwnList ownList;
    private boolean specialFilenameForWrongTestedVocables;

    public OwnListReader(String string, Map<String, Vocable> map) {
        this.name = string;
        this.keyToVocable = map;
        this.ownListCategory = "Default";
        this.ownListSubCategory = "Default";
        this.specialFilenameForWrongTestedVocables = false;
    }

    public void useSpecialFilenameForWrongTestedVocables(String string) {
        this.filename = string;
        this.specialFilenameForWrongTestedVocables = true;
    }

    public void read() {
        this.init();
        this.createFilename();
        this.readLines();
        this.parseLines();
        this.createOwnList();
    }

    private void init() {
        this.vocables = new ArrayList<Vocable>();
    }

    private void createFilename() {
        if (!this.specialFilenameForWrongTestedVocables) {
            this.filename = OwnList.determineFilename(this.name);
        }
    }

    private void readLines() {
        this.lines = FileHelper.readFileToList(this.filename, Charset.UTF_8);
    }

    private void parseLines() {
        int n = 0;
        for (String string : this.lines) {
            if (string.startsWith(OWN_LIST_CATEGORY_KEY)) {
                this.parseOnwListCategory(string);
                continue;
            }
            if (string.startsWith(OWN_LIST_SUB_CATEGORY_KEY)) {
                this.parseOnwListSubCategory(string);
                continue;
            }
            this.parseKey(string, ++n);
        }
    }

    private void parseOnwListCategory(String string) {
        DefinitionLineParser definitionLineParser = new DefinitionLineParser(string, this.filename);
        definitionLineParser.parse();
        String string2 = definitionLineParser.getKey();
        String string3 = definitionLineParser.getValue();
        if (!string2.equalsIgnoreCase(OWN_LIST_CATEGORY_KEY)) {
            throw new RuntimeException("Die Zeile mit der Kategorie der eigenen Liste enth\u00e4lt den falschen Schl\u00fcssel.\n\tfilename = '" + this.filename + "'.\n\tZeile    = '" + string + "'.\n\tkey      = '" + string2 + "'.\n\terwartet = 'own-list-category'.\nDie Gro\u00df-/Kleinschreibung spielt keine Rolle.");
        }
        if (!this.ownListCategory.equals("Default")) {
            throw new RuntimeException("Es gibt mehr als eine Kategorie der eigenen Liste.\n\tfilename   = '" + this.filename + "'.\n\tKategorie1 = '" + this.ownListCategory + "'.\n\tKategorie2 = '" + string3 + "'.\n");
        }
        this.ownListCategory = string3;
    }

    private void parseOnwListSubCategory(String string) {
        DefinitionLineParser definitionLineParser = new DefinitionLineParser(string, this.filename);
        definitionLineParser.parse();
        String string2 = definitionLineParser.getKey();
        String string3 = definitionLineParser.getValue();
        if (!string2.equalsIgnoreCase(OWN_LIST_SUB_CATEGORY_KEY)) {
            throw new RuntimeException("Die Zeile mit der Unterkategorie der eigenen Liste enth\u00e4lt den falschen Schl\u00fcssel.\n\tfilename = '" + this.filename + "'.\n\tZeile    = '" + string + "'.\n\tkey      = '" + string2 + "'.\n\terwartet = 'own-list-sub-category'.\nDie Gro\u00df-/Kleinschreibung spielt keine Rolle.");
        }
        if (!this.ownListSubCategory.equals("Default")) {
            throw new RuntimeException("Es gibt mehr als eine Unterkategorie der eigenen Liste.\n\tfilename        = '" + this.filename + "'.\n\tUnterkategorie1 = '" + this.ownListSubCategory + "'.\n\tUnterkategorie2 = '" + string3 + "'.\n");
        }
        this.ownListSubCategory = string3;
    }

    private void parseKey(String string, int n) {
        if (this.keyToVocable.containsKey(string)) {
            Vocable vocable = this.keyToVocable.get(string);
            this.vocables.add(vocable);
        } else {
            String string2 = "In der Liste '" + this.name + "' ist an Position " + n + " der Schl\u00fcssel '" + string + "' eingetragen.\nZu diesem Schl\u00fcssel ist aber keine Vokabel mehr bekannt.\nDaher wird er nicht f\u00fcr die Liste '" + this.name + "' verwendet!\n\nWollen Sie fortsetzen? Anderenfalls wird das Programm augenblicklich beendet.";
            System.out.println(string2 + "\n");
            boolean bl = GuiTools.askUser("Unbekannter Schl\u00fcssel", string2);
            if (!bl) {
                System.out.println("Abbruch durch den Benutzer.");
                System.exit(1);
            }
        }
    }

    private void createOwnList() {
        this.ownList = new OwnList(this.name, this.ownListCategory, this.ownListSubCategory, this.vocables);
    }

    public OwnList getOwnList() {
        return this.ownList;
    }
}

