/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.io;

import de.duehl.basics.io.FileHelper;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.io.VocabularyReader;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import java.util.ArrayList;
import java.util.List;

public class VocabularyDirectoryReader {
    private final String directory;
    private List<Vocabulary> vocabularies;

    public VocabularyDirectoryReader(String string) {
        this.directory = string;
    }

    public void read() {
        List<String> list = FileHelper.findFiles(this.directory, ".voc");
        this.vocabularies = new ArrayList<Vocabulary>();
        for (String string : list) {
            this.readVocabulary(string);
        }
    }

    private void readVocabulary(String string) {
        VocabularyReader vocabularyReader = new VocabularyReader(string);
        vocabularyReader.read();
        List<Vocable> list = vocabularyReader.getVocables();
        String string2 = VocabularyTools.vocabularyFilenameToDescription(string);
        String string3 = vocabularyReader.getVocabularyCategory();
        String string4 = vocabularyReader.getVocabularySubCategory();
        Vocabulary vocabulary = new Vocabulary(string2, list, string3, string4);
        this.vocabularies.add(vocabulary);
    }

    public List<Vocabulary> getVocabularies() {
        return this.vocabularies;
    }
}

