/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.sort;

import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import java.util.List;

public class VocableRelevanceWeightingCalculator {
    private static final int WEIGHTENING_KANA_EQUALS_SEARCH = 1;
    private static final int WEIGHTENING_KANJI_EQUALS_SEARCH = 2;
    private static final int WEIGHTENING_ROMAJI_EQUALS_SEARCH = 3;
    private static final int WEIGHTENING_PRONOUNCIATION_EQUALS_SEARCH = 4;
    private static final int WEIGHTENING_TRANSLATION_EQUALS_SEARCH = 5;
    private static final int WEIGHTENING_COMMENT_EQUALS_SEARCH = 6;
    private static final int WEIGHTENING_SEARCH_WORD_EQUALS_SEARCH = 7;
    private static final int WEIGHTENING_PART_OF_SPEACH_EQUALS_SEARCH = 8;
    private static final int WEIGHTENING_COMMENT_IN_JAPANESE_BRACES_SEARCH = 9;
    private static final int WEIGHTENING_ROMAJI_EQUALS_IGNORE_CASE_SENSIVITY_SEARCH = 10;
    private static final int WEIGHTENING_PRONOUNCIATION_EQUALS_IGNORE_CASE_SENSIVITY_SEARCH = 11;
    private static final int WEIGHTENING_TRANSLATION_EQUALS_IGNORE_CASE_SENSIVITY_SEARCH = 12;
    private static final int WEIGHTENING_COMPARE_KANA_EQUALS_COMPARE_SEARCH = 15;
    private static final int WEIGHTENING_COMPARE_KANJI_EQUALS_COMPARE_SEARCH = 16;
    private static final int WEIGHTENING_COMPARE_ROMAJI_EQUALS_COMPARE_SEARCH = 17;
    private static final int WEIGHTENING_COMPARE_TRANSLATION_EQUALS_COMPARE_SEARCH = 18;
    private static final int WEIGHTENING_KANA_STARTS_WITH_SEARCH = 21;
    private static final int WEIGHTENING_KANJI_STARTS_WITH_SEARCH = 22;
    private static final int WEIGHTENING_ROMAJI_STARTS_WITH_SEARCH = 23;
    private static final int WEIGHTENING_PRONOUNCIATION_STARTS_WITH_SEARCH = 24;
    private static final int WEIGHTENING_TRANSLATION_STARTS_WITH_SEARCH = 25;
    private static final int WEIGHTENING_COMMENT_STARTS_WITH_SEARCH = 26;
    private static final int WEIGHTENING_SEARCH_WORD_STARTS_WITH_SEARCH = 27;
    private static final int WEIGHTENING_PART_OF_SPEACH_STARTS_WITH_SEARCH = 28;
    private static final int WEIGHTENING_KANA_ENDS_WITH_SEARCH = 41;
    private static final int WEIGHTENING_KANJI_ENDS_WITH_SEARCH = 42;
    private static final int WEIGHTENING_ROMAJI_ENDS_WITH_SEARCH = 43;
    private static final int WEIGHTENING_PRONOUNCIATION_ENDS_WITH_SEARCH = 44;
    private static final int WEIGHTENING_TRANSLATION_ENDS_WITH_SEARCH = 45;
    private static final int WEIGHTENING_COMMENT_ENDS_WITH_SEARCH = 46;
    private static final int WEIGHTENING_SEARCH_WORD_ENDS_WITH_SEARCH = 47;
    private static final int WEIGHTENING_PART_OF_SPEACH_ENDS_WITH_SEARCH = 48;
    private static final int WEIGHTENING_KANA_CONTAINS_SEARCH_AS_SINGLE_WORD = 61;
    private static final int WEIGHTENING_KANJI_CONTAINS_SEARCH_AS_SINGLE_WORD = 62;
    private static final int WEIGHTENING_ROMAJI_CONTAINS_SEARCH_AS_SINGLE_WORD = 63;
    private static final int WEIGHTENING_PRONOUNCIATION_CONTAINS_SEARCH_AS_SINGLE_WORD = 64;
    private static final int WEIGHTENING_TRANSLATION_CONTAINS_SEARCH_AS_SINGLE_WORD = 65;
    private static final int WEIGHTENING_COMMENT_CONTAINS_SEARCH_AS_SINGLE_WORD = 66;
    private static final int WEIGHTENING_SEARCH_WORD_CONTAINS_SEARCH_AS_SINGLE_WORD = 67;
    private static final int WEIGHTENING_PART_OF_SPEACH_CONTAINS_SEARCH_AS_SINGLE_WORD = 68;
    private static final int NO_SPECIAL_WEIGHTENING = 999;
    private final Vocable vocable;
    private final String search;
    private String loweredCaseSearch;
    private final String compareSearch;
    private int weighting;
    private boolean weighteningFound;

    public VocableRelevanceWeightingCalculator(Vocable vocable, String string) {
        this.vocable = vocable;
        this.search = string;
        this.loweredCaseSearch = Text.toLowerCase(string);
        this.compareSearch = VocabularyTools.createCompareTranslation(string);
    }

    public void calculate() {
        this.init();
        this.checkIfEqualsSearch();
        this.checkIfSearchFulfillsSpecialConditions();
        this.checkIfSearchAgainstCompare();
        this.checkIfStartsWithSearch();
        this.checkIfEndsWithSearch();
        this.checkIfContainsSearchAsSingleWord();
    }

    private void init() {
        this.weighteningFound = false;
        this.weighting = 999;
    }

    private void checkIfEqualsSearch() {
        if (!this.weighteningFound) {
            this.checkIfKanaEqualsSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfKanjiEqualsSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfRomajiEqualsSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfPronunciationEqualsSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfTranslationEqualsSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfCommentEqualsSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfSearchWordEqualsSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfPartOfSpeachEqualsSearch();
        }
    }

    private void checkIfKanaEqualsSearch() {
        this.checkIfEqualsSearch(this.vocable.getKana(), 1);
    }

    private void checkIfKanjiEqualsSearch() {
        this.checkIfEqualsSearch(this.vocable.getKanji(), 2);
    }

    private void checkIfRomajiEqualsSearch() {
        this.checkIfEqualsSearch(this.vocable.getRomaji(), 3);
    }

    private void checkIfPronunciationEqualsSearch() {
        this.checkIfEqualsSearch(this.vocable.getPronunciation(), 4);
    }

    private void checkIfTranslationEqualsSearch() {
        this.checkIfAnyElementEqualsSearch(this.vocable.getTranslations(), 5);
    }

    private void checkIfCommentEqualsSearch() {
        this.checkIfEqualsSearch(this.vocable.getComment(), 6);
    }

    private void checkIfSearchWordEqualsSearch() {
        this.checkIfAnyElementEqualsSearch(this.vocable.getSearchWords(), 7);
    }

    private void checkIfPartOfSpeachEqualsSearch() {
        this.checkIfAnyElementEqualsSearch(this.vocable.getPartsOfSpeech(), 8);
    }

    private void checkIfAnyElementEqualsSearch(List<String> list, int n) {
        for (String string : list) {
            this.checkIfEqualsSearch(string, n);
            if (!this.weighteningFound) continue;
            return;
        }
    }

    private void checkIfEqualsSearch(String string, int n) {
        if (string.equals(this.search)) {
            this.weighteningFound = true;
            this.weighting = n;
        }
    }

    private void checkIfSearchFulfillsSpecialConditions() {
        if (!this.weighteningFound) {
            this.checkIfCommentContainesSearchInJapaneseBraces();
        }
        if (!this.weighteningFound) {
            this.checkIfRomajiEqualsIgnoreCaseSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfPronunciationEqualsIgnoreCaseSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfTranslationEqualsIgnoreCaseSearch();
        }
    }

    private void checkIfCommentContainesSearchInJapaneseBraces() {
        String string = this.vocable.getComment();
        if (string.contains("\u300c" + this.search + "\u300d")) {
            this.weighteningFound = true;
            this.weighting = 9;
        }
    }

    private void checkIfRomajiEqualsIgnoreCaseSearch() {
        this.checkIfEqualsIgnoreCaseSearch(this.vocable.getRomaji(), 10);
    }

    private void checkIfPronunciationEqualsIgnoreCaseSearch() {
        this.checkIfEqualsIgnoreCaseSearch(this.vocable.getPronunciation(), 11);
    }

    private void checkIfTranslationEqualsIgnoreCaseSearch() {
        this.checkIfAnyElementEqualsIgnoreCaseSearch(this.vocable.getCompareTranslations(), 12);
    }

    private void checkIfAnyElementEqualsIgnoreCaseSearch(List<String> list, int n) {
        for (String string : list) {
            this.checkIfEqualsIgnoreCaseSearch(string, n);
            if (!this.weighteningFound) continue;
            return;
        }
    }

    private void checkIfEqualsIgnoreCaseSearch(String string, int n) {
        if (string.equals(this.loweredCaseSearch)) {
            this.weighteningFound = true;
            this.weighting = n;
        }
    }

    private void checkIfSearchAgainstCompare() {
        if (!this.weighteningFound) {
            this.checkIfCompareKanaEqualsCompareSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfCompareKanjiEqualsCompareSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfCompareRomajiEqualsCompareSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfCompareTranslationEqualsCompareSearch();
        }
    }

    private void checkIfCompareKanaEqualsCompareSearch() {
        this.checkIfCompareEqualsCompareSearch(this.vocable.getCompareKana(), 15);
    }

    private void checkIfCompareKanjiEqualsCompareSearch() {
        this.checkIfCompareEqualsCompareSearch(this.vocable.getCompareKanji(), 16);
    }

    private void checkIfCompareRomajiEqualsCompareSearch() {
        this.checkIfCompareEqualsCompareSearch(this.vocable.getCompareRomaji(), 17);
    }

    private void checkIfCompareTranslationEqualsCompareSearch() {
        this.checkIfAnyCompareElementEqualsCompareSearch(this.vocable.getCompareTranslations(), 18);
    }

    private void checkIfAnyCompareElementEqualsCompareSearch(List<String> list, int n) {
        for (String string : list) {
            this.checkIfCompareEqualsCompareSearch(string, n);
            if (!this.weighteningFound) continue;
            return;
        }
    }

    private void checkIfCompareEqualsCompareSearch(String string, int n) {
        if (string.equals(this.compareSearch)) {
            this.weighteningFound = true;
            this.weighting = n;
        }
    }

    private void checkIfStartsWithSearch() {
        if (!this.weighteningFound) {
            this.checkIfKanaStartsWithSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfKanjiStartsWithSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfRomajiStartsWithSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfPronunciationStartsWithSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfTranslationStartsWithSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfCommentStartsWithSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfSearchWordStartsWithSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfPartOfSpeachStartsWithSearch();
        }
    }

    private void checkIfKanaStartsWithSearch() {
        this.checkIfStartsWithSearch(this.vocable.getKana(), 21);
    }

    private void checkIfKanjiStartsWithSearch() {
        this.checkIfStartsWithSearch(this.vocable.getKanji(), 22);
    }

    private void checkIfRomajiStartsWithSearch() {
        this.checkIfStartsWithSearch(this.vocable.getRomaji(), 23);
    }

    private void checkIfPronunciationStartsWithSearch() {
        this.checkIfStartsWithSearch(this.vocable.getPronunciation(), 24);
    }

    private void checkIfTranslationStartsWithSearch() {
        this.checkIfAnyElementStartsWithSearch(this.vocable.getTranslations(), 25);
    }

    private void checkIfCommentStartsWithSearch() {
        this.checkIfStartsWithSearch(this.vocable.getComment(), 26);
    }

    private void checkIfSearchWordStartsWithSearch() {
        this.checkIfAnyElementStartsWithSearch(this.vocable.getSearchWords(), 27);
    }

    private void checkIfPartOfSpeachStartsWithSearch() {
        this.checkIfAnyElementStartsWithSearch(this.vocable.getPartsOfSpeech(), 28);
    }

    private void checkIfAnyElementStartsWithSearch(List<String> list, int n) {
        for (String string : list) {
            this.checkIfStartsWithSearch(string, n);
            if (!this.weighteningFound) continue;
            return;
        }
    }

    private void checkIfStartsWithSearch(String string, int n) {
        if (string.startsWith(this.search)) {
            this.weighteningFound = true;
            this.weighting = n;
        }
    }

    private void checkIfEndsWithSearch() {
        if (!this.weighteningFound) {
            this.checkIfKanaEndsWithSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfKanjiEndsWithSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfRomajiEndsWithSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfPronunciationEndsWithSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfTranslationEndsWithSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfCommentEndsWithSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfSearchWordEndsWithSearch();
        }
        if (!this.weighteningFound) {
            this.checkIfPartOfSpeachEndsWithSearch();
        }
    }

    private void checkIfKanaEndsWithSearch() {
        this.checkIfEndsWithSearch(this.vocable.getKana(), 41);
    }

    private void checkIfKanjiEndsWithSearch() {
        this.checkIfEndsWithSearch(this.vocable.getKanji(), 42);
    }

    private void checkIfRomajiEndsWithSearch() {
        this.checkIfEndsWithSearch(this.vocable.getRomaji(), 43);
    }

    private void checkIfPronunciationEndsWithSearch() {
        this.checkIfEndsWithSearch(this.vocable.getPronunciation(), 44);
    }

    private void checkIfTranslationEndsWithSearch() {
        this.checkIfAnyElementEndsWithSearch(this.vocable.getTranslations(), 45);
    }

    private void checkIfCommentEndsWithSearch() {
        this.checkIfEndsWithSearch(this.vocable.getComment(), 46);
    }

    private void checkIfSearchWordEndsWithSearch() {
        this.checkIfAnyElementEndsWithSearch(this.vocable.getSearchWords(), 47);
    }

    private void checkIfPartOfSpeachEndsWithSearch() {
        this.checkIfAnyElementEndsWithSearch(this.vocable.getPartsOfSpeech(), 48);
    }

    private void checkIfAnyElementEndsWithSearch(List<String> list, int n) {
        for (String string : list) {
            this.checkIfEndsWithSearch(string, n);
            if (!this.weighteningFound) continue;
            return;
        }
    }

    private void checkIfEndsWithSearch(String string, int n) {
        if (string.endsWith(this.search)) {
            this.weighteningFound = true;
            this.weighting = n;
        }
    }

    private void checkIfContainsSearchAsSingleWord() {
        if (!this.weighteningFound) {
            this.checkIfKanaContainsSearchAsSingleWord();
        }
        if (!this.weighteningFound) {
            this.checkIfKanjiContainsSearchAsSingleWord();
        }
        if (!this.weighteningFound) {
            this.checkIfRomajiContainsSearchAsSingleWord();
        }
        if (!this.weighteningFound) {
            this.checkIfPronunciationContainsSearchAsSingleWord();
        }
        if (!this.weighteningFound) {
            this.checkIfTranslationContainsSearchAsSingleWord();
        }
        if (!this.weighteningFound) {
            this.checkIfCommentContainsSearchAsSingleWord();
        }
        if (!this.weighteningFound) {
            this.checkIfSearchWordContainsSearchAsSingleWord();
        }
        if (!this.weighteningFound) {
            this.checkIfPartOfSpeachContainsSearchAsSingleWord();
        }
    }

    private void checkIfKanaContainsSearchAsSingleWord() {
        this.checkIfContainsSearchAsSingleWord(this.vocable.getKana(), 61);
    }

    private void checkIfKanjiContainsSearchAsSingleWord() {
        this.checkIfContainsSearchAsSingleWord(this.vocable.getKanji(), 62);
    }

    private void checkIfRomajiContainsSearchAsSingleWord() {
        this.checkIfContainsSearchAsSingleWord(this.vocable.getRomaji(), 63);
    }

    private void checkIfPronunciationContainsSearchAsSingleWord() {
        this.checkIfContainsSearchAsSingleWord(this.vocable.getPronunciation(), 64);
    }

    private void checkIfTranslationContainsSearchAsSingleWord() {
        this.checkIfAnyElementContainsSearchAsSingleWord(this.vocable.getTranslations(), 65);
    }

    private void checkIfCommentContainsSearchAsSingleWord() {
        this.checkIfContainsSearchAsSingleWord(this.vocable.getComment(), 66);
    }

    private void checkIfSearchWordContainsSearchAsSingleWord() {
        this.checkIfAnyElementContainsSearchAsSingleWord(this.vocable.getSearchWords(), 67);
    }

    private void checkIfPartOfSpeachContainsSearchAsSingleWord() {
        this.checkIfAnyElementContainsSearchAsSingleWord(this.vocable.getPartsOfSpeech(), 68);
    }

    private void checkIfAnyElementContainsSearchAsSingleWord(List<String> list, int n) {
        for (String string : list) {
            this.checkIfContainsSearchAsSingleWord(string, n);
            if (!this.weighteningFound) continue;
            return;
        }
    }

    private void checkIfContainsSearchAsSingleWord(String string, int n) {
        if (string.contains(" " + this.search + " ")) {
            this.weighteningFound = true;
            this.weighting = n;
        }
    }

    public int getWeighting() {
        return this.weighting;
    }
}

