/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.io;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanjiData;
import de.duehl.vocabulary.japanese.common.persistence.SessionManager;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.RealInternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.startup.ui.data.MessageAppender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InternalKanjiDataReader {
    public static final String INTERNAL_KANJI_DATA_DIRECTORY = FileHelper.concatPathes(SessionManager.VOCABLE_TRAINER_DIRECTORY, "internal_kanji_data");
    private static final String INTERNAL_KANJI_DATA_EXTENSION = ".ikd";
    private final MessageAppender messageAppender;
    private Map<String, InternalAdditionalKanjiData> key2InternalKanjiDataMap;
    private RealInternalKanjiDataRequester requester;
    private final List<String> warningLines;

    public InternalKanjiDataReader(MessageAppender messageAppender) {
        this.messageAppender = messageAppender;
        this.warningLines = new ArrayList<String>();
    }

    public void read() {
        this.readInternalKanjiData();
        this.checkForNewKanji();
        this.checkForUnusedInternalKanjiData();
        this.createRequester();
    }

    private void readInternalKanjiData() {
        Object object;
        this.appendMessage("Lese interne benutzerabh\u00e4ngige Daten zu allen bekannten Kanji ...");
        FileHelper.createDirectoryIfNotExists(INTERNAL_KANJI_DATA_DIRECTORY);
        List<String> list = FileHelper.findFilesInMainDirectoryNio2WithExtensions(INTERNAL_KANJI_DATA_DIRECTORY, INTERNAL_KANJI_DATA_EXTENSION);
        this.appendMessage(NumberString.taupu(list.size()) + " interne Kanji-Datens\u00e4tze gefunden.");
        this.appendMessage("Lese interne Kanji-Datens\u00e4tze ein ...");
        ArrayList<InternalAdditionalKanjiData> arrayList = new ArrayList<InternalAdditionalKanjiData>();
        for (String object2 : list) {
            object = InternalAdditionalKanjiData.load(object2);
            arrayList.add((InternalAdditionalKanjiData)object);
        }
        this.appendMessage(NumberString.taupu(arrayList.size()) + " interne Kanji-Datens\u00e4tze eingelesen.");
        this.key2InternalKanjiDataMap = new HashMap<String, InternalAdditionalKanjiData>();
        for (InternalAdditionalKanjiData internalAdditionalKanjiData : arrayList) {
            object = internalAdditionalKanjiData.getKey();
            if (this.key2InternalKanjiDataMap.containsKey(object)) {
                throw new RuntimeException("Der Schl\u00fcssel '" + (String)object + "' kommt mehrfach vor!");
            }
            this.key2InternalKanjiDataMap.put((String)object, internalAdditionalKanjiData);
        }
        this.appendMessage("Verzeichnis mit " + NumberString.taupu(this.key2InternalKanjiDataMap.size()) + " Verweisen von Schl\u00fcssel auf interne Kanji-Datens\u00e4tze aufgebaut.");
    }

    private void checkForNewKanji() {
        int n = 0;
        for (Kanji kanji : Kanji.getAllKanjiAsList()) {
            String string = kanji.name();
            if (this.key2InternalKanjiDataMap.containsKey(string)) continue;
            InternalAdditionalKanjiData internalAdditionalKanjiData = new InternalAdditionalKanjiData();
            internalAdditionalKanjiData.setKey(string);
            String string2 = FileHelper.concatPathes(INTERNAL_KANJI_DATA_DIRECTORY, string + INTERNAL_KANJI_DATA_EXTENSION);
            internalAdditionalKanjiData.setFilename(string2);
            internalAdditionalKanjiData.setFirstSeenDate(new ImmutualDate());
            this.appendMessage("neu: " + string2);
            ++n;
            internalAdditionalKanjiData.save();
            this.key2InternalKanjiDataMap.put(string, internalAdditionalKanjiData);
        }
        this.appendMessage(NumberString.taupu(n) + " neue interne Kanji-Daten angelegt.");
    }

    private void checkForUnusedInternalKanjiData() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.key2InternalKanjiDataMap.keySet());
        for (Object object : Kanji.getAllKanjiAsList()) {
            String string = object.name();
            if (!arrayList.contains(string)) continue;
            arrayList.remove(string);
        }
        if (arrayList.isEmpty()) {
            this.appendMessage("Alle interne Daten zu Kanji wurden einem Kanji zugeordnet.");
        } else {
            Object object;
            String string = NumberString.germanPlural(arrayList.size(), "interne Daten", "internes Datum");
            object = NumberString.germanPlural(arrayList.size(), "welche", "welches");
            this.warningLines.add("Es gibt " + NumberString.taupu(arrayList.size()) + " " + (String)string + " zu Kanji, " + (String)object + " keinem Kanji zugeordnet wurden:");
            for (String string2 : arrayList) {
                this.warningLines.add("    " + string2);
            }
            for (String string2 : this.warningLines) {
                this.appendMessage(string2);
            }
        }
    }

    private void createRequester() {
        this.requester = new RealInternalKanjiDataRequester(this.key2InternalKanjiDataMap);
    }

    private void appendMessage(String string) {
        this.messageAppender.appendMessage(string);
    }

    public RealInternalKanjiDataRequester getRequester() {
        return this.requester;
    }

    public List<String> getWarningLines() {
        return this.warningLines;
    }
}

