/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.startup.logic.steps;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.internal.RealInternalDataRequester;
import de.duehl.vocabulary.japanese.startup.logic.StartupLoader;
import de.duehl.vocabulary.japanese.startup.logic.steps.StartupStep;
import de.duehl.vocabulary.japanese.startup.ui.data.SplashScreenable;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Step05JoinVocablesAndInternalData
extends StartupStep {
    private final List<Vocabulary> vocabularies;
    private final Map<String, InternalAdditionalVocableData> key2InternalDataMap;
    private final List<String> allKeysFromReadInternalData;
    private Map<Vocable, InternalAdditionalVocableData> vocable2InternalDataMap;
    private int newInternalDataCreationCounter;
    private List<String> unusedKeysFromReadInternalData;
    private List<String> seenKeysFromVocables;
    private List<String> multipleCreatedKeysFromVocables;
    private InternalDataRequester internalDataRequester;

    public Step05JoinVocablesAndInternalData(String string, Options options, SplashScreenable splashScreenable, StopWatch stopWatch, List<Vocabulary> list, Map<String, InternalAdditionalVocableData> map, List<String> list2) {
        super(string, options, splashScreenable, stopWatch);
        this.vocabularies = list;
        this.key2InternalDataMap = map;
        this.allKeysFromReadInternalData = list2;
    }

    @Override
    protected void runInternalStep() {
        ArrayList<String> arrayList;
        this.appendMessage("Verbinde die Vokabeln mit den internen benutzerabh\u00e4ngigen Daten ...");
        this.vocable2InternalDataMap = new HashMap<Vocable, InternalAdditionalVocableData>();
        this.newInternalDataCreationCounter = 0;
        this.unusedKeysFromReadInternalData = new ArrayList<String>();
        this.unusedKeysFromReadInternalData.addAll(this.allKeysFromReadInternalData);
        this.seenKeysFromVocables = new ArrayList<String>();
        this.multipleCreatedKeysFromVocables = new ArrayList<String>();
        for (Vocabulary iterator : this.vocabularies) {
            for (Vocable vocable : iterator.getVocables()) {
                this.joinVocableInternalData(vocable);
            }
        }
        this.appendMessage("Verzeichnis mit " + NumberString.taupu(this.vocable2InternalDataMap.size()) + " Verweisen von Vokabeln auf interne Datens\u00e4tze aufgebaut.");
        this.appendMessage(NumberString.taupu(this.newInternalDataCreationCounter) + " neue interne Daten angelegt.");
        if (this.unusedKeysFromReadInternalData.isEmpty()) {
            this.appendMessage("Alle interne Daten zu Vokabeln wurden einer Vokabel zugeordnet.");
        } else {
            arrayList = new ArrayList();
            String string = NumberString.germanPlural(this.unusedKeysFromReadInternalData.size(), "interne Daten", "internes Datum");
            String string2 = NumberString.germanPlural(this.unusedKeysFromReadInternalData.size(), "welche", "welches");
            arrayList.add("Es gibt " + NumberString.taupu(this.unusedKeysFromReadInternalData.size()) + " " + string + " zu Vokabeln, " + string2 + " keiner Vokabel zugeordnet wurden:");
            for (String string3 : this.unusedKeysFromReadInternalData) {
                arrayList.add("    " + string3);
            }
            String string4 = Text.joinWithLineBreak(arrayList);
            this.appendMessage(string4);
            this.warningsInStep(string4);
        }
        if (this.multipleCreatedKeysFromVocables.isEmpty()) {
            this.appendMessage("Alle Vokabeln erzeugen unterschiedliche Schl\u00fcssel.");
            this.internalDataRequester = new RealInternalDataRequester(this.vocable2InternalDataMap);
        } else {
            arrayList = new ArrayList<String>();
            arrayList.add("Es gibt " + NumberString.taupu(this.multipleCreatedKeysFromVocables.size()) + " Schl\u00fcssel, welche zu mehr als einer Vokabel geh\u00f6ren");
            for (String string : this.multipleCreatedKeysFromVocables) {
                arrayList.add("    " + string);
            }
            for (String string : arrayList) {
                this.appendMessage(string);
            }
            this.errorsInStep(Text.joinWithLineBreak(arrayList));
        }
    }

    private void joinVocableInternalData(Vocable vocable) {
        InternalAdditionalVocableData internalAdditionalVocableData;
        String string = VocabularyTools.createVocableKey(vocable);
        this.unusedKeysFromReadInternalData.remove(string);
        if (this.seenKeysFromVocables.contains(string)) {
            if (!this.multipleCreatedKeysFromVocables.contains(string)) {
                this.multipleCreatedKeysFromVocables.add(string);
            }
        } else {
            this.seenKeysFromVocables.add(string);
        }
        if (this.key2InternalDataMap.containsKey(string)) {
            internalAdditionalVocableData = this.key2InternalDataMap.get(string);
        } else {
            internalAdditionalVocableData = new InternalAdditionalVocableData();
            internalAdditionalVocableData.setKey(string);
            String string2 = FileHelper.concatPathes(StartupLoader.INTERNAL_DATA_DIRECTORY, string + ".ivd");
            internalAdditionalVocableData.setFilename(string2);
            internalAdditionalVocableData.setFirstSeenDate(new ImmutualDate());
            this.appendMessage("neu: " + string2);
            ++this.newInternalDataCreationCounter;
            internalAdditionalVocableData.save();
        }
        this.vocable2InternalDataMap.put(vocable, internalAdditionalVocableData);
    }

    public Map<Vocable, InternalAdditionalVocableData> getVocable2InternalDataMap() {
        return this.vocable2InternalDataMap;
    }

    public InternalDataRequester getInternalDataRequester() {
        return this.internalDataRequester;
    }
}

