/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kanji.detail;

import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.swing.logic.Quitter;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.components.selections.tools.SelectionsHelper;
import de.duehl.swing.ui.dialogs.base.additional.LocationGetter;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanjiData;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.display.KanjiGermanMeaningAndLesungenPanel;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.display.KanjiPanel;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.display.findlists.SetsWithKanjiFinder;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.table.components.AllVocablesWithKanjiShower;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class KanjiDetailPanel {
    private static final int WANTED_WIDTH = 700;
    private static final int WANTED_KANJI_AND_INTERNAL_HEIGHT = 900;
    private final Kanji kanji;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final LongTimeProcessInformer informer;
    private LocationGetter locationGetter;
    private final Quitter quitter;
    private final JPanel panel;
    private final KanjiPanel kanjiPanel;
    private final StringSelection kanjiAsCharacterSeletion;
    private final KanjiGermanMeaningAndLesungenPanel kanjiGermanMeaningAnLesungenPanel;
    private final StringSelection numberInKanjiAndKanaBookSelection;
    private final StringSelection pageNumberInKanjiAndKanaBookSelection;
    private final StringSelection numberInMyHandwrittenKanjiNotebooksSelection;
    private final StringSelection firstSeenDateSelection;
    private final StringSelection testCountSelection;
    private final StringSelection correctTestCountSelection;
    private final StringSelection lastTestDatetSelection;
    private final StringSelection lastCorrectTestDateSelection;
    private final StringSelection lastTenTestResultsSelection;
    private final JButton showAllVocableWithKanjiButton;
    private final JButton showAllKanjiSetsWithKanjiButton;
    private SetsWithKanjiFinder setsWithKanjiFinder;
    private final JButton okButton;

    public KanjiDetailPanel(Kanji kanji, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, LongTimeProcessInformer longTimeProcessInformer, Component component, LocationGetter locationGetter, Quitter quitter) {
        this.kanji = kanji;
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.informer = longTimeProcessInformer;
        this.locationGetter = locationGetter;
        this.quitter = quitter;
        this.panel = new JPanel();
        this.kanjiPanel = new KanjiPanel();
        this.kanjiPanel.setBiggerFontSize(200);
        this.kanjiPanel.showKanji(kanji);
        this.kanjiGermanMeaningAnLesungenPanel = new KanjiGermanMeaningAndLesungenPanel(kanji);
        this.kanjiAsCharacterSeletion = new StringSelection("Das Kanji (noch einmal zum rauskopieren)");
        this.kanjiAsCharacterSeletion.setText(kanji.getCharacter());
        this.numberInKanjiAndKanaBookSelection = new StringSelection("Nummer im Buch 'Kanji und Kana' von Wolfgang Hadamitzky");
        this.pageNumberInKanjiAndKanaBookSelection = new StringSelection("Seite im Buch 'Kanji und Kana' von Wolfgang Hadamitzky");
        this.numberInMyHandwrittenKanjiNotebooksSelection = new StringSelection("Nummer in meinen handschriftlichen Heften");
        this.firstSeenDateSelection = new StringSelection("Zuerst gesehen");
        this.testCountSelection = new StringSelection("Anzahl Test");
        this.correctTestCountSelection = new StringSelection("Anzahl erfolgreicher Test");
        this.lastTestDatetSelection = new StringSelection("zuletzt getestet am");
        this.lastCorrectTestDateSelection = new StringSelection("zuletzt erfolgreich getestet am");
        this.lastTenTestResultsSelection = new StringSelection("Erfolg der letzten Tests");
        this.setsWithKanjiFinder = new SetsWithKanjiFinder(fumikoDataStructures, component);
        this.showAllVocableWithKanjiButton = new JButton("Zeige alle Vokabeln mit diesem Kanji an");
        this.showAllKanjiSetsWithKanjiButton = new JButton("Zeige alle Kanji-Mengen mit diesem Kanji an");
        this.okButton = new JButton("Beenden");
        this.init();
        this.showKanjiInterna();
        this.populatePanel();
    }

    private void init() {
        this.initPanel();
        this.initOkButton();
        this.initSelections();
        this.initKanjiButtons();
    }

    private void initPanel() {
        this.panel.setLayout(new BorderLayout());
    }

    private void initOkButton() {
        this.okButton.addActionListener(actionEvent -> this.quitter.quit());
    }

    private void initSelections() {
        SelectionsHelper.initSelectionAsFocusableViewer(this.kanjiAsCharacterSeletion);
        SelectionsHelper.initSelectionAsFocusableViewer(this.numberInKanjiAndKanaBookSelection);
        SelectionsHelper.initSelectionAsFocusableViewer(this.pageNumberInKanjiAndKanaBookSelection);
        SelectionsHelper.initSelectionAsFocusableViewer(this.numberInMyHandwrittenKanjiNotebooksSelection);
        SelectionsHelper.initSelectionAsFocusableViewer(this.firstSeenDateSelection);
        SelectionsHelper.initSelectionAsFocusableViewer(this.testCountSelection);
        SelectionsHelper.initSelectionAsFocusableViewer(this.correctTestCountSelection);
        SelectionsHelper.initSelectionAsFocusableViewer(this.lastTestDatetSelection);
        SelectionsHelper.initSelectionAsFocusableViewer(this.lastCorrectTestDateSelection);
        SelectionsHelper.initSelectionAsFocusableViewer(this.lastTenTestResultsSelection);
    }

    private void initKanjiButtons() {
        this.showAllVocableWithKanjiButton.addActionListener(actionEvent -> this.showAllVocablesWithKanji());
        this.showAllKanjiSetsWithKanjiButton.addActionListener(actionEvent -> this.showAllKanjiSetsWithKanji());
    }

    private void showAllVocablesWithKanji() {
        AllVocablesWithKanjiShower allVocablesWithKanjiShower = new AllVocablesWithKanjiShower(this.dataStructures, this.uiObjects, this.locationGetter.getLocation(), this.informer);
        allVocablesWithKanjiShower.showKanji(this.kanji);
    }

    private void showAllKanjiSetsWithKanji() {
        this.setsWithKanjiFinder.findKanjiSetsWithKanji(this.kanji);
    }

    private void showKanjiInterna() {
        this.numberInKanjiAndKanaBookSelection.setText(this.kanji.getNumberInKanjiAndKanaBook());
        this.pageNumberInKanjiAndKanaBookSelection.setText(this.kanji.getPageNumberInKanjiAndKanaBook());
        this.numberInMyHandwrittenKanjiNotebooksSelection.setText(this.kanji.getNumberInMyHandwrittenKanjiNotebooks());
        InternalKanjiDataRequester internalKanjiDataRequester = this.dataStructures.getInternalKanjiDataRequester();
        InternalAdditionalKanjiData internalAdditionalKanjiData = internalKanjiDataRequester.getInternalDataForKanji(this.kanji);
        this.firstSeenDateSelection.setText(internalAdditionalKanjiData.getFirstSeenDate().toString());
        this.testCountSelection.setText(internalAdditionalKanjiData.getTestCount());
        this.correctTestCountSelection.setText(internalAdditionalKanjiData.getCorrectTestCount());
        this.lastTestDatetSelection.setText(internalAdditionalKanjiData.getLastTestDate().toString());
        this.lastCorrectTestDateSelection.setText(internalAdditionalKanjiData.getLastCorrectTestDate().toString());
        this.lastTenTestResultsSelection.setText(internalAdditionalKanjiData.getLastTenTestResultsAsStorageString());
    }

    private void populatePanel() {
        this.panel.add(this.createCenterPart(), "Center");
        this.panel.add(this.createButtonsPart(), "South");
        SwingUtilities.invokeLater(() -> this.okButton.requestFocus());
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        GuiTools.createTitle(jPanel);
        jPanel.add(this.createKanjiWithDetailsPartScroll());
        jPanel.add(this.createKanjiButtonsPart());
        return jPanel;
    }

    private Component createKanjiWithDetailsPartScroll() {
        JScrollPane jScrollPane = GuiTools.createScrollPane(this.createKanjiWithDetailsPart());
        jScrollPane.setPreferredSize(new Dimension(700, 900));
        return jScrollPane;
    }

    private Component createKanjiWithDetailsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.kanjiPanel.getPanel());
        jPanel.add(this.kanjiAsCharacterSeletion.getPanel());
        jPanel.add(this.kanjiGermanMeaningAnLesungenPanel.getPanel());
        jPanel.add(this.createInternalKanjiDataPart());
        return jPanel;
    }

    private Component createInternalKanjiDataPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.numberInKanjiAndKanaBookSelection.getPanel());
        jPanel.add(this.pageNumberInKanjiAndKanaBookSelection.getPanel());
        if (this.dataStructures.getOptions().isShowKanjiNumberInMyHandwrittenKanjiNotebooks()) {
            jPanel.add(this.numberInMyHandwrittenKanjiNotebooksSelection.getPanel());
        }
        jPanel.add(this.firstSeenDateSelection.getPanel());
        jPanel.add(this.testCountSelection.getPanel());
        jPanel.add(this.correctTestCountSelection.getPanel());
        jPanel.add(this.lastTestDatetSelection.getPanel());
        jPanel.add(this.lastCorrectTestDateSelection.getPanel());
        jPanel.add(this.lastTenTestResultsSelection.getPanel());
        return jPanel;
    }

    private Component createKanjiButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.showAllVocableWithKanjiButton);
        jPanel.add(this.showAllKanjiSetsWithKanjiButton);
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.okButton, "East");
        return jPanel;
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

